/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.draft;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.UserFriendlyException;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.plugin.layer.draft.Draft;
import com.vividsolutions.jump.workbench.ui.plugin.layer.draft.DraftData;
import de.riwagis.geotools.feature.util.FeatureTypeUtil;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.util.ThrowingBiFunction;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang.BooleanUtils;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicDrafts {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphicDrafts.class);
    private static final Map<Class<?>, Function<String, ?>> TYPE_MAPPING = Map.of(String.class, Function.identity(), Long.class, Long::valueOf, BigDecimal.class, BigDecimal::new, Integer.class, Integer::valueOf, Short.class, Short::valueOf, Byte.class, Byte::valueOf, Boolean.class, BooleanUtils::toBoolean, Float.class, Float::valueOf, Double.class, Double::valueOf, Date.class, value -> Date.from(Instant.parse(value)));
    private static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    private static final String TABLE_RIWA_DRAFT = "riwa_draft";
    private static final String TABLE_RIWA_DRAFT_DATA = "riwa_draft_data";
    private static final String ATTRIBUTE_COLUMN_VALUE_OBJECT = "column_value_object";
    private static final String ATTRIBUTE_CHK_GRAPHICDRAFT = "chk_graphicdraft";
    private static final String ATTRIBUTE_TABLE_NAME = "table_name";
    private static final String ATTRIBUTE_ID_RIWA_DRAFT = "id_riwa_draft";
    private static final String ATTRIBUTE_COLUMN_NAME = "column_name";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_DRAFT_NAME = "draft_name";
    private static final String ATTRIBUTE_DESCRIPTION = "description";

    public static Collection<Draft> getGraphicDrafts(Layer currentLayer) {
        boolean useUpperCase = GraphicDrafts.requiresUpperCase(currentLayer);
        List drafts = GraphicDrafts.dbOperation(currentLayer, Collections.emptyList(), GraphicDrafts.attr(useUpperCase, TABLE_RIWA_DRAFT), (source, fmd) -> GraphicDrafts.mapAndCollect(source, GraphicDrafts.getDraftQuery(useUpperCase, fmd), f -> new Draft(Integer.parseInt(GraphicDrafts.attr(useUpperCase, f, ATTRIBUTE_ID).toString()), (String)GraphicDrafts.attr(useUpperCase, f, ATTRIBUTE_DRAFT_NAME), (String)GraphicDrafts.attr(useUpperCase, f, ATTRIBUTE_DESCRIPTION))));
        Collections.sort(drafts, Comparator.comparing(Draft::getName));
        return drafts;
    }

    public static boolean hasGraphicDrafts(Layer currentLayer) {
        boolean useUpperCase = GraphicDrafts.requiresUpperCase(currentLayer);
        return GraphicDrafts.dbOperation(currentLayer, false, GraphicDrafts.attr(useUpperCase, TABLE_RIWA_DRAFT), (source, fmd) -> source.getCount(GraphicDrafts.getDraftQuery(useUpperCase, fmd)) > 0);
    }

    public static boolean isAllowedForGraphicDrafts(Layer currentLayer, Draft draft) {
        boolean useUpperCase = GraphicDrafts.requiresUpperCase(currentLayer);
        return GraphicDrafts.dbOperation(currentLayer, false, GraphicDrafts.attr(useUpperCase, TABLE_RIWA_DRAFT), (source, fmd) -> source.getCount(GraphicDrafts.getDraftIdQuery(useUpperCase, draft.getId())) > 0);
    }

    private static Query getDraftIdQuery(boolean useUpperCase, int id) {
        PropertyIsEqualTo isDraftId = FF.equal((Expression)FF.property(GraphicDrafts.attr(useUpperCase, ATTRIBUTE_ID)), (Expression)FF.literal(id), false);
        PropertyIsEqualTo isDraftForGraphics = FF.equal((Expression)FF.property(GraphicDrafts.attr(useUpperCase, ATTRIBUTE_CHK_GRAPHICDRAFT)), (Expression)FF.literal((Object)"1"), false);
        And filter = FF.and((Filter)isDraftId, (Filter)isDraftForGraphics);
        Query query = new Query(GraphicDrafts.attr(useUpperCase, TABLE_RIWA_DRAFT), (Filter)filter);
        query.setPropertyNames(new String[]{GraphicDrafts.attr(useUpperCase, ATTRIBUTE_ID)});
        return query;
    }

    public static boolean areGraphicDraftsPossible(DataStore dataStore, String typeName) {
        boolean useUpperCase = GraphicDrafts.requiresUpperCase(typeName);
        return GraphicDrafts.isTypeWellDefined(dataStore, useUpperCase, TABLE_RIWA_DRAFT, List.of(ATTRIBUTE_CHK_GRAPHICDRAFT)) && GraphicDrafts.isTypeWellDefined(dataStore, useUpperCase, TABLE_RIWA_DRAFT_DATA, List.of(ATTRIBUTE_COLUMN_VALUE_OBJECT));
    }

    public static SimpleFeature createFeatureFromDraft(Layer layer, Draft draft, Geometry geometry, SimpleFeature attributesToCopyOver) {
        if (draft == Draft.NONE || draft == null) {
            return GraphicDrafts.createFeatureAndCopyOverData(layer.getFeatureType(), geometry, attributesToCopyOver);
        }
        if (!GraphicDrafts.isAllowedForGraphicDrafts(layer, draft)) {
            EditingPanel.instanceOf().updateDrafts();
            throw new UserFriendlyException(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.layer.draft.GraphicDrafts.draft-no-longer-allowed"));
        }
        boolean useUpperCase = GraphicDrafts.requiresUpperCase(layer);
        Collection draftData = GraphicDrafts.dbOperation(layer, Collections.emptyList(), GraphicDrafts.attr(useUpperCase, TABLE_RIWA_DRAFT_DATA), (source, fmd) -> GraphicDrafts.mapAndCollect(source, GraphicDrafts.getDataDraftQuery(useUpperCase, draft), f -> new DraftData((String)GraphicDrafts.attr(useUpperCase, f, ATTRIBUTE_COLUMN_NAME), (String)GraphicDrafts.attr(useUpperCase, f, ATTRIBUTE_COLUMN_VALUE_OBJECT))));
        if (draftData.isEmpty()) {
            throw new UserFriendlyException(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.layer.draft.GraphicDrafts.no-data-error"));
        }
        SimpleFeatureType reducedType = GraphicDrafts.getReducedFeatureType(layer, useUpperCase, draftData);
        SimpleFeature feature = GraphicDrafts.createFeatureAndCopyOverData(reducedType, geometry, attributesToCopyOver);
        feature.getUserData().put("FEATUREWRITER_KEEP_ALL_ATTRIBUTES", true);
        draftData.forEach(field -> {
            String column = GraphicDrafts.attr(useUpperCase, field.getColumn());
            if (!FeatureUtil.hasAttribute((SimpleFeature)feature, (String)column)) {
                log.warn("Feature type of layer '{}' does not contain attribute '{}' from draft '{}'.", new Object[]{layer.getName(), column, draft.getName()});
                return;
            }
            String value = field.getValue();
            Class binding = feature.getFeatureType().getDescriptor(column).getType().getBinding();
            Function<String, ?> mapper = TYPE_MAPPING.get(binding);
            if (mapper == null) {
                log.error("There is no mapping provider for type '{}'", (Object)binding.getName());
            }
            try {
                Object typedValue = mapper.apply(value);
                feature.setAttribute(column, typedValue);
            }
            catch (Exception e) {
                log.error("Could not map draft column " + column + " to feature.", (Throwable)e);
            }
        });
        return feature;
    }

    private static SimpleFeature createFeatureAndCopyOverData(SimpleFeatureType type, Geometry geometry, SimpleFeature attributesToCopyOver) throws IllegalAttributeException {
        SimpleFeature feature = FeatureUtil.createFeature((SimpleFeatureType)type, (Geometry)geometry);
        if (attributesToCopyOver != null) {
            FeatureUtil.copyFeatureData((SimpleFeature)attributesToCopyOver, (SimpleFeature)feature);
        }
        return feature;
    }

    private static boolean isTypeWellDefined(DataStore dataStore, boolean useUpperCase, String type, List<String> attributes) {
        if (useUpperCase) {
            List<String> upperCaseAttributes = attributes.stream().map(String::toUpperCase).collect(Collectors.toList());
            return GraphicDrafts.isTypeWellDefined(dataStore, type.toUpperCase(), upperCaseAttributes);
        }
        return GraphicDrafts.isTypeWellDefined(dataStore, type, attributes);
    }

    private static boolean isTypeWellDefined(DataStore dataStore, String type, List<String> attributes) {
        boolean typeExists = Stream.of(dataStore.getTypeNames()).anyMatch(name -> name.equalsIgnoreCase(type));
        if (!typeExists) {
            return false;
        }
        SimpleFeatureType schema = dataStore.getSchema(type);
        for (String attribute : attributes) {
            if (schema.getDescriptor(attribute) != null) continue;
            return false;
        }
        return true;
    }

    private static <T, E extends Exception> T dbOperation(Layer currentLayer, T orElse, String typeName, ThrowingBiFunction<SimpleFeatureSource, FeaturestoreMetadata, T, E> operation) {
        Task task = currentLayer.getLayerManager().getTask();
        DMDCollection dataStores = task.getDataStores();
        FeaturestoreMetadata fmd = currentLayer.getFMD();
        if (dataStores.getByName(fmd.getDatastoreName()) == null) {
            return orElse;
        }
        DataStore dataStore = fmd.getDataStore(dataStores);
        SimpleFeatureSource riwaDraftSource = dataStore.getFeatureSource(typeName);
        return operation.apply(riwaDraftSource, fmd);
    }

    private static Query getDraftQuery(boolean useUpperCase, FeaturestoreMetadata fmd) {
        String name = fmd.getWriteableType().toLowerCase();
        PropertyIsEqualTo hasTableDrafts = FF.equal((Expression)FF.property(GraphicDrafts.attr(useUpperCase, ATTRIBUTE_TABLE_NAME)), (Expression)FF.literal((Object)name), false);
        PropertyIsEqualTo isDraftForGraphics = FF.equal((Expression)FF.property(GraphicDrafts.attr(useUpperCase, ATTRIBUTE_CHK_GRAPHICDRAFT)), (Expression)FF.literal((Object)"1"), false);
        And filter = FF.and((Filter)hasTableDrafts, (Filter)isDraftForGraphics);
        Query query = new Query(GraphicDrafts.attr(useUpperCase, TABLE_RIWA_DRAFT), (Filter)filter);
        query.setPropertyNames(new String[]{GraphicDrafts.attr(useUpperCase, ATTRIBUTE_ID), GraphicDrafts.attr(useUpperCase, ATTRIBUTE_DRAFT_NAME), GraphicDrafts.attr(useUpperCase, ATTRIBUTE_DESCRIPTION)});
        return query;
    }

    private static Query getDataDraftQuery(boolean useUpperCase, Draft draft) {
        PropertyIsEqualTo isDraftId = FF.equal((Expression)FF.property(GraphicDrafts.attr(useUpperCase, ATTRIBUTE_ID_RIWA_DRAFT)), (Expression)FF.literal(draft.getId()), false);
        Query query = new Query(GraphicDrafts.attr(useUpperCase, TABLE_RIWA_DRAFT_DATA), (Filter)isDraftId);
        query.setPropertyNames(new String[]{GraphicDrafts.attr(useUpperCase, ATTRIBUTE_COLUMN_NAME), GraphicDrafts.attr(useUpperCase, ATTRIBUTE_COLUMN_VALUE_OBJECT)});
        return query;
    }

    private static SimpleFeatureType getReducedFeatureType(Layer layer, boolean useUpperCase, Collection<DraftData> draftData) {
        DMDCollection dataStores = layer.getLayerManager().getTask().getDataStores();
        SimpleFeatureType completeType = layer.getFMD().getWriteableSchema(dataStores);
        List reducedAttributes = Stream.concat(Stream.of(layer.getFMD().getAttributesEdit()), draftData.stream().filter(field -> FeatureTypeUtil.hasSchemaAttribute((SimpleFeatureType)completeType, (String)field.getColumn())).map(dd -> GraphicDrafts.attr(useUpperCase, dd.getColumn()))).distinct().collect(Collectors.toList());
        return SimpleFeatureTypeBuilder.retype((SimpleFeatureType)completeType, reducedAttributes);
    }

    private static <T> List<T> mapAndCollect(SimpleFeatureSource source, Query query, Function<SimpleFeature, T> mapper) {
        ArrayList<T> arrayList;
        block9: {
            SimpleFeatureCollection featuresCollection = source.getFeatures(query);
            SimpleFeatureIterator features = featuresCollection.features();
            try {
                ArrayList<T> drafts = new ArrayList<T>();
                while (features.hasNext()) {
                    SimpleFeature next = (SimpleFeature)features.next();
                    drafts.add(mapper.apply(next));
                }
                arrayList = drafts;
                if (features == null) break block9;
            }
            catch (Throwable throwable) {
                if (features != null) {
                    try {
                        features.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            features.close();
        }
        return arrayList;
    }

    private static boolean requiresUpperCase(String datatypeNameEdit) {
        return FeatureTypeUtil.isSchemaNameInUpperCase((String)datatypeNameEdit);
    }

    private static boolean requiresUpperCase(Layer currentLayer) {
        return FeatureTypeUtil.isSchemaNameInUpperCase((String)currentLayer.getFMD().getDatatypeNameEdit());
    }

    private static Object attr(boolean useUpperCase, SimpleFeature feature, String attribute) {
        return feature.getAttribute(FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)attribute));
    }

    private static String attr(boolean useUpperCase, String attribute) {
        return FeatureTypeUtil.getSchemaAttribute((boolean)useUpperCase, (String)attribute);
    }

    private GraphicDrafts() {
    }
}

