/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.dim;

import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import de.riwagis.geotools.feature.util.FeatureUtil;
import java.util.ArrayList;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;

public enum DimFeatureAtts {
    ISDIM("isdim", Integer.class, true, false),
    MTYPE("mtype", Integer.class, false, false),
    MTEXT("mtext", String.class, false, false),
    MTEXT_ORI("mtext_ori", Double.class, false, false),
    USE_ORI("use_ori", Integer.class, false, false),
    GEOM("geom", Geometry.class, false, false);

    private String name = null;
    private Class type = null;
    private boolean optional = false;
    private boolean style = false;

    private DimFeatureAtts(String name, Class type, boolean optional, boolean style) {
        this.name = name;
        this.type = type;
        this.optional = optional;
        this.style = style;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isStyle() {
        return this.style;
    }

    public String toString() {
        return this.name;
    }

    public static String[] checkStructure(SimpleFeatureType fType) {
        try {
            ArrayList<String> lstError = new ArrayList<String>();
            for (CadFeatureAtts att : CadFeatureAtts.values()) {
                if (att.isOptional() || FeatureUtil.getAttributeDescriptor((SimpleFeatureType)fType, (String)att.getName()) != null) continue;
                lstError.add(att.getName());
            }
            if (lstError.isEmpty()) {
                return null;
            }
            return lstError.toArray(new String[0]);
        }
        catch (Exception e) {
            return new String[]{e.getMessage()};
        }
    }

    public static boolean checkStructureSupportsDimensions(SimpleFeatureType fType) {
        if (FeatureUtil.getAttributeDescriptor((SimpleFeatureType)fType, (String)ISDIM.getName()) == null) {
            return false;
        }
        if (FeatureUtil.getAttributeDescriptor((SimpleFeatureType)fType, (String)MTYPE.getName()) == null) {
            return false;
        }
        if (FeatureUtil.getAttributeDescriptor((SimpleFeatureType)fType, (String)MTEXT.getName()) == null) {
            return false;
        }
        return FeatureUtil.getAttributeDescriptor((SimpleFeatureType)fType, (String)MTEXT_ORI.getName()) != null;
    }
}

