/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.cad;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.CadLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.SetCadLayerThemeDialog;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class SetCadLayerThemePlugIn
extends AbstractPlugIn {
    private SetCadLayerThemeDialog setCadLayerThemeDialog = null;

    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.cad.SetCadLayerThemePlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"layer_themes.svg");
    }

    private SetCadLayerThemeDialog getDialog(PlugInContext context, CadLayer cly) {
        if (this.setCadLayerThemeDialog == null) {
            this.setCadLayerThemeDialog = new SetCadLayerThemeDialog((Frame)context.getWorkbenchFrame(), cly);
            GUISupport.centreComponent((Component)this.setCadLayerThemeDialog, (Component)context.getWorkbenchFrame());
        } else {
            this.setCadLayerThemeDialog.setCadLayer(cly);
        }
        return this.setCadLayerThemeDialog;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        SelectionManager selMngr = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager();
        Collection<Layer> colLy = selMngr.getLayersWithSelectedItems();
        if (colLy.size() != 1) {
            return true;
        }
        Layer ly = colLy.iterator().next();
        if (ly instanceof CadLayer) {
            CadLayer cly = (CadLayer)ly;
            Collection<SimpleFeature> colFeat = selMngr.getFeaturesWithSelectedItems(ly);
            CadLayer.InternalLayer intLy = cly.getInternalLayer4NewFeatures();
            if (colFeat.size() == 1) {
                intLy = CadLayer.internalLayer4Feature(colFeat.iterator().next());
            }
            SetCadLayerThemeDialog dlg = this.getDialog(context, cly);
            if (intLy != null) {
                dlg.setVisible(intLy);
            } else {
                dlg.setVisible(true);
            }
            if (!dlg.wasOkPressed()) {
                return true;
            }
            intLy = dlg.getTheme();
            ArrayList<UndoableCommand> lstCommands = new ArrayList<UndoableCommand>();
            ArrayList<SimpleFeature> lstOldFeatures = new ArrayList<SimpleFeature>();
            ArrayList<SimpleFeature> lstNewFeatures = new ArrayList<SimpleFeature>();
            Iterator<SimpleFeature> iterator = colFeat.iterator();
            while (iterator.hasNext()) {
                SimpleFeature f;
                SimpleFeature featOld = f = iterator.next();
                SimpleFeature featNew = FeatureUtil.cloneFeature((SimpleFeature)featOld, (boolean)false);
                CadLayer.setInternalLayer2Feature(featNew, intLy);
                lstOldFeatures.add(featOld);
                lstNewFeatures.add(featNew);
            }
            lstCommands.add(this.createSetThemeCommand((AbstractCadLayer)ly, lstNewFeatures, lstOldFeatures));
            AbstractPlugIn.execute(lstCommands, (LayerManagerProxy)context, true);
        }
        return true;
    }

    private UndoableCommand createSetThemeCommand(final AbstractCadLayer cadlayer, final Collection colNewFeatures, final Collection colOldFeatures) {
        UndoableCommand command = new UndoableCommand(this, "SetCadLayerTheme"){

            @Override
            public void execute() {
                cadlayer.editFeature(colNewFeatures, 2);
            }

            @Override
            public void unexecute() {
                cadlayer.editFeature(colOldFeatures, 2);
            }
        };
        return command;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNFeaturesMustBeSelectedCheck(1)).add(new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                Layer ly;
                Collection<Layer> colLy = WorkbenchContext.getInstance().getSelectionManager().getLayersWithSelectedItems();
                if (colLy.size() == 1 && (ly = colLy.iterator().next()) instanceof CadLayer && FeatureUtil.hasAttributeDescriptor((SimpleFeatureType)ly.getFeatureType(), (String)CadFeatureAtts.LAYERNAME.getName())) {
                    return null;
                }
                return "At least one feature on one cadlayer has to be selected.";
            }
        });
    }
}

