/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.cad;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.CadLayer;
import com.vividsolutions.jump.workbench.ui.components.OKCancelPanel;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class SetCadLayerThemeDialog
extends JDialog {
    private CadLayer cly = null;
    private JComboBox cmbTheme;
    private JLabel lblLayer;
    private JLabel lblTheme;
    private OKCancelPanel oKCancelPanel;

    public SetCadLayerThemeDialog(Frame parent, CadLayer cly) {
        super(parent, true);
        this.cly = cly;
        this.initComponents();
        this.i18n();
        GUISupport.addKeyListenersRecursively((Component)this, (KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int code = e.getKeyCode();
                if (code == 27) {
                    SetCadLayerThemeDialog.this.oKCancelPanel.setOKPressed(false);
                    SetCadLayerThemeDialog.this.okCancelPanel_onActionPerformed(null);
                } else if (code == 10) {
                    SetCadLayerThemeDialog.this.oKCancelPanel.setOKPressed(true);
                    SetCadLayerThemeDialog.this.okCancelPanel_onActionPerformed(null);
                }
            }
        });
        this.pack();
    }

    private void i18n() {
        this.setTitle(I18N.get("ui.plugin.layer.cad.SetCadLayerThemeDialog.title"));
        this.lblTheme.setText(I18N.get("common.theme") + ":");
    }

    public void setCadLayer(CadLayer newCadLayer) {
        this.cly = newCadLayer;
        this.initCombo();
    }

    private void initCombo() {
        this.cmbTheme.removeAllItems();
        for (CadLayer.InternalLayer intLy : this.cly.getInternalLayers()) {
            this.cmbTheme.addItem(intLy);
        }
        if (this.cly.getInternalLayer4NewFeatures() != null) {
            this.cmbTheme.setSelectedItem(this.cly.getInternalLayer4NewFeatures());
        } else if (this.cmbTheme.getItemCount() > 0) {
            this.cmbTheme.setSelectedIndex(0);
        }
    }

    public CadLayer.InternalLayer getTheme() {
        return (CadLayer.InternalLayer)this.cmbTheme.getSelectedItem();
    }

    public boolean wasOkPressed() {
        return this.oKCancelPanel.wasOKPressed();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.initCombo();
        }
        super.setVisible(visible);
    }

    public void setVisible(CadLayer.InternalLayer intLy) {
        this.initCombo();
        this.cmbTheme.setSelectedItem(intLy);
        super.setVisible(true);
    }

    private void initComponents() {
        this.lblTheme = new JLabel();
        this.cmbTheme = new JComboBox();
        this.oKCancelPanel = new OKCancelPanel();
        this.lblLayer = new JLabel();
        this.setTitle("Tooltips setzen");
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblTheme.setText("Thema:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.lblTheme, gridBagConstraints);
        this.cmbTheme.setPreferredSize(new Dimension(200, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.cmbTheme, gridBagConstraints);
        this.oKCancelPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetCadLayerThemeDialog.this.okCancelPanel_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.oKCancelPanel, gridBagConstraints);
        this.lblLayer.setFont(this.lblLayer.getFont().deriveFont(this.lblLayer.getFont().getStyle() | 1, this.lblLayer.getFont().getSize() + 1));
        this.lblLayer.setText("Ebene");
        this.lblLayer.setPreferredSize(new Dimension(200, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.lblLayer, gridBagConstraints);
        this.pack();
    }

    private void okCancelPanel_onActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

