/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer.cad;

import de.riwagis.geotools.feature.util.FeatureUtil;
import java.util.ArrayList;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;

public enum CadFeatureAtts {
    DRAWING("drawing", String.class, true, false),
    LAYERNAME("layername", String.class, false, false),
    NAME("name", String.class, true, false),
    TEXT("text", String.class, false, false),
    TEXTORI("textori", Double.class, false, false),
    TEXTSIZE("textsize", Float.class, false, true),
    TEXTCOLOR("textcolor", Integer.class, false, true),
    TEXTFONT("textfont", String.class, false, true),
    SYMSIZE("symsize", Float.class, false, true),
    SYMORI("symori", Double.class, false, false),
    SYMBOL("symbol", String.class, false, true),
    SYMLINECOLOR("symlinecolor", Integer.class, true, true),
    USE_SYMLINECOLOR("use_symlinecolor", Integer.class, true, true),
    SYMFILLCOLOR("symfillcolor", Integer.class, true, true),
    USE_SYMFILLCOLOR("use_symfillcolor", Integer.class, true, true),
    LINEPATTERN("linepattern", String.class, false, true),
    LINEWIDTH("linewidth", Float.class, false, true),
    LINECOLOR("linecolor", Integer.class, false, true),
    FILL("fill", String.class, false, true),
    FILLWIDTH("fillwidth", Float.class, false, true),
    FILLCOLOR("fillcolor", Integer.class, false, true),
    RENDERFILL("renderfill", Integer.class, false, true),
    ALPHA("alpha", Integer.class, true, true),
    ISDIM("isdim", Integer.class, true, false),
    MTYPE("mtype", Integer.class, true, false),
    MTEXT("mtext", String.class, true, false),
    MTEXT_ORI("mtext_ori", Double.class, true, false),
    USE_ORI("use_ori", Integer.class, true, false),
    ORDER_BY("orderby", Integer.class, true, false),
    VP_SCALE("vp_scale", Double.class, true, false),
    GEOM("geom", Geometry.class, false, false);

    private String name;
    private Class type;
    private boolean optional;
    private boolean style;

    private CadFeatureAtts(String name, Class type, boolean optional, boolean style) {
        this.name = name;
        this.type = type;
        this.optional = optional;
        this.style = style;
    }

    public static String[] checkStructure(SimpleFeatureType fType) {
        try {
            ArrayList<String> lstError = new ArrayList<String>();
            for (CadFeatureAtts att : CadFeatureAtts.values()) {
                if (att.isOptional() || FeatureUtil.getAttributeDescriptor((SimpleFeatureType)fType, (String)att.getName()) != null) continue;
                lstError.add(att.getName());
            }
            if (lstError.isEmpty()) {
                return null;
            }
            return lstError.toArray(new String[0]);
        }
        catch (Exception e) {
            return new String[]{e.getMessage()};
        }
    }

    public static boolean checkStructureSupportsDimensions(SimpleFeatureType fType) {
        if (FeatureUtil.getAttributeDescriptor((SimpleFeatureType)fType, (String)ISDIM.getName()) == null) {
            return false;
        }
        if (FeatureUtil.getAttributeDescriptor((SimpleFeatureType)fType, (String)MTYPE.getName()) == null) {
            return false;
        }
        if (FeatureUtil.getAttributeDescriptor((SimpleFeatureType)fType, (String)MTEXT.getName()) == null) {
            return false;
        }
        if (FeatureUtil.getAttributeDescriptor((SimpleFeatureType)fType, (String)MTEXT_ORI.getName()) == null) {
            return false;
        }
        return FeatureUtil.getAttributeDescriptor((SimpleFeatureType)fType, (String)USE_ORI.getName()) != null;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isStyle() {
        return this.style;
    }

    public String toString() {
        return this.name;
    }
}

