/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Window;
import java.util.Collection;
import java.util.HashSet;

public class ReloadLayerablesPlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Runnable run = () -> {
            LayerNamePanel layerNamePanel = context.getLayerNamePanel();
            HashSet<Layerable> layersToReload = new HashSet<Layerable>();
            for (Category cat : layerNamePanel.getSelectedCategories()) {
                this.reloadCategory(cat, layersToReload);
            }
            for (Layerable ly : layerNamePanel.selectedNodes(Layerable.class)) {
                this.reloadLayerable(ly, layersToReload);
            }
            context.getLayerViewPanel().getRenderingManager().render(layersToReload.iterator(), true);
        };
        WaitDialog.createWaitDialog((Window)context.getWorkbenchFrame(), (String)I18N.get("ui.plugin.layer.ReloadLayerablesPlugIn.wait"), (Runnable)run).setVisible(true);
        return true;
    }

    private void reloadCategory(Category cat, Collection<Layerable> colLy2Reload) {
        for (Layerable ly : cat.getLayerables()) {
            this.reloadLayerable(ly, colLy2Reload);
        }
        for (Category catSub : cat.getSubcategories()) {
            this.reloadCategory(catSub, colLy2Reload);
        }
    }

    private synchronized void reloadLayerable(Layerable ly, Collection<Layerable> colLy2Reload) {
        colLy2Reload.addAll(ly.reload());
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        MultiEnableCheck chk = new MultiEnableCheck();
        chk.add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
        EnableCheck chkLayer = checkFactory.createAtLeastNLayerablesMustBeSelectedCheck(1, Layerable.class);
        EnableCheck chkCat = checkFactory.createAtLeastNCategoriesMustBeSelectedCheck(1);
        EnableCheck chkLayerCat = comp -> {
            if (chkLayer.check(comp) == null) {
                return null;
            }
            if (chkCat.check(comp) == null) {
                return null;
            }
            return I18N.get("ui.plugin.layer.ReloadLayerablesPlugIn.check-tree-selection");
        };
        chk.add(chkLayerCat);
        return chk;
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.ReloadLayerablesPlugIn.name");
    }
}

