/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.layer.ChooseLayerPrioPlugIn;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public class LayerPrioResetPlugIn
extends AbstractPlugIn {
    private static final String TASK_BB_DEFAULT_LAYER_PRIO = ChooseLayerPrioPlugIn.class.getName() + "_TASK_BB_DEFAULT_LAYER_PRIO";

    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        Collection<Layerable> colLy = context.getLayerNamePanel().selectedNodes(Layerable.class);
        if (colLy.size() == 1) {
            final Layerable selLy = colLy.iterator().next();
            this.execute(new UndoableCommand(this, this.getName()){
                int opr;
                int npr;
                {
                    super(name);
                    this.npr = this.opr = selLy.getRenderPrio();
                }

                @Override
                public void execute() {
                    boolean success = LayerPrioResetPlugIn.activateDefaultLayerPrio(context.getTask(), selLy);
                    if (success) {
                        this.npr = selLy.getRenderPrio();
                    } else {
                        selLy.setRenderPrio(this.npr);
                    }
                    selLy.getLayerManager().fireLayerChanged(selLy, LayerEventType.APPEARANCE_CHANGED);
                }

                @Override
                public void unexecute() {
                    selLy.setRenderPrio(this.opr);
                    selLy.getLayerManager().fireLayerChanged(selLy, LayerEventType.APPEARANCE_CHANGED);
                }
            }, context);
        }
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        MultiEnableCheck chk = new MultiEnableCheck();
        chk.add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
        chk.add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, Layerable.class));
        chk.add(new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                Layerable ly = WorkbenchContext.getInstance().getLayerNamePanel().selectedNodes(Layerable.class).iterator().next();
                Task task = WorkbenchContext.getTask();
                if (!LayerPrioResetPlugIn.hasDefaultLayerPrio(task, ly)) {
                    return I18N.get("ui.plugin.layer.LayerPrioResetPlugIn.no-default-prio");
                }
                return null;
            }
        });
        return chk;
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.LayerPrioResetPlugIn.name");
    }

    public static boolean addDefaultLayerPrio2Task(Task task, Layerable ly, int prio) {
        Map mapLyPrio = (Map)task.getBlackboard().get(TASK_BB_DEFAULT_LAYER_PRIO, new HashMap());
        if (!mapLyPrio.containsKey(ly.getKey())) {
            mapLyPrio.put(ly.getKey(), prio);
            return true;
        }
        return false;
    }

    public static boolean activateDefaultLayerPrio(Task task, Layerable ly) {
        Map mapLyPrio = (Map)task.getBlackboard().get(TASK_BB_DEFAULT_LAYER_PRIO, new HashMap());
        if (mapLyPrio.containsKey(ly.getKey())) {
            ly.setRenderPrio((Integer)mapLyPrio.remove(ly.getKey()));
            ly.getLayerManager().fireLayerChanged(ly, LayerEventType.APPEARANCE_CHANGED);
            return true;
        }
        return false;
    }

    private static boolean hasDefaultLayerPrio(Task task, Layerable ly) {
        Map mapLyPrio = (Map)task.getBlackboard().get(TASK_BB_DEFAULT_LAYER_PRIO, new HashMap());
        return mapLyPrio.containsKey(ly.getKey());
    }
}

