/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTree;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTreeCellRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTreeModel;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class LayerPrioPanel
extends JPanel {
    private int newPrio = -1;
    private final List<Layerable> lstLayers = new ArrayList<Layerable>();
    private Layerable ly = null;
    private LayerTreeModel model = null;
    private final List<ActionListener> lstPrioChangedListeners = new ArrayList<ActionListener>();
    private JButton butInsertAbove;
    private JButton butInsertBelow;
    private JButton butInsertNumber;
    private JLabel lblDescription;
    private JLabel lblHeader;
    private JPanel pnlAboveBelow;
    private JScrollPane scpTreeLayer;
    private JTree treeLayer;

    public LayerPrioPanel() {
        this.initComponents();
        this.i18n();
        LayerTreeCellRenderer renderer = (LayerTreeCellRenderer)this.treeLayer.getCellRenderer();
        renderer.setRenderPriority(true);
        this.scpTreeLayer.getVerticalScrollBar().setUnitIncrement(20);
        this.butInsertAbove.setEnabled(false);
        this.butInsertBelow.setEnabled(false);
        this.lstPrioChangedListeners.add(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayerPrioPanel.this.lblHeader.setToolTipText(I18N.getMessage("ui.plugin.layer.LayerPrioPanel.prio", LayerPrioPanel.this.newPrio));
                LayerPrioPanel.this.treeLayer.repaint();
            }
        });
    }

    private void i18n() {
        this.butInsertAbove.setToolTipText(I18N.get("ui.plugin.layer.LayerPrioPanel.above"));
        this.butInsertBelow.setToolTipText(I18N.get("ui.plugin.layer.LayerPrioPanel.below"));
        this.butInsertNumber.setToolTipText(I18N.get("ui.plugin.layer.LayerPrioPanel.by-number"));
        this.lblDescription.setText(I18N.get("ui.plugin.layer.LayerPrioPanel.description"));
    }

    public void initWithTask(Task task, Layerable ly) {
        this.lblHeader.setText(I18N.getMessage("ui.plugin.layer.LayerPrioPanel.header", ly.getName()));
        this.lblHeader.setToolTipText(I18N.getMessage("ui.plugin.layer.LayerPrioPanel.prio", ly.getRenderPrio()));
        this.ly = ly;
        this.newPrio = ly.getRenderPrio();
        this.lstLayers.clear();
        this.lstLayers.sort(Layerable.COMPARE_LAYERABLE_BYPRIORITY);
        this.model = new LayerTreeModel(this, task){

            @Override
            public List<?> getChildren(Object parent) {
                ArrayList lstChilds2Return = new ArrayList();
                lstChilds2Return.addAll(super.getChildren(parent));
                return lstChilds2Return;
            }
        };
        this.treeLayer.setModel(this.model);
    }

    public int getNewPriority() {
        return this.newPrio;
    }

    public void addActionListener(ActionListener prioChangedActionListener) {
        if (!this.lstPrioChangedListeners.contains(prioChangedActionListener)) {
            this.lstPrioChangedListeners.add(prioChangedActionListener);
        }
    }

    public void removeActionListener(ActionListener prioChangedActionListener) {
        this.lstPrioChangedListeners.remove(prioChangedActionListener);
    }

    private void firePrioChangedEvent() {
        ActionEvent ae = new ActionEvent(this, 0, "PRIO_CHANGED," + this.newPrio);
        for (ActionListener listener : this.lstPrioChangedListeners) {
            listener.actionPerformed(ae);
        }
    }

    private void initComponents() {
        this.pnlAboveBelow = new JPanel();
        this.butInsertAbove = new JButton();
        this.butInsertBelow = new JButton();
        this.butInsertNumber = new JButton();
        this.lblHeader = new JLabel();
        this.lblDescription = new JLabel();
        this.scpTreeLayer = new JScrollPane();
        this.treeLayer = new LayerTree(this.scpTreeLayer, WorkbenchContext.getInstance(), null, false, false, false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                LayerPrioPanel.this.formComponentResized(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        this.butInsertAbove.setIcon(IconLoader.svgIcon((String)"layer_above.svg"));
        this.butInsertAbove.setMargin(new Insets(2, 2, 2, 2));
        this.butInsertAbove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerPrioPanel.this.butInsertAboveActionPerformed(evt);
            }
        });
        this.pnlAboveBelow.add(this.butInsertAbove);
        this.butInsertBelow.setIcon(IconLoader.svgIcon((String)"layer_below.svg"));
        this.butInsertBelow.setMargin(new Insets(2, 2, 2, 2));
        this.butInsertBelow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerPrioPanel.this.butInsertBelowActionPerformed(evt);
            }
        });
        this.pnlAboveBelow.add(this.butInsertBelow);
        this.butInsertNumber.setIcon(IconLoader.svgIcon((String)"layer_number.svg"));
        this.butInsertNumber.setMargin(new Insets(2, 2, 2, 2));
        this.butInsertNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerPrioPanel.this.butInsertNumberActionPerformed(evt);
            }
        });
        this.pnlAboveBelow.add(this.butInsertNumber);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.pnlAboveBelow, gridBagConstraints);
        this.lblHeader.setText("Ebene: Name der Ebene");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblHeader, gridBagConstraints);
        this.lblDescription.setText("W\u00e4hlen Sie eine Ebene im Ebenenbaum.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblDescription, gridBagConstraints);
        this.treeLayer.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                LayerPrioPanel.this.treeLayerValueChanged(evt);
            }
        });
        this.scpTreeLayer.setViewportView(this.treeLayer);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.scpTreeLayer, gridBagConstraints);
    }

    private void butInsertAboveActionPerformed(ActionEvent evt) {
        Layerable lyAbove = this.layerWithHighestPrio();
        if (lyAbove != null) {
            this.newPrio = this.prioAbove(lyAbove);
            this.firePrioChangedEvent();
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        final Enumeration<TreePath> e = this.treeLayer.getExpandedDescendants(new TreePath(new Object[]{this.model.getRoot()}));
        final TreePath[] arrTpSel = this.treeLayer.getSelectionPaths();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.model.getRoot()});
        this.model.fireTreeStructureChanged(treeModelEvent);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                while (e.hasMoreElements()) {
                    TreePath tp = (TreePath)e.nextElement();
                    LayerPrioPanel.this.treeLayer.expandPath(tp);
                }
                LayerPrioPanel.this.treeLayer.addSelectionPaths(arrTpSel);
            }
        });
    }

    private void treeLayerValueChanged(TreeSelectionEvent evt) {
        TreePath[] arrSelPath = this.treeLayer.getSelectionPaths();
        this.butInsertAbove.setEnabled(false);
        this.butInsertBelow.setEnabled(false);
        if (arrSelPath == null) {
            return;
        }
        for (TreePath tp : arrSelPath) {
            if (tp.getLastPathComponent() != null && tp.getLastPathComponent() instanceof Layerable) {
                this.butInsertAbove.setEnabled(true);
                this.butInsertBelow.setEnabled(true);
                return;
            }
            if (tp.getLastPathComponent() == null || !(tp.getLastPathComponent() instanceof Category) || !this.checkCategoryValid((Category)tp.getLastPathComponent())) continue;
            this.butInsertAbove.setEnabled(true);
            this.butInsertBelow.setEnabled(true);
            return;
        }
    }

    private void butInsertBelowActionPerformed(ActionEvent evt) {
        Layerable lyBelow = this.layerWithLowestPrio();
        if (lyBelow != null) {
            this.newPrio = this.prioBelow(lyBelow);
            this.firePrioChangedEvent();
        }
    }

    private void butInsertNumberActionPerformed(ActionEvent evt) {
        String strNewPrio = GUISupport.inputbox((Component)this, (String)I18N.get("ui.plugin.layer.LayerPrioPanel.insert-prio-number"), (String)I18N.get("ui.plugin.layer.LayerPrioPanel.by-number"), (String)("" + this.newPrio));
        if (strNewPrio != null) {
            try {
                this.newPrio = Integer.parseInt(strNewPrio);
                this.firePrioChangedEvent();
            }
            catch (NumberFormatException ne) {
                GUISupport.msgbox((Component)this, (String)I18N.getMessage("ui.plugin.layer.LayerPrioPanel.invalid-number", strNewPrio, Integer.MIN_VALUE, Integer.MAX_VALUE), (String)I18N.get("common.error"));
            }
        }
    }

    private int prioBelow(Layerable layerable) {
        if (layerable == this.ly) {
            return layerable.getRenderPrio();
        }
        long lowerprio = layerable.getRenderPrio();
        for (Layerable lytmp : this.lstLayers) {
            if (lytmp.getRenderPrio() < layerable.getRenderPrio()) {
                lowerprio = lytmp.getRenderPrio();
            }
            if (lytmp.getRenderPrio() <= layerable.getRenderPrio()) continue;
            break;
        }
        if (lowerprio == (long)layerable.getRenderPrio()) {
            lowerprio -= 50L;
        } else {
            long diff = (long)layerable.getRenderPrio() - lowerprio;
            long middlediff = diff / 2L;
            lowerprio += middlediff;
        }
        if (lowerprio < Integer.MIN_VALUE) {
            lowerprio = Integer.MIN_VALUE;
        } else if (lowerprio > Integer.MAX_VALUE) {
            lowerprio = Integer.MAX_VALUE;
        }
        return (int)lowerprio;
    }

    private int prioAbove(Layerable layerable) {
        if (layerable == this.ly) {
            return layerable.getRenderPrio();
        }
        long upperprio = layerable.getRenderPrio();
        ArrayList<Layerable> lstLayersTmp = new ArrayList<Layerable>(this.lstLayers);
        Collections.reverse(lstLayersTmp);
        for (Layerable lytmp : lstLayersTmp) {
            if (lytmp.getRenderPrio() > layerable.getRenderPrio()) {
                upperprio = lytmp.getRenderPrio();
            }
            if (lytmp.getRenderPrio() >= layerable.getRenderPrio()) continue;
            break;
        }
        if (upperprio == (long)layerable.getRenderPrio()) {
            upperprio += 50L;
        } else {
            long diff = upperprio - (long)layerable.getRenderPrio();
            long middlediff = diff / 2L;
            upperprio -= middlediff;
        }
        if (upperprio < Integer.MIN_VALUE) {
            upperprio = Integer.MIN_VALUE;
        } else if (upperprio > Integer.MAX_VALUE) {
            upperprio = Integer.MAX_VALUE;
        }
        return (int)upperprio;
    }

    private boolean checkCategoryValid(Category cat) {
        List<Layerable> lstLy = cat.getAllLayerables();
        return true;
    }

    private Layerable layerWithHighestPrio() {
        TreePath[] arrSelPath = this.treeLayer.getSelectionPaths();
        if (arrSelPath == null) {
            return null;
        }
        Layerable foundLayer = null;
        for (TreePath tp : arrSelPath) {
            if (tp.getLastPathComponent() != null && tp.getLastPathComponent() instanceof Layerable) {
                Layerable ly2test = (Layerable)tp.getLastPathComponent();
                if (foundLayer != null && ly2test.getRenderPrio() <= foundLayer.getRenderPrio()) continue;
                foundLayer = ly2test;
                continue;
            }
            if (tp.getLastPathComponent() == null || !(tp.getLastPathComponent() instanceof Category) || !this.checkCategoryValid((Category)tp.getLastPathComponent())) continue;
            Category cat2test = (Category)tp.getLastPathComponent();
            Layerable ly2test = this.layerWithHighestPrio(cat2test);
            if (foundLayer != null && (ly2test == null || ly2test.getRenderPrio() <= foundLayer.getRenderPrio())) continue;
            foundLayer = ly2test;
        }
        return foundLayer;
    }

    private Layerable layerWithLowestPrio() {
        TreePath[] arrSelPath = this.treeLayer.getSelectionPaths();
        if (arrSelPath == null) {
            return null;
        }
        Layerable foundLayer = null;
        for (TreePath tp : arrSelPath) {
            if (tp.getLastPathComponent() != null && tp.getLastPathComponent() instanceof Layerable) {
                Layerable ly2test = (Layerable)tp.getLastPathComponent();
                if (foundLayer != null && ly2test.getRenderPrio() >= foundLayer.getRenderPrio()) continue;
                foundLayer = ly2test;
                continue;
            }
            if (tp.getLastPathComponent() == null || !(tp.getLastPathComponent() instanceof Category) || !this.checkCategoryValid((Category)tp.getLastPathComponent())) continue;
            Category cat2test = (Category)tp.getLastPathComponent();
            Layerable ly2test = this.layerWithLowestPrio(cat2test);
            if (foundLayer != null && (ly2test == null || ly2test.getRenderPrio() >= foundLayer.getRenderPrio())) continue;
            foundLayer = ly2test;
        }
        return foundLayer;
    }

    private Layerable layerWithHighestPrio(Category cat) {
        List<Layerable> lstLy = cat.getAllLayerables();
        Layerable lyreturn = null;
        for (Layerable ly2test : lstLy) {
            if (lyreturn == null) {
                lyreturn = ly2test;
                continue;
            }
            if (ly2test.getRenderPrio() <= lyreturn.getRenderPrio()) continue;
            lyreturn = ly2test;
        }
        return lyreturn;
    }

    private Layerable layerWithLowestPrio(Category cat) {
        List<Layerable> lstLy = cat.getAllLayerables();
        Layerable lyreturn = null;
        for (Layerable ly2test : lstLy) {
            if (lyreturn == null) {
                lyreturn = ly2test;
                continue;
            }
            if (ly2test.getRenderPrio() >= lyreturn.getRenderPrio()) continue;
            lyreturn = ly2test;
        }
        return lyreturn;
    }
}

