/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.layer.LayerPrioResetPlugIn;
import java.util.Collection;

public class LayerPrioOnBottomPlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        Collection<Layerable> colLy = context.getLayerNamePanel().selectedNodes(Layerable.class);
        if (colLy.size() == 1) {
            final Layerable selLy = colLy.iterator().next();
            Collection<Layerable> lstLy = context.getLayerManager().getLayerables();
            long newPrio = selLy.getRenderPrio();
            for (Layerable ly : lstLy) {
                if (ly == selLy) continue;
                newPrio = Math.min(newPrio, (long)ly.getRenderPrio());
            }
            if ((newPrio -= 50L) < Integer.MIN_VALUE) {
                newPrio = Integer.MIN_VALUE;
            } else if (newPrio > Integer.MAX_VALUE) {
                newPrio = Integer.MAX_VALUE;
            }
            final int opr = selLy.getRenderPrio();
            final int npr = (int)newPrio;
            this.execute(new UndoableCommand(this, this.getName()){

                @Override
                public void execute() {
                    LayerPrioResetPlugIn.addDefaultLayerPrio2Task(context.getTask(), selLy, selLy.getRenderPrio());
                    selLy.setRenderPrio(npr);
                    selLy.getLayerManager().fireLayerChanged(selLy, LayerEventType.APPEARANCE_CHANGED);
                }

                @Override
                public void unexecute() {
                    selLy.setRenderPrio(opr);
                    selLy.getLayerManager().fireLayerChanged(selLy, LayerEventType.APPEARANCE_CHANGED);
                }
            }, context);
        }
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        MultiEnableCheck chk = new MultiEnableCheck();
        chk.add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
        chk.add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, Layerable.class));
        return chk;
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.LayerPrioOnBottomPlugIn.name");
    }
}

