/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.layer.ChooseLayerPrioDialog;
import com.vividsolutions.jump.workbench.ui.plugin.layer.LayerPrioResetPlugIn;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;

public class ChooseLayerPrioPlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        Collection<Layerable> colLy = context.getLayerNamePanel().selectedNodes(Layerable.class);
        if (colLy.size() == 1) {
            final ChooseLayerPrioDialog dlg = new ChooseLayerPrioDialog((Window)context.getWorkbenchFrame());
            final Layerable ly = colLy.iterator().next();
            dlg.getPanel().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final int newPrio = dlg.getPanel().getNewPriority();
                    final int oldPrio = ly.getRenderPrio();
                    ChooseLayerPrioPlugIn.this.execute(new UndoableCommand(ChooseLayerPrioPlugIn.this.getName()){

                        @Override
                        public void execute() {
                            LayerPrioResetPlugIn.addDefaultLayerPrio2Task(context.getTask(), ly, ly.getRenderPrio());
                            ly.setRenderPrio(newPrio);
                            ly.getLayerManager().fireLayerChanged(ly, LayerEventType.APPEARANCE_CHANGED);
                        }

                        @Override
                        public void unexecute() {
                            ly.setRenderPrio(oldPrio);
                            ly.getLayerManager().fireLayerChanged(ly, LayerEventType.APPEARANCE_CHANGED);
                        }
                    }, context);
                }
            });
            dlg.initWithTask(context.getTask(), ly);
            dlg.setVisible(true);
        }
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        MultiEnableCheck chk = new MultiEnableCheck();
        chk.add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
        chk.add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, Layerable.class));
        return chk;
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.ChooseLayerPrioPlugIn.name");
    }
}

