/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.CadLayer;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.renderer.style.theming.ThemeRetriever;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.CadStyleModel;
import de.riwagis.riwajump.model.style.ColorThemingStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.model.style.SymbolStyleModel;
import de.riwagis.riwajump.model.style.theme.ThemeModel;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;

public class ChangeSymbolstorePlugIn
extends AbstractPlugIn {
    private static final String MESSAGE = I18N.get("ui.plugin.layer.ChangeSymbolstorePlugIn.message");

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        String strName = JOptionPane.showInputDialog(context.getWorkbenchFrame(), (Object)MESSAGE);
        if (strName == null || strName.length() == 0) {
            return true;
        }
        Collection<Category> selectedCategories = context.getLayerNamePanel().getSelectedCategories();
        for (Category cat : selectedCategories) {
            List<Layerable> lstLayerables = cat.getAllLayerables();
            for (Layerable lyObj : lstLayerables) {
                Layer ly;
                if (lyObj.getClass().equals(CadLayer.class)) {
                    ly = (CadLayer)lyObj;
                    for (StyleCollection sCol : ly.getStyleCollections()) {
                        for (StyleModel obj : sCol.getStyles()) {
                            if (!(obj instanceof CadStyleModel)) continue;
                            CadStyleModel cStyle = (CadStyleModel)obj;
                            cStyle.setStrSymStore(strName);
                        }
                    }
                    ((CadLayer)ly).fireAppearanceChanged();
                }
                if (!lyObj.getClass().equals(Layer.class)) continue;
                ly = (Layer)lyObj;
                for (StyleCollection sCol : ly.getStyleCollections()) {
                    for (StyleModel obj : sCol.getStyles()) {
                        if (obj instanceof BasicStyleModel) {
                            BasicStyleModel bStyle = (BasicStyleModel)obj;
                            ChangeSymbolstorePlugIn.changeBasicStyle(bStyle, strName);
                        }
                        if (!(obj instanceof ColorThemingStyleModel)) continue;
                        ColorThemingStyleModel tStyle = (ColorThemingStyleModel)obj;
                        BasicStyleModel bDefStyle = tStyle.getDefaultStyle();
                        ChangeSymbolstorePlugIn.changeBasicStyle(bDefStyle, strName);
                        ThemeRetriever retriever = (ThemeRetriever)tStyle.getThemeSource().getIntelligence();
                        Collection<ThemeModel> themes = retriever.getThemes(ly);
                        for (ThemeModel theme : themes) {
                            ChangeSymbolstorePlugIn.changeBasicStyle(theme.getStyle(), strName);
                        }
                    }
                }
                ly.fireAppearanceChanged();
            }
        }
        return true;
    }

    private static void changeBasicStyle(BasicStyleModel bStyle, String strNewName) {
        if (bStyle.isRenderingSymbol()) {
            SymbolStyleModel symStyle = bStyle.getSymStyle();
            symStyle.setStrStorename(strNewName);
        }
        if (bStyle.isRenderingFill() && bStyle.isRenderingFillPattern()) {
            bStyle.setStrFillSymStore(strNewName);
        }
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        MultiEnableCheck chk = new MultiEnableCheck();
        chk.add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
        chk.add(checkFactory.createAtLeastNCategoriesMustBeSelectedCheck(1));
        return chk;
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.ChangeSymbolstorePlugIn.name");
    }
}

