/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;

public class ChangeDatasourcePlugIn
extends AbstractPlugIn {
    private static final String MESSAGE = I18N.get("ui.plugin.layer.ChangeDatasourcePlugIn.message");

    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        this.execute(new UndoableCommand(this, this.getName()){
            ArrayList lstLayers;
            ArrayList lstNames;
            {
                super(name);
                this.lstLayers = new ArrayList();
                this.lstNames = new ArrayList();
            }

            @Override
            public void execute() {
                String strName = JOptionPane.showInputDialog(context.getWorkbenchFrame(), (Object)MESSAGE);
                if (strName == null || strName.length() == 0) {
                    return;
                }
                Collection<Category> selectedCategories = context.getLayerNamePanel().getSelectedCategories();
                for (Category cat : selectedCategories) {
                    List<Layerable> lstLayerables = cat.getAllLayerables();
                    for (Layerable lyObj : lstLayerables) {
                        if (!(lyObj instanceof Layer) || lyObj instanceof RedlineLayer) continue;
                        Layer ly = (Layer)lyObj;
                        this.lstLayers.add(ly);
                        this.lstNames.add(ly.getFMD().getDatastoreName());
                        ly.getFMD().setDatastoreName(strName);
                        ly.reload();
                    }
                }
            }

            @Override
            public void unexecute() {
                for (int i = 0; i < this.lstLayers.size(); ++i) {
                    if (this.lstLayers.get(i) == null) continue;
                    ((Layer)this.lstLayers.get(i)).getFMD().setDatastoreName((String)this.lstNames.get(i));
                }
            }
        }, context);
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        MultiEnableCheck chk = new MultiEnableCheck();
        chk.add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
        chk.add(checkFactory.createAtLeastNCategoriesMustBeSelectedCheck(1));
        return chk;
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.layer.ChangeDatasourcePlugIn.name");
    }
}

