/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.project;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.task.TaskUtil;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.AbstractSaveTaskPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.SaveTaskAsPlugIn;
import de.riwagis.icons.IconLoader;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;

public class SaveTaskPlugIn
extends AbstractSaveTaskPlugIn {
    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.SaveProjectPlugIn.save-project");
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_save.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        File projectFile = context.getTask().getProjectFile();
        if (projectFile == null) {
            JFileChooser fChoose = SaveTaskAsPlugIn.getTaskFileChooser();
            if (context.getTask().getProjectFile() != null) {
                fChoose.setSelectedFile(context.getTask().getProjectFile());
            }
            if (0 != fChoose.showSaveDialog(context.getWorkbenchFrame())) {
                return false;
            }
            File file = fChoose.getSelectedFile();
            projectFile = FileUtil.addExtensionIfNone(file, "jmp");
        }
        SaveTaskPlugIn.fireSaveTaskEvent(context.getTask(), projectFile, "save", context.getTask().getProjectVersion());
        TaskUtil.saveTask(context.getTask(), projectFile);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
    }
}

