/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.project;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.task.TaskUtil;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.AbstractSaveTaskPlugIn;
import de.riwagis.riwajump.model.version.VersionConverter;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class SaveTaskAsPlugIn
extends AbstractSaveTaskPlugIn {
    public static final FileFilter JUMP_PROJECT_FILE_FILTER = GUIUtil.createFileFilter(I18N.get("ui.plugin.SaveProjectAsPlugIn.jump-project-files"), new String[]{"jmp"});
    private static JFileChooser TASK_FILE_CHOOSER = null;
    private static JFileChooser TASK_FILE_CHOOSER_SAVEAS = null;
    private static final Map<FileFilter, Integer> mapFileFilter = new HashMap<FileFilter, Integer>();

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.SaveProjectAsPlugIn.save-project-as");
    }

    public static JFileChooser getTaskFileChooser() {
        SaveTaskAsPlugIn.initFileChooser();
        return TASK_FILE_CHOOSER;
    }

    public static JFileChooser getTaskFileChooserSaveAs() {
        SaveTaskAsPlugIn.initFileChooser();
        return TASK_FILE_CHOOSER_SAVEAS;
    }

    private static void initFileChooser() {
        if (TASK_FILE_CHOOSER == null) {
            TASK_FILE_CHOOSER = GUIUtil.createJFileChooserWithOverwritePrompting();
            TASK_FILE_CHOOSER.setDialogTitle(I18N.get("ui.plugin.SaveProjectAsPlugIn.save-project"));
            GUIUtil.removeChoosableFileFilters(TASK_FILE_CHOOSER);
            TASK_FILE_CHOOSER.addChoosableFileFilter(JUMP_PROJECT_FILE_FILTER);
            TASK_FILE_CHOOSER.setFileFilter(JUMP_PROJECT_FILE_FILTER);
        }
        if (TASK_FILE_CHOOSER_SAVEAS == null) {
            TASK_FILE_CHOOSER_SAVEAS = GUIUtil.createJFileChooserWithOverwritePrompting();
            TASK_FILE_CHOOSER_SAVEAS.setDialogTitle(I18N.get("ui.plugin.SaveProjectAsPlugIn.save-project-as"));
            GUIUtil.removeChoosableFileFilters(TASK_FILE_CHOOSER_SAVEAS);
            TASK_FILE_CHOOSER_SAVEAS.addChoosableFileFilter(JUMP_PROJECT_FILE_FILTER);
            for (int i = VersionConverter.CONVERTERS.length - 1; i >= 0 && VersionConverter.CONVERTERS[i].supportsUnconvert(); --i) {
                if (VersionConverter.CONVERTERS[i].oldVersionName().length() <= 0) continue;
                FileFilter fileFilt = GUIUtil.createFileFilter(I18N.get("common.version") + " " + VersionConverter.CONVERTERS[i].oldVersionName(), new String[]{"jmp"});
                TASK_FILE_CHOOSER_SAVEAS.addChoosableFileFilter(fileFilt);
                mapFileFilter.put(fileFilt, new Integer(VersionConverter.CONVERTERS[i].oldVersionNumber()));
            }
            TASK_FILE_CHOOSER_SAVEAS.setFileFilter(JUMP_PROJECT_FILE_FILTER);
        }
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        SaveTaskAsPlugIn.initFileChooser();
        if (context.getTask().getProjectFile() != null) {
            TASK_FILE_CHOOSER_SAVEAS.setSelectedFile(context.getTask().getProjectFile());
        }
        if (0 != TASK_FILE_CHOOSER_SAVEAS.showSaveDialog(context.getWorkbenchFrame())) {
            return false;
        }
        File file = TASK_FILE_CHOOSER_SAVEAS.getSelectedFile();
        FileFilter fileFilt = TASK_FILE_CHOOSER_SAVEAS.getFileFilter();
        int intVersion = fileFilt.equals(JUMP_PROJECT_FILE_FILTER) ? 22 : mapFileFilter.get(fileFilt);
        File projectFile = FileUtil.addExtensionIfNone(file, "jmp");
        SaveTaskAsPlugIn.fireSaveTaskEvent(context.getTask(), projectFile, "save as", intVersion);
        TaskUtil.saveTask(context.getTask(), projectFile, intVersion);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
    }
}

