/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.project;

import com.vividsolutions.jump.workbench.model.Task;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.geotools.util.URLs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelativePaths {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RelativePaths.class);
    public static final String OLD_RELATIVE_PATH_KEY = "relativepath";

    public static String normalize(String unnormalized) {
        return Path.of(unnormalized, new String[0]).normalize().toString();
    }

    public static Optional<Object> constructAbsolutePath(Task task, Map<String, Object> parameters, Object absolutePath) {
        if (task == null) {
            log.debug("There is no task. relative paths will not work.");
            return Optional.empty();
        }
        if (absolutePath == null) {
            log.warn("Absolute path not set.");
            return Optional.empty();
        }
        parameters.remove(OLD_RELATIVE_PATH_KEY);
        try {
            File file = RelativePaths.toFile(absolutePath);
            File fileWithMagic = RelativePaths.getFileRelativeToProject(file.toPath(), task);
            return Optional.of(RelativePaths.toSourceType(absolutePath, fileWithMagic.toPath()));
        }
        catch (MalformedURLException e) {
            log.debug("Error while getting absolute path", (Throwable)e);
            return Optional.empty();
        }
    }

    private static File toFile(Object obj) {
        if (obj instanceof File) {
            return (File)obj;
        }
        if (obj instanceof String) {
            return new File((String)obj);
        }
        if (obj instanceof URL) {
            return URLs.urlToFile((URL)((URL)obj));
        }
        throw new UnsupportedOperationException("Cannot cast absolute URL to File.");
    }

    private static Object toSourceType(Object absolutePath, Path abspath) throws MalformedURLException {
        Class<?> aClass = absolutePath.getClass();
        if (File.class.isAssignableFrom(aClass)) {
            return abspath.toFile();
        }
        if (String.class.isAssignableFrom(aClass)) {
            return abspath.toString();
        }
        if (URL.class.isAssignableFrom(aClass)) {
            return abspath.toUri().toURL();
        }
        throw new UnsupportedOperationException("Cannot cast back to source type for relative URL.");
    }

    public static File getFileRelativeToProject(Path file, Task task) {
        if (task == null || task.getBasePath() == null || task.getProjectFile() == null) {
            return file.toFile();
        }
        Path oldProjectBase = task.getBasePath();
        Path newProjectBase = task.getProjectFile().toPath().getParent();
        Path absoluteFile = !file.isAbsolute() ? oldProjectBase.resolve(file) : file;
        try {
            Path relativePath = oldProjectBase.relativize(absoluteFile);
            Path reoriginatedPath = newProjectBase.resolve(relativePath).normalize();
            if (Files.exists(reoriginatedPath, new LinkOption[0])) {
                return reoriginatedPath.toFile();
            }
        }
        catch (IllegalArgumentException e) {
            log.trace("Path {} cannot be relativized to {}. Path is probably already updated or simply not relative", (Object)oldProjectBase, (Object)absoluteFile);
        }
        return file.toFile();
    }

    private RelativePaths() {
    }
}

