/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.project;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.task.TaskUtil;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.AbstractTaskPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.SaveTaskAsPlugIn;
import com.vividsolutions.jump.workbench.ui.visibility.VisibilityPanel;
import de.riwagis.icons.IconLoader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import org.jdom2.JDOMException;

public class OpenTaskPlugIn
extends AbstractTaskPlugIn {
    private static final String CURRENT_FILE_KEY = String.format("%s - FILE", OpenTaskPlugIn.class);
    private JFileChooser fileChooser = null;

    public static void open(File[] files, WorkbenchFrame workbenchFrame, boolean bolMakeBuildIn) throws IOException, JDOMException, InterruptedException, InvocationTargetException {
        for (File file : files) {
            OpenTaskPlugIn.open(file, workbenchFrame, false);
        }
    }

    public static void open(File file, WorkbenchFrame workbenchFrame, boolean bolMakeBuildIn) throws IOException, JDOMException, InterruptedException, InvocationTargetException {
        Task sourceTask = TaskUtil.loadTask(file);
        if (bolMakeBuildIn) {
            sourceTask.makeBuildIn();
        }
        GUIUtil.invokeOnEventThread(() -> {
            try {
                sourceTask.getLayerManager().setFiringEvents(false);
                workbenchFrame.addTaskFrame(sourceTask);
                sourceTask.resetModifiedObjects();
                VisibilityPanel.activateDefaultProfile(sourceTask.getLayerManager());
                OpenTaskPlugIn.fireOpenTaskEvent(sourceTask, sourceTask.getProjectFile());
                EditingPanel.instanceOf().resetToDefault();
                workbenchFrame.getContext().getLayerNamePanel().startSearch();
            }
            finally {
                sourceTask.getLayerManager().setFiringEvents(true);
            }
        });
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.OpenProjectPlugIn.open-project");
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"file_open.svg");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    private void initFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = GUIUtil.createJFileChooserWithExistenceChecking();
            this.fileChooser.setDialogTitle(I18N.get("ui.plugin.OpenProjectPlugIn.open-project"));
            this.fileChooser.setDialogType(0);
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setMultiSelectionEnabled(true);
            GUIUtil.removeChoosableFileFilters(this.fileChooser);
            this.fileChooser.addChoosableFileFilter(SaveTaskAsPlugIn.JUMP_PROJECT_FILE_FILTER);
            this.fileChooser.addChoosableFileFilter(GUIUtil.ALL_FILES_FILTER);
            this.fileChooser.setFileFilter(SaveTaskAsPlugIn.JUMP_PROJECT_FILE_FILTER);
        }
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) {
        String strPath;
        monitor.report(String.format("%s... ", I18N.get("ui.plugin.OpenProjectPlugIn.loading")));
        this.initFileChooser();
        Blackboard bb = PersistentBlackboardPlugIn.get();
        if (bb.contains(CURRENT_FILE_KEY)) {
            strPath = (String)bb.get(CURRENT_FILE_KEY);
            this.fileChooser.setSelectedFile(new File(strPath));
        }
        if (0 != this.fileChooser.showOpenDialog(context.getWorkbenchFrame())) {
            return;
        }
        strPath = this.fileChooser.getSelectedFile().getAbsolutePath();
        bb.put(CURRENT_FILE_KEY, strPath);
        try {
            OpenTaskPlugIn.open(this.fileChooser.getSelectedFiles(), context.getWorkbenchFrame(), false);
        }
        catch (Throwable t) {
            context.getWorkbenchFrame().handleThrowable(t);
        }
    }

    @Override
    public KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(79, 128);
    }
}

