/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.project;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.task.TaskUtil;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.CategoryEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.AbstractTaskPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.SaveTaskAsPlugIn;
import com.vividsolutions.jump.workbench.ui.visibility.VisibilityPanel;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.riwajump.model.search.RootSearchModel;
import de.riwagis.riwajump.model.search.SearchCollectionModel;
import de.riwagis.riwajump.model.search.SearchModel;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.ColorThemingStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.model.style.theme.BasicStaticThemeSourceModel;
import de.riwagis.riwajump.symbol.model.SMDCollection;
import de.riwagis.riwajump.symbol.model.SymbolstoreMetadata;
import de.riwagis.riwajump.symbol.resources.RedlineLayerSymbolStore;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;

public class ImportTaskPlugIn
extends AbstractTaskPlugIn {
    private static final String CURRENT_FILE_KEY = String.format("%s - FILE", ImportTaskPlugIn.class);
    private JFileChooser fileChooser = null;

    @Override
    public String getName() {
        return I18N.get("ui.plugin.ImportTaskPlugIn.name");
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"file_import.svg");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    private void initFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = GUIUtil.createJFileChooserWithExistenceChecking();
            this.fileChooser.setDialogTitle(I18N.get("ui.plugin.ImportTaskPlugIn.name"));
            this.fileChooser.setDialogType(0);
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setMultiSelectionEnabled(false);
            GUIUtil.removeChoosableFileFilters(this.fileChooser);
            this.fileChooser.addChoosableFileFilter(SaveTaskAsPlugIn.JUMP_PROJECT_FILE_FILTER);
            this.fileChooser.addChoosableFileFilter(GUIUtil.ALL_FILES_FILTER);
            this.fileChooser.setFileFilter(SaveTaskAsPlugIn.JUMP_PROJECT_FILE_FILTER);
        }
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) {
        monitor.report(String.format("%s... ", I18N.get("ui.plugin.ImportTaskPlugIn.loading")));
        this.initFileChooser();
        Blackboard bb = PersistentBlackboardPlugIn.get();
        if (bb.contains(CURRENT_FILE_KEY)) {
            String strPath = (String)bb.get(CURRENT_FILE_KEY);
            this.fileChooser.setSelectedFile(new File(strPath));
        }
        if (0 != this.fileChooser.showOpenDialog(context.getWorkbenchFrame())) {
            return;
        }
        boolean bolBuildIn = !GUISupport.yesnobox((Component)context.getWorkbenchFrame(), (String)I18N.get("ui.plugin.ImportTaskPlugIn.union-project"), (String)I18N.get("common.message"));
        String strPath = this.fileChooser.getSelectedFile().getAbsolutePath();
        bb.put(CURRENT_FILE_KEY, strPath);
        try {
            ImportTaskPlugIn.open(this.fileChooser.getSelectedFile(), context.getTask(), bolBuildIn);
            ImportTaskPlugIn.fireImportTaskEvent(context.getTask(), this.fileChooser.getSelectedFile());
        }
        catch (Throwable t) {
            context.getWorkbenchFrame().handleThrowable(t);
        }
        context.getLayerViewPanel().repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void open(File file, Task task, boolean bolBuildIn) throws Exception {
        Task impTask = TaskUtil.loadTask(file);
        impTask.setProjectFile(file);
        if (!task.getBlackboard().contains("DEM") && impTask.getBlackboard().contains("DEM")) {
            task.getBlackboard().put("DEM", impTask.getBlackboard().get("DEM"));
        }
        for (DatastoreMetadata dmd : impTask.getDataStores()) {
            ImportTaskPlugIn.addDMD(dmd, task, impTask, bolBuildIn);
        }
        for (Object smd : impTask.getSymbolStores()) {
            ImportTaskPlugIn.addSMD((SymbolstoreMetadata)smd, task, impTask, bolBuildIn);
        }
        SearchCollectionModel searchCol = (SearchCollectionModel)impTask.getBlackboard().get("LOCAL_SEARCHES");
        if (searchCol != null) {
            for (SearchModel searchModel : searchCol) {
                ImportTaskPlugIn.addSearch(searchModel, task, impTask, bolBuildIn);
            }
        }
        Iterator<Layerable> iLy = impTask.getLayerManager().getLayerables().iterator();
        ArrayList<Layerable> lstImpLy = new ArrayList<Layerable>();
        LayerManager layerManager = task.getLayerManager();
        while (iLy.hasNext()) {
            Layerable ly = iLy.next();
            lstImpLy.add(ly);
            ly.setLayerManager(null);
            String strKey = layerManager.uniqueLayerKey(ly.getKey());
            if (ly.getKey().equals(strKey)) continue;
            layerManager.getLayerableByKey(ly.getKey()).setKey(strKey);
        }
        layerManager.setFiringEvents(false);
        try {
            List<Category> lstCat = impTask.getLayerManager().getSubcategories();
            for (Category cat : lstCat) {
                ImportTaskPlugIn.relinkCategory(cat, task);
                String strNewName = layerManager.uniqueCategoryName(cat.getName());
                if (!strNewName.equals(cat.getName())) {
                    for (Category catRename : layerManager.getAllSubcategories()) {
                        if (!catRename.getName().equals(cat.getName())) continue;
                        catRename.setName(strNewName);
                        strNewName = layerManager.uniqueCategoryName(cat.getName());
                    }
                }
                if (bolBuildIn) {
                    layerManager.addCategoryBuildIn(cat);
                    continue;
                }
                layerManager.addCategory(cat);
            }
            task.reinitCachedObjects();
        }
        finally {
            layerManager.setFiringEvents(true);
        }
        SwingUtilities.invokeLater(() -> {
            for (Layerable la : lstImpLy) {
                layerManager.fireLayerChanged(la, LayerEventType.METADATA_CHANGED);
            }
            layerManager.fireCategoryChanged(layerManager.getRootCatBuildIn(), CategoryEventType.METADATA_CHANGED);
            layerManager.fireCategoryChanged(layerManager.getRootCatLocal(), CategoryEventType.METADATA_CHANGED);
            VisibilityPanel.activateDefaultProfile(task.getLayerManager(), false);
            EditingPanel.instanceOf().resetToDefault();
        });
    }

    public static void relinkCategory(Category cat, Task task) {
        task.getLayerManager().setFiringEvents(false);
        TaskUtil.setParentCat(cat, null);
        cat.setLayerManager(task.getLayerManager());
        task.getLayerManager().setFiringEvents(true);
    }

    private static String uniqueSearchName(SearchCollectionModel searchCol, String strName) {
        if (searchCol == null) {
            return strName;
        }
        for (SearchModel search : searchCol) {
            if (!search.getName().equals(strName)) continue;
            String[] arrName = ((String)strName).split("\\_");
            if (arrName.length == 1) {
                strName = (String)strName + "_1";
            } else {
                try {
                    int num = Integer.parseInt(arrName[arrName.length - 1]);
                    strName = ((String)strName).substring(0, ((String)strName).length() - arrName[arrName.length - 1].length()) + ++num;
                }
                catch (Exception e) {
                    strName = (String)strName + "_1";
                }
            }
            return ImportTaskPlugIn.uniqueSearchName(searchCol, (String)strName);
        }
        return strName;
    }

    private static void addSearch(SearchModel search, Task oriTask, Task impTask, boolean bolBuildIn) {
        String strNewName;
        SearchCollectionModel searchCol = oriTask.getSearches();
        String strName = search.getName();
        if (!strName.equals(strNewName = ImportTaskPlugIn.uniqueSearchName(searchCol, strName))) {
            for (SearchModel rs : oriTask.getSearches()) {
                if (!rs.getName().equals(strName)) continue;
                rs.setName(strNewName);
            }
        }
        if (bolBuildIn) {
            oriSearchCol = oriTask.getBuildInSearches();
            oriSearchCol.addSearch(search);
            oriSearchCol.sortList();
        } else {
            oriSearchCol = oriTask.getLocalSearches();
            oriSearchCol.addSearch(search);
            oriSearchCol.sortList();
        }
        oriTask.reinitCachedObjects();
    }

    private static String uniqueDMDName(DMDCollection dmdCol, String strName) {
        for (DatastoreMetadata dmd : dmdCol) {
            if (!dmd.getName().equals(strName)) continue;
            String[] arrName = ((String)strName).split("\\_");
            if (arrName.length == 1) {
                strName = (String)strName + "_1";
            } else {
                try {
                    int num = Integer.parseInt(arrName[arrName.length - 1]);
                    strName = ((String)strName).substring(0, ((String)strName).length() - arrName[arrName.length - 1].length()) + ++num;
                }
                catch (Exception e) {
                    strName = (String)strName + "_1";
                }
            }
            return ImportTaskPlugIn.uniqueDMDName(dmdCol, (String)strName);
        }
        return strName;
    }

    private static void addDMD(DatastoreMetadata dmd, Task oriTask, Task impTask, boolean bolBuildIn) {
        String strNewName;
        DMDCollection oriDMDCol = oriTask.getDataStores();
        String strName = dmd.getName();
        if (!strName.equals(strNewName = ImportTaskPlugIn.uniqueDMDName(oriDMDCol, strName))) {
            for (DatastoreMetadata dmdReplace : oriTask.getDataStores()) {
                if (!dmdReplace.getName().equals(strName)) continue;
                dmdReplace.setName(strNewName);
            }
            for (Layer ly : oriTask.getLayerManager().getLayers()) {
                if (!ly.getFMD().getDatastoreName().equals(strName)) continue;
                ly.getFMD().setDatastoreName(strNewName);
            }
            for (SearchModel searchModel : oriTask.getSearches()) {
                RootSearchModel rs = (RootSearchModel)searchModel;
                if (!rs.getDatastore().equals(strName)) continue;
                rs.setDatastore(strNewName);
            }
        }
        dmd.adjustDataStoreParams();
        if (bolBuildIn) {
            oriTask.getBuildInDataStores().addDatastore(dmd);
        } else {
            oriTask.getLocalDataStores().addDatastore(dmd);
        }
        oriTask.reinitCachedObjects();
    }

    private static String uniqueSMDName(SMDCollection smdCol, String strName) {
        for (SymbolstoreMetadata smd : smdCol) {
            if (!smd.getName().equals(strName)) continue;
            String[] arrName = ((String)strName).split("\\_");
            if (arrName.length == 1) {
                strName = (String)strName + "_1";
            } else {
                try {
                    int num = Integer.parseInt(arrName[arrName.length - 1]);
                    strName = ((String)strName).substring(0, ((String)strName).length() - arrName[arrName.length - 1].length()) + ++num;
                }
                catch (Exception e) {
                    strName = (String)strName + "_1";
                }
            }
            return ImportTaskPlugIn.uniqueSMDName(smdCol, (String)strName);
        }
        return strName;
    }

    private static void addSMD(SymbolstoreMetadata smd, Task oriTask, Task impTask, boolean bolBuildIn) throws Exception {
        String strNewName;
        SMDCollection oriSMDCol = oriTask.getSymbolStores();
        String strName = smd.getName();
        if (!strName.equals(strNewName = ImportTaskPlugIn.uniqueSMDName(oriSMDCol, strName))) {
            for (SymbolstoreMetadata smdReplace : oriTask.getSymbolStores()) {
                if (!smdReplace.getName().equals(strName)) continue;
                smdReplace.setName(strNewName);
            }
            for (Layer ly : oriTask.getLayerManager().getLayers()) {
                for (StyleCollection sCol : ly.getStyleCollections()) {
                    for (StyleModel objSty : sCol.getStyles()) {
                        if (objSty instanceof BasicStyleModel) {
                            BasicStyleModel bSty = (BasicStyleModel)objSty;
                            if (bSty.isRenderingSymbol() && bSty.getSymStyle().getStrStorename().equals(strName)) {
                                bSty.getSymStyle().setStrStorename(strNewName);
                            }
                            if (bSty.isRenderingFillPattern() && bSty.getStrFillSymStore() != null && bSty.getStrFillSymStore().equals(strName)) {
                                bSty.setStrFillSymStore(strNewName);
                            }
                        }
                        if (!(objSty instanceof ColorThemingStyleModel)) continue;
                        ColorThemingStyleModel tSty = (ColorThemingStyleModel)objSty;
                        BasicStyleModel bSty = tSty.getDefaultStyle();
                        if (bSty.isRenderingSymbol() && bSty.getSymStyle().getStrStorename().equals(strName)) {
                            bSty.getSymStyle().setStrStorename(strNewName);
                        }
                        if (bSty.isRenderingFillPattern() && bSty.getStrFillSymStore() != null && bSty.getStrFillSymStore().equals(strName)) {
                            bSty.setStrFillSymStore(strNewName);
                        }
                        if (!(tSty.getThemeSource() instanceof BasicStaticThemeSourceModel)) continue;
                        BasicStaticThemeSourceModel source = (BasicStaticThemeSourceModel)tSty.getThemeSource();
                        for (Object o : source.getAttributeValueToBasicStyleMap().keySet()) {
                            bSty = (BasicStyleModel)source.getAttributeValueToBasicStyleMap().get(o);
                            if (bSty.isRenderingSymbol() && bSty.getSymStyle().getStrStorename().equals(strName)) {
                                bSty.getSymStyle().setStrStorename(strNewName);
                            }
                            if (!bSty.isRenderingFillPattern() || bSty.getStrFillSymStore() == null || !bSty.getStrFillSymStore().equals(strName)) continue;
                            bSty.setStrFillSymStore(strNewName);
                        }
                    }
                }
            }
        }
        if (bolBuildIn || smd.getSymbolStore() instanceof RedlineLayerSymbolStore) {
            oriTask.getBuildInSymbolStores().addSymbolstore(smd);
        } else {
            oriTask.getLocalSymbolStores().addSymbolstore(smd);
        }
        oriTask.reinitCachedObjects();
    }
}

