/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.project;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.components.ErrorListDialog;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.ImportTaskPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.OpenTaskPlugIn;
import de.riwagis.browser.WindowManager;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirstTaskPlugIn
extends OpenTaskPlugIn {
    private static final Logger LOG = LoggerFactory.getLogger(FirstTaskPlugIn.class);
    public static final String SHOW_DASHBOARD_KEY = "SHOW_DASHBOARD";
    private static boolean initialized = false;
    private ComponentListener componentListener;

    @Override
    public void initialize(final PlugInContext context) throws Exception {
        this.componentListener = new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                FirstTaskPlugIn.loadInitialTaskFile();
                context.getWorkbenchFrame().removeComponentListener(FirstTaskPlugIn.this.componentListener);
            }
        };
        context.getWorkbenchFrame().addComponentListener(this.componentListener);
    }

    public static void loadInitialTaskFile() {
        WorkbenchContext.getFrame().activateDefaultRightPane();
        if (JUMPWorkbench.GIS_CONTEXT != null) {
            FirstTaskPlugIn.initWithGisContext();
        } else {
            FirstTaskPlugIn.initWithoutGisContext();
        }
        initialized = true;
    }

    public static void setInitialized(boolean initialized) {
        FirstTaskPlugIn.initialized = initialized;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static void initWithoutGisContext() {
        block4: {
            try {
                String strPrjs2Import = (String)WorkbenchContext.getBlackboard().get("project");
                if (strPrjs2Import == null) break block4;
                String[] arrPrjs2Import = strPrjs2Import.split("\\|");
                WaitDialog dlg = WaitDialog.createWaitDialog((Window)WorkbenchContext.getFrame(), (String)(I18N.get("ui.plugin.OpenProjectPlugIn.loading") + "... "));
                Runnable run = () -> {
                    try {
                        File f = new File(arrPrjs2Import[0]);
                        FirstTaskPlugIn.open(f, WorkbenchContext.getFrame(), false);
                        WorkbenchContext.getTask().resetModifiedObjects();
                    }
                    catch (Exception e) {
                        dlg.setError(e);
                    }
                };
                dlg.addWorkToDo(run);
                dlg.setCancelable(false);
                dlg.setVisible(true);
                if (dlg.getError() != null) {
                    throw dlg.getError();
                }
                WaitDialog dlgImport = WaitDialog.createWaitDialog((Window)WorkbenchContext.getFrame(), (String)(I18N.get("ui.plugin.io.project.FistTaskPlugIn.import-project") + "... "));
                int i = 1;
                while (i < arrPrjs2Import.length) {
                    int index = i++;
                    run = () -> {
                        try {
                            File f = new File(arrPrjs2Import[index]);
                            if (!f.exists()) {
                                GUISupport.msgbox((Component)dlg, (String)(I18N.get("ui.plugin.io.project.FistTaskPlugIn.project-not-found4import") + f.toString()), (String)I18N.get("common.error"));
                                return;
                            }
                            ImportTaskPlugIn.open(f, WorkbenchContext.getTask(), true);
                            WorkbenchContext.getTask().resetModifiedObjects();
                        }
                        catch (Exception e) {
                            dlgImport.setError(e);
                        }
                    };
                    dlgImport.addWorkToDo(run);
                    dlgImport.setCancelable(false);
                    dlgImport.setVisible(true);
                    if (dlgImport.getError() == null) continue;
                    throw dlgImport.getError();
                }
            }
            catch (Exception ex) {
                String mesg = "<html>Could not load local project file.<br><br>" + ex.getMessage() + "</html>";
                WorkbenchContext.getFrame().warnUser(mesg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initWithGisContext() {
        WaitDialog dlg = WaitDialog.createWaitDialog((Window)WorkbenchContext.getFrame(), (String)(I18N.get("ui.plugin.OpenProjectPlugIn.loading") + "... "));
        ArrayList<String> projectsLoadedWithError = new ArrayList<String>();
        ArrayList<String> projectsNotFound = new ArrayList<String>();
        try {
            String strPrjs2Import;
            Runnable run = () -> {
                try {
                    File f = JUMPWorkbench.GIS_CONTEXT.getModuleApp().getMapDefinition();
                    FirstTaskPlugIn.open(f, WorkbenchContext.getFrame(), true);
                    WorkbenchContext.getTask().resetModifiedObjects();
                    if (PersistentBlackboardPlugIn.get().get(SHOW_DASHBOARD_KEY, false) && JUMPWorkbench.GIS_CONTEXT.getModuleApp().getVersion() >= 1022) {
                        WindowManager.getInstance().openWindow("modules/system/tools/appdashboard/appdash.jsp", "dashboard", 600, 800);
                    }
                }
                catch (Exception e) {
                    dlg.setError(e);
                }
            };
            dlg.addWorkToDo(run);
            dlg.setCancelable(false);
            dlg.setVisible(true);
            if (dlg.getError() != null) {
                throw dlg.getError();
            }
            if (JUMPWorkbench.GIS_CONTEXT.getModuleApp().getUserInfo().containsKey("usr_maps2import") && StringUtils.isNotBlank((CharSequence)(strPrjs2Import = JUMPWorkbench.GIS_CONTEXT.getModuleApp().getUserInfo().get("usr_maps2import").toString()))) {
                String[] arrPrjs2Import = strPrjs2Import.split("\\|");
                for (int i = 0; i < arrPrjs2Import.length; ++i) {
                    WaitDialog dlgImport = WaitDialog.createWaitDialog((Window)WorkbenchContext.getFrame(), (String)(I18N.get("ui.plugin.io.project.FistTaskPlugIn.import-project") + "... "));
                    int index = i;
                    run = () -> FirstTaskPlugIn.createOpenTaskRunnable(arrPrjs2Import, index, projectsNotFound, dlgImport);
                    dlgImport.addWorkToDo(run);
                    dlgImport.setCancelable(false);
                    dlgImport.setVisible(true);
                    if (dlgImport.getError() == null) continue;
                    String errorMessage = I18N.getMessage("ui.plugin.io.project.FistTaskPlugIn.project-with-error-message", arrPrjs2Import[index]);
                    projectsLoadedWithError.add(errorMessage);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Error loading task file", (Throwable)ex);
            String mesg = "<html>Could not load project file from GIS_CONTEXT.<br><br>" + ex.getMessage() + "</html>";
            WorkbenchContext.getFrame().warnUser(mesg);
        }
        finally {
            if (!projectsLoadedWithError.isEmpty()) {
                new ErrorListDialog();
                ErrorListDialog.show((Component)dlg, I18N.get("common.error"), I18N.get("ui.plugin.io.project.FistTaskPlugIn.project-with-error"), projectsLoadedWithError);
            }
            if (!projectsNotFound.isEmpty()) {
                new ErrorListDialog();
                ErrorListDialog.show((Component)dlg, I18N.get("common.error"), I18N.get("ui.plugin.io.project.FistTaskPlugIn.project-not-found4import"), projectsNotFound);
            }
        }
    }

    private static void createOpenTaskRunnable(String[] arrPrjs2Import, int index, List<String> projectsNotFound, WaitDialog dlgImport) {
        try {
            File f = new File(arrPrjs2Import[index]);
            if (!f.exists()) {
                projectsNotFound.add(f.toString());
                return;
            }
            ImportTaskPlugIn.open(f, WorkbenchContext.getTask(), true);
            WorkbenchContext.getTask().resetModifiedObjects();
        }
        catch (Exception e) {
            LOG.error("Error loading task file", (Throwable)e);
            dlgImport.setError(e);
        }
    }
}

