/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.project;

import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.TaskIOEvent;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.TaskIOListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTaskPlugIn
extends ThreadedBasePlugIn {
    private static final List<TaskIOListener> taskIOListeners = new ArrayList<TaskIOListener>();

    public static void addTaskIOListener(TaskIOListener listener) {
        if (!taskIOListeners.contains(listener)) {
            taskIOListeners.add(listener);
        }
    }

    public static boolean removeTaskIOListener(TaskIOListener listener) {
        return taskIOListeners.remove(listener);
    }

    protected static void fireSaveTaskEvent(Task task, File taskFile, String command, int intVersion) {
        TaskIOEvent evt = new TaskIOEvent(task, taskFile, command, intVersion);
        for (TaskIOListener lst : taskIOListeners) {
            lst.taskSaved(evt);
        }
    }

    protected static void fireOpenTaskEvent(Task task, File taskFile) {
        TaskIOEvent evt = new TaskIOEvent(task, taskFile, "open task", -1);
        for (TaskIOListener lst : taskIOListeners) {
            lst.taskOpened(evt);
        }
    }

    protected static void fireImportTaskEvent(Task task, File taskFile) {
        TaskIOEvent evt = new TaskIOEvent(task, taskFile, "import task", -1);
        for (TaskIOListener lst : taskIOListeners) {
            lst.taskImported(evt);
        }
    }

    protected static void fireNewTaskEvent(Task task) {
        TaskIOEvent evt = new TaskIOEvent(task, null, "new task", -1);
        for (TaskIOListener lst : taskIOListeners) {
            lst.newTaskCreated(evt);
        }
    }

    protected AbstractTaskPlugIn() {
    }
}

