/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.project;

import com.vividsolutions.jump.task.TaskUtil;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.AbstractTaskPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.SaveTaskAsPlugIn;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSaveTaskPlugIn
extends AbstractTaskPlugIn {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSaveTaskPlugIn.class);

    public static boolean saveTask(Task task) {
        File file;
        if (task.getProjectFile() != null) {
            file = task.getProjectFile();
        } else {
            if (0 != SaveTaskAsPlugIn.getTaskFileChooser().showSaveDialog(WorkbenchContext.getFrame())) {
                return false;
            }
            file = SaveTaskAsPlugIn.getTaskFileChooser().getSelectedFile();
        }
        File resFile = FileUtil.addExtensionIfNone(file, "jmp");
        try {
            TaskUtil.saveTask(task, resFile);
        }
        catch (Exception e) {
            LOG.warn(String.format("Error saving task to '%s': %s", resFile, e.getMessage()), (Throwable)e);
            return false;
        }
        return true;
    }
}

