/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer.importer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.ShapefileAccessory;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.importer.ImportFormat;
import com.vividsolutions.jump.workbench.ui.plugin.shapefile.ShapefileUtils;
import de.riwagis.geotools.data.shapefile.ShpFileType;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapefileImportFormat
implements ImportFormat {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShapefileImportFormat.class);
    private final ShapefileAccessory accessory = new ShapefileAccessory(false);

    @Override
    public JComponent getAccessory() {
        return this.accessory.getComponent();
    }

    @Override
    public boolean areSettingsValid(JFileChooser fileChooser) {
        String strEncoding = this.accessory.getEncoding();
        try {
            if (StringUtils.isNotEmpty((CharSequence)strEncoding)) {
                Charset.forName(strEncoding);
            }
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            JOptionPane.showMessageDialog(fileChooser, I18N.getMessage("ui.plugin.shapefile.LoadShapefilePlugIn.error-encoding-unsupported", strEncoding), I18N.get("common.error"), 0);
            return false;
        }
        if (!fileChooser.getSelectedFile().exists()) {
            JOptionPane.showMessageDialog(fileChooser, I18N.get("ui.plugin.shapefile.LoadShapefilePlugIn.file-not-exits"), I18N.get("common.error"), 0);
            return false;
        }
        return true;
    }

    @Override
    public void doImport(PlugInContext context, List<File> filesToImport) throws Exception {
        ShapefileUtils.addShapeFiles(context, filesToImport, this.accessory.getEncoding()).displayMessageOrThrow();
    }

    @Override
    public FileFilter getFileFilter() {
        return ShapefileUtils.SHP_FILE_FILTER;
    }

    @Override
    public void onChooserPropertyChanged(PropertyChangeEvent evt) {
        if (!"SelectedFileChangedProperty".equals(evt.getPropertyName())) {
            return;
        }
        File newFile = (File)evt.getNewValue();
        if (newFile == null || newFile.isDirectory()) {
            return;
        }
        String filename = FilenameUtils.removeExtension((String)newFile.getAbsolutePath()).concat(ShpFileType.CPG.extensionWithPeriod);
        File cpgFile = new File(filename);
        if (!cpgFile.exists()) {
            return;
        }
        try {
            String charset = StringUtils.trim((String)Files.readString(Paths.get(cpgFile.getAbsolutePath(), new String[0])));
            if (!StringUtils.isNotEmpty((CharSequence)charset)) {
                return;
            }
            this.accessory.setEncoding(charset.equals("IBM850") ? "cp850" : charset);
        }
        catch (IOException ex) {
            log.error("could not read file " + String.valueOf(cpgFile), (Throwable)ex);
        }
    }

    @Override
    public DatastoreMetadata getOrCreateDataStoreForFile(Task task, File file) {
        String encoding = this.accessory.getEncoding();
        File directory = new File(file.getParent());
        DMDCollection dmds = task.getLocalDataStores();
        return ShapefileUtils.createShapeFileDirectoryDataStore(task, dmds, directory, encoding);
    }

    @Override
    public DatastoreMetadata createDataStoreForFile(Task task, File file) {
        String encoding = this.accessory.getEncoding();
        File directory = new File(file.getParent());
        return ShapefileUtils.forceCreateShapeFileDirectoryDataStore(task, directory, encoding);
    }
}

