/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer.importer;

import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.importer.ImportFormat;
import de.riwagis.util.gui.GUISupport;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ImportFileChooser
extends JFileChooser {
    private final transient Map<FileFilter, ImportFormat> formats;
    private final transient ImportFormat defaultFormat;
    private final transient PlugInContext plugInContext;

    public ImportFileChooser(Map<FileFilter, ImportFormat> formats, Class<? extends ImportFormat> defaultFormatClass, PlugInContext plugInContext) {
        Objects.requireNonNull(plugInContext);
        Objects.requireNonNull(formats);
        this.plugInContext = plugInContext;
        this.formats = formats;
        this.defaultFormat = formats.values().stream().filter(defaultFormatClass::isInstance).findFirst().orElseThrow();
        this.formats.keySet().forEach(this::addChoosableFileFilter);
        this.addPropertyChangeListener(evt -> {
            if ("fileFilterChanged".equals(evt.getPropertyName())) {
                FileFilter newFilter = (FileFilter)evt.getNewValue();
                ImportFormat newFormat = (ImportFormat)formats.get(newFilter);
                JComponent accessory = newFormat.getAccessory();
                this.setAccessory(accessory);
                this.revalidate();
            }
            this.getImportFormat().onChooserPropertyChanged(evt);
        });
        this.setFileFilter(this.defaultFormat.getFileFilter());
        this.setAcceptAllFileFilterUsed(false);
        this.setMultiSelectionEnabled(true);
    }

    @Override
    public void approveSelection() {
        if (GUISupport.selectedFiles((JFileChooser)this).length <= 0) {
            return;
        }
        ImportFormat format = this.getImportFormat();
        if (!format.areSettingsValid(this)) {
            return;
        }
        super.approveSelection();
    }

    public ImportFormat getImportFormat() {
        ImportFormat format = this.formats.get(this.getFileFilter());
        if (format != null) {
            return format;
        }
        File selectedFile = this.getSelectedFile();
        return this.formats.values().stream().filter(es -> es.getFileFilter().accept(selectedFile)).findFirst().orElse(this.defaultFormat);
    }

    public List<File> showImportDialogAndReturnSelection() {
        int state = this.showOpenDialog(this.plugInContext.getWorkbenchFrame());
        if (state == 1 || state == -1) {
            return Collections.emptyList();
        }
        return Arrays.asList(GUISupport.selectedFiles((JFileChooser)this));
    }
}

