/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer.importer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CadLayer;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.importer.ImportFormat;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import de.riwagis.geotools.data.geopkg.GeoPackageDataStoreFactory;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.model.style.CadStyleModel;
import de.riwagis.riwajump.workbench.ui.plugin.ImportMessages;
import de.riwagis.riwajump.workbench.ui.plugin.ImportStyleDefaults;
import de.riwagis.riwajump.workbench.ui.plugin.geopackage.ImportTypeListDialog;
import de.riwagis.util.gui.GUISupport;
import java.awt.Color;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.geotools.geopkg.FeatureEntry;
import org.geotools.geopkg.GeoPackage;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoPackageImportFormat
implements ImportFormat {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeoPackageImportFormat.class);
    public static final String DATASTORE_FILE_KEY = GeoPackageDataStoreFactory.FILE.key;
    public static final String DATASTORE_NAME = "GeoPackage";
    public static final FileFilter FILE_FILTER = GUISupport.createFileFilter((String)"OGC GeoPackage", (String[])new String[]{"gpkg"});
    private ImportTypeListDialog datatypeListDialog;
    private final String defaultCategory;

    public GeoPackageImportFormat() {
        this.defaultCategory = StandardCategoryNames.GEOPACKAGES;
    }

    public GeoPackageImportFormat(String defaultCategory) {
        this.defaultCategory = defaultCategory;
    }

    @Override
    public JComponent getAccessory() {
        return null;
    }

    @Override
    public boolean areSettingsValid(JFileChooser fileChooser) {
        return true;
    }

    @Override
    public void doImport(PlugInContext context, List<File> filesToImport) throws Exception {
        for (File file : filesToImport) {
            this.importGeoPackage(context, file);
        }
    }

    @Override
    public FileFilter getFileFilter() {
        return FILE_FILTER;
    }

    @Override
    public void onChooserPropertyChanged(PropertyChangeEvent evt) {
    }

    @Override
    public DatastoreMetadata getOrCreateDataStoreForFile(Task task, File file) {
        return this.createDataStoreIfNecessary(task, file);
    }

    @Override
    public DatastoreMetadata createDataStoreForFile(Task task, File file) {
        return this.createDataStore(task, file);
    }

    private ImportTypeListDialog getTypeSelectionDialog(JFrame rootFrame) {
        if (this.datatypeListDialog == null) {
            this.datatypeListDialog = new ImportTypeListDialog((Frame)rootFrame, true);
        }
        return this.datatypeListDialog;
    }

    public void addLayerForType(PlugInContext context, DatastoreMetadata dmd, String typeName) throws Exception {
        File gpkgFile = new File((String)dmd.getParameters().get(DATASTORE_FILE_KEY));
        try (GeoPackage geoPackage = new GeoPackage(gpkgFile);){
            FeatureEntry feature = geoPackage.feature(typeName);
            if (feature == null) {
                log.error("Cannot find type {0} in GPKG file {1}", (Object)typeName, (Object)gpkgFile);
            }
            this.createLayersForTypes(context, Collections.singletonList(feature), gpkgFile);
        }
    }

    private void importGeoPackage(PlugInContext context, File gpkgFile) throws Exception {
        List<FeatureEntry> entries = this.getEntries(gpkgFile);
        if (entries.isEmpty()) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(WorkbenchContext.getFrame(), I18N.get("ui.plugin.geopackage.LoadGeoPackagePlugIn.error-no-vector-tables"), I18N.get("common.error"), 0));
        } else if (entries.size() == 1) {
            this.createLayersForTypes(context, entries, gpkgFile);
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference selectedTypes = new AtomicReference(Collections.emptyList());
            SwingUtilities.invokeLater(() -> {
                ImportTypeListDialog typeSelectionDialog = this.getTypeSelectionDialog(context.getWorkbenchFrame());
                typeSelectionDialog.setLocationRelativeTo(context.getWorkbenchFrame());
                typeSelectionDialog.setEntries(entries);
                typeSelectionDialog.setVisible(true);
                if (typeSelectionDialog.wasOKPressed()) {
                    selectedTypes.set(typeSelectionDialog.getSelectedDataTypes());
                }
                latch.countDown();
            });
            latch.await();
            List<FeatureEntry> selectedEntries = selectedTypes.get();
            if (selectedEntries.isEmpty()) {
                log.info("Cancelled GeoPackage Import.");
                return;
            }
            log.info("Importing [{}] types from GeoPackage '{}'.", (Object)selectedEntries.stream().map(x -> x.getTableName()).collect(Collectors.joining(", ")), (Object)gpkgFile);
            this.createLayersForTypes(context, selectedEntries, gpkgFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FeatureEntry> getEntries(File gpkgFile) throws IOException {
        try (GeoPackage geoPackage = null;){
            geoPackage = new GeoPackage(gpkgFile);
            List list = geoPackage.features();
            return list;
        }
    }

    private void createLayersForTypes(PlugInContext context, List<FeatureEntry> selectedEntries, File gpkgFile) throws Exception {
        log.info("Starting to import types from GeoPackage.");
        DatastoreMetadata dmd = this.createDataStoreIfNecessary(context.getTask(), gpkgFile);
        DMDCollection dmds = context.getTask().getLocalDataStores();
        boolean writeable = gpkgFile.canWrite();
        Category category = context.getLayerNamePanel().getSelectedCategoryOrDefault(this.defaultCategory);
        LayerManager layerManager = context.getLayerManager();
        ImportMessages messages = new ImportMessages((type, params) -> {
            switch (type) {
                case CRS_DOES_NOT_MATCH: {
                    return I18N.getMessage("ui.plugin.geopackage.LoadGeoPackagePlugIn.crs-does-not-match", params);
                }
                case OUTSIDE_BOUNDS: {
                    return I18N.getMessage("ui.plugin.geopackage.LoadGeoPackagePlugIn.outside-bounds", params);
                }
            }
            return null;
        });
        for (FeatureEntry entry : selectedEntries) {
            log.info("-> Importing {}", (Object)entry);
            Layer newLayer = layerManager.updateSilently(() -> {
                FeaturestoreMetadata fmd = FeaturestoreMetadata.createFromType(dmd, entry.getTableName());
                SimpleFeatureType schema = fmd.getSchema(dmds);
                boolean isVector = CadFeatureAtts.checkStructure(schema) != null;
                Layer layer = isVector ? this.createVectorLayer(layerManager, entry.getIdentifier(), fmd, schema) : this.createCADLayer(layerManager, entry.getIdentifier(), fmd);
                layer.setKey(entry.getTableName());
                layer.setDescription(entry.getDescription());
                layer.setEditable(writeable);
                messages.createWarnings(schema, context, layer, layerManager);
                return layer;
            });
            category.add(0, newLayer);
        }
        messages.displayMessageOrThrow();
        log.info("Finished Importing from GeoPackage.");
    }

    private Layer createVectorLayer(LayerManager layerManager, String dataTypeName, FeaturestoreMetadata fmd, SimpleFeatureType schema) throws Exception {
        Color color = layerManager.generateLayerFillColor();
        Layer layer = new Layer(dataTypeName, color, fmd, layerManager);
        ImportStyleDefaults.setLayerStyleDefaults(layer, schema);
        ImportStyleDefaults.setLayerStylePerGeometryType(layer, schema, color);
        ImportStyleDefaults.setLayerCaching(layer);
        return layer;
    }

    private Layer createCADLayer(LayerManager layerManager, String dataTypeName, FeaturestoreMetadata fmd) throws Exception {
        CadLayer layer = new CadLayer(dataTypeName, fmd, layerManager);
        layer.setRenderPrio(10300);
        Map<String, Integer> layerMap = layer.autoDetectLayers().stream().collect(Collectors.toUnmodifiableMap(ly -> ly, ly -> -1));
        layer.getStyleCollections().stream().map(style -> style.getStyle(CadStyleModel.class)).forEach(style -> {
            style.setUseOrderBy(true);
            style.setLoadAllLayers(layerMap.isEmpty());
            style.setMapLayerID(layerMap);
            style.setMapLayerVisi(layerMap);
        });
        return layer;
    }

    private DatastoreMetadata createDataStoreIfNecessary(Task task, File gpkgFile) {
        DMDCollection localDataStores = task.getLocalDataStores();
        String stringifiedFile = gpkgFile.toString();
        Optional<DatastoreMetadata> matchingDMD = StreamSupport.stream(localDataStores.spliterator(), false).filter(dmd -> DATASTORE_NAME.equals(dmd.getDataName()) && dmd.getParameters().get(DATASTORE_FILE_KEY).equals(stringifiedFile)).findFirst();
        matchingDMD.ifPresent(DatastoreMetadata::reset);
        return matchingDMD.orElseGet(() -> this.createDataStore(task, gpkgFile));
    }

    private DatastoreMetadata createDataStore(Task task, File gpkgFile) {
        DMDCollection localDataStores = task.getLocalDataStores();
        DMDCollection allDataStores = task.getDataStores();
        String stringifiedFile = gpkgFile.toString();
        log.info("Creating new DataStore for GeoPackage");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(DATASTORE_FILE_KEY, stringifiedFile);
        DatastoreMetadata newDMD = new DatastoreMetadata(allDataStores.findUniqueStoreName(gpkgFile.getName()), DATASTORE_NAME, parameters);
        localDataStores.addDatastore(newDMD);
        task.reinitCachedObjects();
        return newDMD;
    }
}

