/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer.exportstylefactories;

import com.vividsolutions.jump.geom.InteriorPointFinder;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.ExportStyle;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.ExportStyleFactory;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.SymbolRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.TextRenderer;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.ColorThemingStyleModel;
import de.riwagis.riwajump.model.style.LineStyleModel;
import de.riwagis.riwajump.model.style.SymbolStyleModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import de.riwagis.unit.DrawingUnit;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerExportStyleFactory
extends ExportStyleFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LayerExportStyleFactory.class);
    private static final InteriorPointFinder AreaPointFinder;

    private LayerExportStyleFactory() {
    }

    @Override
    public ExportStyle getExportStyle(Layer ly, SimpleFeature f, LayerStyleCollection lySCol, double dblScale) throws Exception {
        BasicStyleModel bStyle;
        BasicStyleModel rootStyle;
        DrawingUnit du = ly.getLayerManager().getTask().getDrawingUnit();
        double dblUnitPixelScale = du.getInchInUnit() / 72.0 * dblScale;
        boolean bolUseTheming = false;
        if (lySCol.getBasicStyle().isEnabled()) {
            rootStyle = lySCol.getBasicStyle();
        } else {
            rootStyle = lySCol.getStyle(ColorThemingStyleModel.class);
            bolUseTheming = true;
        }
        ((StyleRenderer)rootStyle.getIntelligence()).initialize(lySCol);
        ExportStyle expStyle = new ExportStyle(f);
        expStyle.setLayerName(ly.getName());
        if (bolUseTheming) {
            ColorThemingStyleModel thStyle = (ColorThemingStyleModel)rootStyle;
            expStyle.setThemeLabel(((ColorThemingRenderer)thStyle.getIntelligence()).getLabel(f));
            bStyle = ((ColorThemingRenderer)thStyle.getIntelligence()).getStyle(f);
        } else {
            bStyle = rootStyle;
            expStyle.setThemeLabel("");
        }
        LayerExportStyleFactory.setProperties4BasicStyle(expStyle, bStyle, dblScale, dblUnitPixelScale);
        if (bolUseTheming && expStyle.isEnabled()) {
            expStyle.setEnabled(bStyle.isEnabled());
            if (lySCol.getBasicStyle().isShowTooltips()) {
                expStyle.setToolTip(((TextRenderer)lySCol.getBasicStyle().getTooltipStyle().getIntelligence()).getTextForFeature(f));
            }
        }
        return expStyle;
    }

    public static void setProperties4BasicStyle(ExportStyle expStyle, BasicStyleModel bStyle, double dblScale, double dblUnitPixelScale) {
        double dblLineWidth;
        SimpleFeature f = expStyle.getFeature();
        if (bStyle.isShowTooltips()) {
            expStyle.setToolTip(((TextRenderer)bStyle.getTooltipStyle().getIntelligence()).getTextForFeature(f));
        }
        if (!(bStyle.isRenderingFill() || bStyle.getLineBase() != null || bStyle.getLineForeground() != null || bStyle.getLineBackground() != null || bStyle.isRenderingSymbol() || bStyle.isRenderingText())) {
            expStyle.setEnabled(false);
        }
        int intBStyleLengthUnit = bStyle.getLengthUnit();
        if (bStyle.isRenderingFill()) {
            expStyle.setRenderingArea(true);
            expStyle.setAreaColor(RenderUtil.getRenderer(bStyle).getSBFillColor(f));
            expStyle.setRenderingAreaHatch(bStyle.isRenderingFillPattern());
            if (bStyle.isRenderingFillPattern()) {
                expStyle.setAreaHatch(RenderUtil.getRenderer(bStyle).getSBFillSymName(f));
                double dblFillSymWidth = RenderUtil.getRenderer(bStyle).getCalcFillSymWidth(f);
                if (intBStyleLengthUnit == 0) {
                    dblFillSymWidth *= dblUnitPixelScale;
                }
                expStyle.setAreaHatchWidth(dblFillSymWidth);
            }
        } else {
            expStyle.setRenderingArea(false);
        }
        if (bStyle.getLineBase() != null) {
            expStyle.setRenderingLineBase(true);
            LineStyleModel lineBaseStyle = bStyle.getLineBase();
            expStyle.setLineBaseColor(RenderUtil.getRenderer(lineBaseStyle).getSBLineColor(f));
            dblLineWidth = RenderUtil.getRenderer(lineBaseStyle).getCalcLineWidth(f);
            if (intBStyleLengthUnit == 0) {
                dblLineWidth *= dblUnitPixelScale;
            }
            expStyle.setLineBaseWidth(dblLineWidth);
            expStyle.setRenderingLineBasePattern(lineBaseStyle.isRenderingLinePattern());
            if (lineBaseStyle.isRenderingLinePattern()) {
                expStyle.setLineBasePattern(RenderUtil.getRenderer(lineBaseStyle).getSBLinePattern(f));
            }
        } else {
            expStyle.setRenderingLineBase(false);
        }
        if (bStyle.getLineForeground() != null) {
            expStyle.setRenderingLineForeground(true);
            LineStyleModel lineForegroundStyle = bStyle.getLineForeground();
            expStyle.setLineForegroundColor(RenderUtil.getRenderer(lineForegroundStyle).getSBLineColor(f));
            dblLineWidth = RenderUtil.getRenderer(lineForegroundStyle).getCalcLineWidth(f);
            if (intBStyleLengthUnit == 0) {
                dblLineWidth *= dblUnitPixelScale;
            }
            expStyle.setLineForegroundWidth(dblLineWidth);
            expStyle.setRenderingLineForegroundPattern(lineForegroundStyle.isRenderingLinePattern());
            if (lineForegroundStyle.isRenderingLinePattern()) {
                expStyle.setLineForegroundPattern(RenderUtil.getRenderer(lineForegroundStyle).getSBLinePattern(f));
            }
        } else {
            expStyle.setRenderingLineForeground(false);
        }
        if (bStyle.getLineBackground() != null) {
            expStyle.setRenderingLineBackground(true);
            LineStyleModel lineBackgroundStyle = bStyle.getLineBackground();
            expStyle.setLineBackgroundColor(RenderUtil.getRenderer(lineBackgroundStyle).getSBLineColor(f));
            dblLineWidth = RenderUtil.getRenderer(lineBackgroundStyle).getCalcLineWidth(f);
            if (intBStyleLengthUnit == 0) {
                dblLineWidth *= dblUnitPixelScale;
            }
            expStyle.setLineBackgroundWidth(dblLineWidth);
            expStyle.setRenderingLineBackgroundPattern(lineBackgroundStyle.isRenderingLinePattern());
            if (lineBackgroundStyle.isRenderingLinePattern()) {
                expStyle.setLineBackgroundPattern(RenderUtil.getRenderer(lineBackgroundStyle).getSBLinePattern(f));
            }
        } else {
            expStyle.setRenderingLineBackground(false);
        }
        if (bStyle.isRenderingSymbol()) {
            expStyle.setRenderingSymbol(true);
            SymbolStyleModel symStyle = bStyle.getSymStyle();
            LayerExportStyleFactory.setProperties4SymbolStyle(expStyle, symStyle, dblScale, dblUnitPixelScale);
        } else {
            expStyle.setRenderingSymbol(false);
        }
        if (bStyle.isRenderingText()) {
            expStyle.setRenderingText(true);
            TextStyleModel txtStyle = bStyle.getTextStyle();
            LayerExportStyleFactory.setProperties4TextStyle(expStyle, txtStyle, dblScale, dblUnitPixelScale);
        } else {
            expStyle.setRenderingText(false);
        }
        if (!(expStyle.isRenderingArea() || expStyle.isRenderingLineBase() || expStyle.isRenderingSymbol() || expStyle.isRenderingText())) {
            expStyle.setEnabled(false);
        }
    }

    public static void setProperties4SymbolStyle(ExportStyle expStyle, SymbolStyleModel symStyle, double dblScale, double dblUnitPixelScale) {
        double dblSymHeight;
        SimpleFeature f = expStyle.getFeature();
        expStyle.setRenderingSymbol4Geom(0, symStyle.getShowPtSymbol());
        expStyle.setRenderingSymbol4Geom(2, symStyle.getShowStartSymbol());
        expStyle.setRenderingSymbol4Geom(3, symStyle.getShowEndSymbol());
        expStyle.setRenderingSymbol4Geom(4, symStyle.getShowAreaSymbol());
        int intSymUnit = symStyle.getIntUnitSizeSymbol();
        int intSymShiftUnit = symStyle.getIntUnitSize();
        boolean intSymOriUnit = false;
        String strSymbolName = RenderUtil.getRenderer(symStyle).getBshBuilderCache().getStringValue("strPtSymbol", symStyle.getStrPtSymbol(), f, "default.svg");
        expStyle.setSymName4Geom(0, strSymbolName);
        strSymbolName = RenderUtil.getRenderer(symStyle).getBshBuilderCache().getStringValue("strStartSymbol", symStyle.getStrStartSymbol(), f, "default.svg");
        expStyle.setSymName4Geom(2, strSymbolName);
        strSymbolName = RenderUtil.getRenderer(symStyle).getBshBuilderCache().getStringValue("strEndSymbol", symStyle.getStrEndSymbol(), f, "default.svg");
        expStyle.setSymName4Geom(3, strSymbolName);
        strSymbolName = RenderUtil.getRenderer(symStyle).getBshBuilderCache().getStringValue("strAreaSymbol", symStyle.getStrAreaSymbol(), f, "default.svg");
        expStyle.setSymName4Geom(4, strSymbolName);
        double dblSymWidth = RenderUtil.getRenderer(symStyle).getBshBuilderCache().getCalcValue("strPtWidth", symStyle.getStrPtWidth(), f, 2.0);
        if (intSymUnit == 0) {
            dblSymWidth *= dblUnitPixelScale;
        }
        expStyle.setSymWidth4Geom(0, dblSymWidth);
        dblSymWidth = RenderUtil.getRenderer(symStyle).getBshBuilderCache().getCalcValue("strStartWidth", symStyle.getStrStartWidth(), f, 2.0);
        if (intSymUnit == 0) {
            dblSymWidth *= dblUnitPixelScale;
        }
        expStyle.setSymWidth4Geom(2, dblSymWidth);
        dblSymWidth = RenderUtil.getRenderer(symStyle).getBshBuilderCache().getCalcValue("strEndWidth", symStyle.getStrEndWidth(), f, 2.0);
        if (intSymUnit == 0) {
            dblSymWidth *= dblUnitPixelScale;
        }
        expStyle.setSymWidth4Geom(3, dblSymWidth);
        dblSymWidth = RenderUtil.getRenderer(symStyle).getBshBuilderCache().getCalcValue("strAreaWidth", symStyle.getStrAreaWidth(), f, 2.0);
        if (intSymUnit == 0) {
            dblSymWidth *= dblUnitPixelScale;
        }
        expStyle.setSymWidth4Geom(4, dblSymWidth);
        if (!symStyle.isBolPtRatio()) {
            expStyle.setUseSymHeight4Geom(0, true);
            dblSymHeight = RenderUtil.getRenderer(symStyle).getBshBuilderCache().getCalcValue("strPtHeight", symStyle.getStrPtHeight(), f, 2.0);
            if (intSymUnit == 0) {
                dblSymHeight *= dblUnitPixelScale;
            }
            expStyle.setSymHeight4Geom(0, dblSymHeight);
        }
        if (!symStyle.isBolStartRatio()) {
            expStyle.setUseSymHeight4Geom(2, true);
            dblSymHeight = RenderUtil.getRenderer(symStyle).getBshBuilderCache().getCalcValue("strStartHeight", symStyle.getStrStartHeight(), f, 2.0);
            if (intSymUnit == 0) {
                dblSymHeight *= dblUnitPixelScale;
            }
            expStyle.setSymHeight4Geom(2, dblSymHeight);
        }
        if (!symStyle.isBolEndRatio()) {
            expStyle.setUseSymHeight4Geom(3, true);
            dblSymHeight = RenderUtil.getRenderer(symStyle).getBshBuilderCache().getCalcValue("strEndHeight", symStyle.getStrEndHeight(), f, 2.0);
            if (intSymUnit == 0) {
                dblSymHeight *= dblUnitPixelScale;
            }
            expStyle.setSymHeight4Geom(3, dblSymHeight);
        }
        if (!symStyle.isBolAreaRatio()) {
            expStyle.setUseSymHeight4Geom(4, true);
            dblSymHeight = RenderUtil.getRenderer(symStyle).getBshBuilderCache().getCalcValue("strAreaHeight", symStyle.getStrAreaHeight(), f, 2.0);
            if (intSymUnit == 0) {
                dblSymHeight *= dblUnitPixelScale;
            }
            expStyle.setSymHeight4Geom(4, dblSymHeight);
        }
        expStyle.setSymOverwriteLineColor(symStyle.isBolOverwriteLineColor());
        if (symStyle.isBolOverwriteLineColor()) {
            expStyle.setSymLineColor(RenderUtil.getRenderer(symStyle).getSBLineColor(f));
        }
        expStyle.setSymOverwriteFillColor(symStyle.isBolOverwriteAreaColor());
        if (symStyle.isBolOverwriteAreaColor()) {
            expStyle.setSymFillColor(RenderUtil.getRenderer(symStyle).getSBFillColor(f));
        }
        Collection<ExportStyle.InsertionPoint> symInsertPoints = LayerExportStyleFactory.getSymInsertPoints(f, (Geometry)f.getDefaultGeometry(), symStyle, dblUnitPixelScale);
        ExportStyle.InsertionPoint[] arrSymInsertPoints = symInsertPoints.toArray(new ExportStyle.InsertionPoint[symInsertPoints.size()]);
        expStyle.setSymInsertPoints(arrSymInsertPoints);
    }

    public static void setProperties4TextStyle(ExportStyle expStyle, TextStyleModel txtStyle, double dblScale, double dblUnitPixelScale) {
        SimpleFeature f = expStyle.getFeature();
        expStyle.setRenderingText4Geom(0, txtStyle.isBolShowPoint());
        expStyle.setRenderingText4Geom(1, txtStyle.isBolShowLine());
        expStyle.setRenderingText4Geom(4, txtStyle.isBolShowArea());
        int intTxtUnit = txtStyle.getIntUnitLengthText();
        TextRenderer txtRenderer = RenderUtil.getRenderer(txtStyle);
        String strText = RenderUtil.getRenderer(txtStyle).getTextForFeature(f);
        expStyle.setText(strText);
        expStyle.setTextFont(RenderUtil.getRenderer(txtStyle).retrieveAwtFont());
        if (StringUtils.isNotBlank((String)txtRenderer.getModel().getStrHeight())) {
            double dblTxtHeight = txtRenderer.getHeightForFeature(f, expStyle.getTextSize());
            if (intTxtUnit == 0) {
                dblTxtHeight *= dblUnitPixelScale;
            }
            expStyle.setTextSize(dblTxtHeight);
        }
        expStyle.setTextColor(txtRenderer.getSBTextColor(f));
        expStyle.setRenderTextBackground(txtStyle.isBolOpaque());
        if (txtStyle.isBolOpaque()) {
            expStyle.setTextBackgroundColor(RiwaJumpModelUtilities.colorByColorModel(txtStyle.getColorOpaque()));
        }
        Collection<ExportStyle.InsertionPoint> textInsertPoints = LayerExportStyleFactory.getTextInsertPoints(f, txtStyle, dblUnitPixelScale);
        ExportStyle.InsertionPoint[] arrTxtInsertPoints = textInsertPoints.toArray(new ExportStyle.InsertionPoint[textInsertPoints.size()]);
        expStyle.setTextInsertPoints(arrTxtInsertPoints);
    }

    private static Collection<ExportStyle.InsertionPoint> getSymInsertPoints(SimpleFeature f, Geometry geom, SymbolStyleModel symStyle, double dblUnitPixelScale) {
        double dblSymOri;
        LineString line;
        Coordinate coord;
        int intTxtUnit;
        double dblSymOri2;
        double dblSymShiftLeft;
        ArrayList<ExportStyle.InsertionPoint> lstInsertPoint = new ArrayList<ExportStyle.InsertionPoint>();
        SymbolRenderer symRenderer = RenderUtil.getRenderer(symStyle);
        if (geom == null || geom.isEmpty()) {
            return lstInsertPoint;
        }
        if (geom instanceof Point && symStyle.getShowPtSymbol()) {
            Point pt = (Point)geom;
            dblSymShiftLeft = symRenderer.getBshBuilderCache().getCalcValue("strPtShiftLeft", symStyle.getStrPtShiftLeft(), f, 0.0);
            double dblSymShiftTop = symRenderer.getBshBuilderCache().getCalcValue("strPtShiftTop", symStyle.getStrPtShiftTop(), f, 0.0);
            dblSymOri2 = symRenderer.getBshBuilderCache().getCalcValue("strPtOri", symStyle.getStrPtOri(), f, 0.0);
            if (symStyle.getIntUnitAngle() == 1) {
                dblSymOri2 = dblSymOri2 * 180.0 / 200.0;
            }
            if ((intTxtUnit = symStyle.getIntUnitSize()) == 0) {
                dblSymShiftLeft *= dblUnitPixelScale;
                dblSymShiftTop *= dblUnitPixelScale;
            }
            coord = LayerExportStyleFactory.calculateInsertionCoordinate(pt.getCoordinate(), dblSymOri2, dblSymShiftLeft, dblSymShiftTop, symStyle.isBolPtShiftInOri());
            lstInsertPoint.add(new ExportStyle.InsertionPoint(coord, dblSymOri2, 5));
        }
        if (geom instanceof LineString && symStyle.getShowStartSymbol()) {
            line = (LineString)geom;
            dblSymOri = symRenderer.getBshBuilderCache().getCalcValue("strStartOri", symStyle.getStrStartOri(), f, 0.0);
            if (symStyle.getIntUnitAngle() == 1) {
                dblSymOri = dblSymOri * 180.0 / 200.0;
            }
            if (line.getCoordinates().length > 0) {
                Coordinate coord2 = line.getCoordinates()[0];
                lstInsertPoint.add(new ExportStyle.InsertionPoint(coord2, dblSymOri, 5));
            }
        }
        if (geom instanceof LineString && symStyle.getShowEndSymbol()) {
            line = (LineString)geom;
            dblSymOri = symRenderer.getBshBuilderCache().getCalcValue("strEndOri", symStyle.getStrStartOri(), f, 0.0);
            if (symStyle.getIntUnitAngle() == 1) {
                dblSymOri = dblSymOri * 180.0 / 200.0;
            }
            if (line.getCoordinates().length > 0) {
                Coordinate coord3 = line.getCoordinates()[line.getCoordinates().length - 1];
                lstInsertPoint.add(new ExportStyle.InsertionPoint(coord3, dblSymOri, 5));
            }
        }
        if (geom instanceof Polygon && symStyle.getShowAreaSymbol()) {
            Polygon poly = (Polygon)geom;
            dblSymShiftLeft = symRenderer.getBshBuilderCache().getCalcValue("strAreaShiftLeft", symStyle.getStrAreaShiftLeft(), f, 0.0);
            double dblSymShiftTop = symRenderer.getBshBuilderCache().getCalcValue("strAreaShiftTop", symStyle.getStrAreaShiftTop(), f, 0.0);
            dblSymOri2 = symRenderer.getBshBuilderCache().getCalcValue("strAreaOri", symStyle.getStrAreaOri(), f, 0.0);
            if (symStyle.getIntUnitAngle() == 1) {
                dblSymOri2 = dblSymOri2 * 180.0 / 200.0;
            }
            if ((intTxtUnit = symStyle.getIntUnitSize()) == 0) {
                dblSymShiftLeft *= dblUnitPixelScale;
                dblSymShiftTop *= dblUnitPixelScale;
            }
            if (poly.getCoordinates().length > 0) {
                coord = symStyle.getIntAreaPos() == 0 ? AreaPointFinder.findPoint((Geometry)poly) : poly.getCoordinates()[0];
                coord = LayerExportStyleFactory.calculateInsertionCoordinate(coord, dblSymOri2, dblSymShiftLeft, dblSymShiftTop, symStyle.isBolAreaShiftInOri());
                lstInsertPoint.add(new ExportStyle.InsertionPoint(coord, dblSymOri2, 5));
            }
        }
        if (geom instanceof GeometryCollection) {
            GeometryCollection gcol = (GeometryCollection)geom;
            int numGeom = gcol.getNumGeometries();
            for (int i = 0; i < numGeom; ++i) {
                lstInsertPoint.addAll(LayerExportStyleFactory.getSymInsertPoints(f, gcol.getGeometryN(i), symStyle, dblUnitPixelScale));
            }
        }
        return lstInsertPoint;
    }

    private static Collection<ExportStyle.InsertionPoint> getTextInsertPoints(SimpleFeature f, TextStyleModel txtStyle, double dblUnitPixelScale) {
        ArrayList<ExportStyle.InsertionPoint> lstInsertPoint = new ArrayList<ExportStyle.InsertionPoint>();
        TextRenderer txtRenderer = RenderUtil.getRenderer(txtStyle);
        TextRenderer.ModelSpaceLabelSpec lblSpec = txtRenderer.modelSpaceLabelSpec(f);
        for (int i = 0; i < lblSpec.arrlocation.length; ++i) {
            double dblShiftLeft = txtRenderer.getLeftForFeature(f, 0.0);
            double dblShiftTop = txtRenderer.getTopForFeature(f, 0.0);
            int intTxtUnit = txtStyle.getIntUnitLength();
            if (intTxtUnit == 0) {
                dblShiftLeft *= dblUnitPixelScale;
                dblShiftTop *= dblUnitPixelScale;
            }
            lblSpec.arrangle[i] = Math.toDegrees(lblSpec.arrangle[i]);
            Coordinate c = LayerExportStyleFactory.calculateInsertionCoordinate(lblSpec.arrlocation[i], lblSpec.arrangle[i], dblShiftLeft, dblShiftTop, txtStyle.isBolTransInOri());
            lstInsertPoint.add(new ExportStyle.InsertionPoint(c, lblSpec.arrangle[i], lblSpec.arrpos[i]));
        }
        return lstInsertPoint;
    }

    public static Coordinate calculateInsertionCoordinate(Coordinate c, double ori, double shiftLeft, double shiftTop, boolean shiftInOri) {
        if (shiftInOri) {
            try {
                AffineTransform aff = new AffineTransform();
                aff.rotate(Math.toRadians(ori), c.x, c.y);
                aff.translate(shiftLeft, shiftTop);
                return JTS.transform((Coordinate)c, null, (MathTransform)new AffineTransform2D(aff));
            }
            catch (TransformException ex) {
                LOG.error("error calculating insertion point coordinates", (Throwable)ex);
                return new Coordinate(c.x + shiftLeft, c.y + shiftTop, c.z);
            }
        }
        return new Coordinate(c.x + shiftLeft, c.y + shiftTop, c.z);
    }

    static {
        ExportStyleFactory.registerFactory(Layer.class, new LayerExportStyleFactory());
        ExportStyleFactory.registerFactory(LabelLayer.class, new LayerExportStyleFactory());
        AreaPointFinder = new InteriorPointFinder();
    }
}

