/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer.exportstylefactories;

import com.vividsolutions.jump.workbench.model.CadLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.ExportStyle;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.ExportStyleFactory;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exportstylefactories.LayerExportStyleFactory;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import com.vividsolutions.jump.workbench.ui.renderer.style.AbstractCadRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleRenderer;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.model.style.AbstractCadStyleModel;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.CadStyleModel;
import de.riwagis.unit.DrawingUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.opengis.feature.simple.SimpleFeature;

public class AbstractCadLayerExportStyleFactory
extends ExportStyleFactory {
    private AbstractCadLayerExportStyleFactory() {
    }

    @Override
    public ExportStyle getExportStyle(Layer ly, SimpleFeature f, LayerStyleCollection lySCol, double dblScale) throws Exception {
        CadStyleModel cadStyle;
        DrawingUnit du = ly.getLayerManager().getTask().getDrawingUnit();
        double dblUnitPixelScale = du.getInchInUnit() / 72.0 * dblScale;
        AbstractCadStyleModel style4Export = lySCol.getStyle(AbstractCadStyleModel.class);
        if (style4Export == null) {
            return null;
        }
        ((StyleRenderer)style4Export.getIntelligence()).initialize(lySCol);
        String strCadLyName = ObjectUtils.toString((Object)FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.LAYERNAME.getName()));
        if (style4Export instanceof CadStyleModel && !(cadStyle = (CadStyleModel)style4Export).isLoadAllLayers() && !cadStyle.getMapLayerVisi().containsKey(strCadLyName)) {
            return null;
        }
        ((AbstractCadRenderer)style4Export.getIntelligence()).setFeature(f);
        BasicStyleModel bStyle = ((AbstractCadRenderer)style4Export.getIntelligence()).getInternalBasicStyle();
        ExportStyle expStyle = new ExportStyle(f);
        expStyle.setLayerName(ly.getName());
        expStyle.setThemeLabel(strCadLyName);
        LayerExportStyleFactory.setProperties4BasicStyle(expStyle, bStyle, dblScale, dblUnitPixelScale);
        return expStyle;
    }

    static {
        ExportStyleFactory.registerFactory(CadLayer.class, new AbstractCadLayerExportStyleFactory());
        ExportStyleFactory.registerFactory(RedlineLayer.class, new AbstractCadLayerExportStyleFactory());
    }
}

