/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.ExportAccessory;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.ExportFileChooser;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.ExportFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.ShapefileAccessory;
import com.vividsolutions.jump.workbench.ui.plugin.shapefile.ShapefileUtils;
import de.riwagis.geotools.data.shapefile.ShapefileDataStore;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.jts.JTSSupport;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapefileExportFormat
implements ExportFormat {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShapefileExportFormat.class);
    private static final String POINT_SHP_ENDING = "_Point";
    private static final String MULTI_POINT_SHP_ENDING = "_MultiPoint";
    private static final String POLYGON_SHP_ENDING = "_Polygon";
    private static final String LINESTRING_SHP_ENDING = "_LineString";
    private final Map<String, FeatureWriter<SimpleFeatureType, SimpleFeature>> mapWriter = new HashMap<String, FeatureWriter<SimpleFeatureType, SimpleFeature>>();
    private final Map<String, ShapefileDataStore> mapStores = new HashMap<String, ShapefileDataStore>();
    private final ShapefileAccessory accessory = new ShapefileAccessory(true);
    private File targetFile;
    private PlugInContext plugInContext;

    @Override
    public boolean areSettingsValid(ExportFileChooser exportFileChooser) {
        String[] endings;
        String strEncoding = this.accessory.getEncoding();
        try {
            if (StringUtils.isNotEmpty((CharSequence)strEncoding)) {
                Charset.forName(strEncoding);
            }
        }
        catch (UnsupportedCharsetException e) {
            log.error("Could not parse charset for shapefile", (Throwable)e);
            JOptionPane.showMessageDialog(WorkbenchContext.getFrame(), I18N.getMessage("ui.plugin.io.layer.SaveLayerToFilePlugIn.error-encoding-unsupported", strEncoding), I18N.get("common.error"), 0);
            return false;
        }
        File selectedFile = exportFileChooser.getSelectedFile();
        String filePath = selectedFile.getAbsolutePath();
        filePath = StringUtils.removeEndIgnoreCase((String)filePath, (String)".shp");
        filePath = StringUtils.removeEnd((String)filePath, (String)POINT_SHP_ENDING);
        filePath = StringUtils.removeEnd((String)filePath, (String)MULTI_POINT_SHP_ENDING);
        filePath = StringUtils.removeEnd((String)filePath, (String)LINESTRING_SHP_ENDING);
        filePath = StringUtils.removeEnd((String)filePath, (String)POLYGON_SHP_ENDING);
        for (String ending : endings = new String[]{POINT_SHP_ENDING, MULTI_POINT_SHP_ENDING, LINESTRING_SHP_ENDING, POLYGON_SHP_ENDING}) {
            selectedFile = new File(filePath + ending + ".shp");
            if (selectedFile.exists() && !selectedFile.isFile()) {
                return false;
            }
            if (!selectedFile.exists()) continue;
            int response = JOptionPane.showConfirmDialog(WorkbenchContext.getFrame(), I18N.get("ui.GUIUtil.overwrite-file"), I18N.get("common.message"), 0);
            if (response == 0) break;
            return false;
        }
        exportFileChooser.setSelectedFile(new File(filePath + ".shp"));
        return true;
    }

    @Override
    public ExportAccessory getAccessory() {
        return this.accessory;
    }

    private FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterByType(Geometry geometry) throws IOException {
        if (geometry == null || geometry.isEmpty()) {
            return null;
        }
        if (geometry instanceof Point) {
            return this.getFeatureWriter(POINT_SHP_ENDING, Point.class);
        }
        if (geometry instanceof MultiPoint) {
            return this.getFeatureWriter(MULTI_POINT_SHP_ENDING, MultiPoint.class);
        }
        if (geometry instanceof LineString || geometry instanceof MultiLineString) {
            return this.getFeatureWriter(LINESTRING_SHP_ENDING, MultiLineString.class);
        }
        if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
            return this.getFeatureWriter(POLYGON_SHP_ENDING, MultiPolygon.class);
        }
        return null;
    }

    private Charset getSelectedEncoding() {
        return Charset.forName(this.accessory.getEncoding());
    }

    private <T extends Geometry> FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String ending, Class<T> geomClass) throws IOException {
        if (this.mapWriter.containsKey(ending)) {
            return this.mapWriter.get(ending);
        }
        String strFileName = this.targetFile.getPath();
        String strFile = FileSupport.getPathOfFile((String)strFileName) + File.separator + FilenameUtils.getBaseName((String)strFileName) + ending + ".shp";
        File file = new File(strFile);
        ShapefileDataStore store = new ShapefileDataStore(file.toURI().toURL());
        store.setStringCharset(this.getSelectedEncoding());
        store.createSchema(this.getFeatureType(geomClass));
        FeatureWriter writer = store.getFeatureWriterAppend(Transaction.AUTO_COMMIT);
        this.mapWriter.put(ending, (FeatureWriter<SimpleFeatureType, SimpleFeature>)writer);
        this.mapStores.put(ending, store);
        return writer;
    }

    @Override
    public boolean setup(File targetFile, PlugInContext plugInContext) {
        if (this.targetFile != null || this.plugInContext != null) {
            throw new IllegalStateException("ShapeFile Data Source should not be initialized here!");
        }
        this.targetFile = targetFile;
        this.plugInContext = plugInContext;
        this.mapWriter.clear();
        return true;
    }

    @Override
    public boolean writeFeature(SimpleFeature featureToExport) throws IOException {
        boolean nothingSkipped = true;
        Geometry g = (Geometry)featureToExport.getDefaultGeometry();
        if (g == null) {
            return false;
        }
        List lstGeom = JTSSupport.splitGeometryCollections((Geometry)g);
        for (Geometry geom : lstGeom) {
            if (this.writeGeometry(featureToExport, geom)) continue;
            nothingSkipped = false;
        }
        return nothingSkipped;
    }

    private boolean writeGeometry(SimpleFeature source, Geometry geom) throws IOException {
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getWriterByType(geom);
        if (writer == null) {
            return false;
        }
        this.copyAttributes(source, (SimpleFeature)writer.next(), geom);
        writer.write();
        return true;
    }

    private void copyAttributes(SimpleFeature source, SimpleFeature dest, Geometry geom) {
        for (int i = 0; i < source.getAttributeCount(); ++i) {
            Object o = source.getAttribute(i);
            if (o == null || o instanceof Geometry) continue;
            dest.setAttribute(i, o);
        }
        dest.setDefaultGeometry((Object)geom);
    }

    @Override
    public void cleanup() {
        this.targetFile = null;
        this.plugInContext = null;
        for (FeatureWriter<SimpleFeatureType, SimpleFeature> currWriter : this.mapWriter.values()) {
            try {
                currWriter.close();
            }
            catch (Exception e) {
                log.error("could not close feature writer", (Throwable)e);
            }
        }
        this.mapWriter.clear();
        for (ShapefileDataStore currStore : this.mapStores.values()) {
            try {
                currStore.dispose();
            }
            catch (Exception e) {
                log.error("could not close data store", (Throwable)e);
            }
        }
        this.mapStores.clear();
    }

    @Override
    public String getEnding() {
        return ".shp";
    }

    @Override
    public FileFilter getFileFilter() {
        return ShapefileUtils.SHP_FILE_FILTER;
    }

    private SimpleFeatureType getFeatureType(Class<?> geomClass) {
        SimpleFeatureType ftype = this.plugInContext.getSelectedLayer(0).getFeatureType();
        SimpleFeatureTypeBuilder ftFac = new SimpleFeatureTypeBuilder();
        HashMap<String, String> mapNames = new HashMap<String, String>();
        for (int i = 0; i < ftype.getAttributeCount(); ++i) {
            AttributeDescriptor attType = ftype.getDescriptor(i);
            Object strName = attType.getLocalName();
            if (((String)strName).length() > 10) {
                strName = ((String)strName).substring(0, 10);
            }
            int count = 1;
            while (mapNames.containsKey(strName)) {
                strName = ((String)strName).substring(0, Math.min(((String)strName).length(), 8)) + "_" + count;
                ++count;
            }
            mapNames.put((String)strName, (String)strName);
            if (attType instanceof GeometryDescriptor) {
                AttributeTypeBuilder atBuilder = new AttributeTypeBuilder();
                CoordinateReferenceSystem crs = this.getAccessory().getTargetCRS().getCRS();
                if (crs == null) {
                    crs = ((GeometryDescriptor)attType).getCoordinateReferenceSystem();
                }
                atBuilder = atBuilder.name("geom").binding(geomClass).crs(crs);
                GeometryDescriptor attGeom = atBuilder.buildDescriptor("geom", atBuilder.buildGeometryType());
                ftFac.add((AttributeDescriptor)attGeom);
                continue;
            }
            Class<?> clsType = this.convertClassType(attType.getType().getBinding());
            ftFac.add((String)strName, clsType);
        }
        ftFac.setName(ftype.getTypeName());
        return ftFac.buildFeatureType();
    }

    private Class<?> convertClassType(Class<?> binding) {
        if (binding.equals(BigDecimal.class)) {
            return Double.class;
        }
        if (binding.equals(BigInteger.class)) {
            return Long.class;
        }
        if (binding.equals(Object.class)) {
            return String.class;
        }
        return binding;
    }
}

