/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.BasicExportAccessory;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.ExportAccessory;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.ExportFileChooser;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.ExportFormat;
import de.riwagis.crs.Transformer;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.geotools.data.simple.SimpleFeatureWriter;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geopkg.DeletableGeoPackage;
import org.geotools.geopkg.Entry;
import org.geotools.geopkg.FeatureEntry;
import org.geotools.geopkg.GeoPackage;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoPackageExportFormat
implements ExportFormat {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeoPackageExportFormat.class);
    private static final FileFilter FILE_FILTER = GUISupport.createFileFilter((String)"OGC GeoPackage", (String[])new String[]{"gpkg"});
    private final Predicate<String> overwriteExistingLayer;
    private DeletableGeoPackage geoPackage;
    private SimpleFeatureWriter writer;
    private FeatureEntry featureEntry;
    private final BasicExportAccessory exportAccessory;

    public GeoPackageExportFormat() {
        this(layerName -> GUISupport.yesnobox((Component)WorkbenchContext.getFrame(), (String)I18N.getMessage("com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.GeoPackageExportFormat.type-overwrite", layerName), (String)I18N.get("common.alert")));
    }

    GeoPackageExportFormat(Predicate<String> overwriteExistingLayer) {
        this.overwriteExistingLayer = overwriteExistingLayer;
        this.exportAccessory = new BasicExportAccessory();
        this.exportAccessory.addDefaults();
    }

    @Override
    public boolean areSettingsValid(ExportFileChooser exportFileChooser) {
        try {
            Layer selectedLayer = exportFileChooser.getPlugInContext().getSelectedLayer(0);
            File selectedFile = exportFileChooser.getSelectedFileWithEnding();
            String tableName = this.getTableNameForLayer(selectedLayer);
            boolean containsType = this.fileContainsType(tableName, selectedFile);
            if (!containsType) {
                return true;
            }
            return this.overwriteExistingLayer.test(tableName);
        }
        catch (IOException e) {
            log.error("Could not check for existing type in GPKG file", (Throwable)e);
            return false;
        }
    }

    private boolean fileContainsType(String typeName, File selectedFile) throws IOException {
        if (!Files.exists(selectedFile.toPath(), new LinkOption[0])) {
            return false;
        }
        GeoPackage aPackage = new GeoPackage(selectedFile);
        aPackage.init();
        boolean containsType = aPackage.feature(typeName) != null;
        aPackage.close();
        return containsType;
    }

    @Override
    public ExportAccessory getAccessory() {
        return this.exportAccessory;
    }

    @Override
    public boolean setup(File targetFile, PlugInContext plugInContext) {
        if (this.geoPackage != null || this.writer != null || this.featureEntry != null) {
            throw new IllegalStateException("GeoPackage Data Source should not be initialized here!");
        }
        try {
            CoordinateReferenceSystem sourceCRS = plugInContext.getTask().getCRSDefinition().getCRS();
            CoordinateReferenceSystem targetCRS = this.getAccessory().getTargetCRS().getCRS();
            Layer layer = plugInContext.getSelectedLayer(0);
            if (targetCRS == null) {
                SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(plugInContext.getWorkbenchFrame(), I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.GeoPackageExportFormat.no-crs-defined-error"), I18N.get("common.alert"), 0));
                return false;
            }
            if (layer.getFeatureType().getGeometryDescriptor() == null) {
                SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(plugInContext.getWorkbenchFrame(), I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.GeoPackageExportFormat.no-geom-desc-error"), I18N.get("common.alert"), 0));
                return false;
            }
            String tableName = this.getTableNameForLayer(layer);
            this.geoPackage = new DeletableGeoPackage(targetFile);
            this.geoPackage.init();
            this.deleteTypeIfExists(tableName);
            this.featureEntry = new FeatureEntry();
            this.featureEntry.setTableName(tableName);
            this.featureEntry.setIdentifier(layer.getName());
            this.featureEntry.setDescription(layer.getDescription());
            this.featureEntry.setBounds(this.transformEnvelopeIfNecessary(layer.getEnvelope(), sourceCRS, targetCRS));
            this.featureEntry.setZ(true);
            this.geoPackage.create(this.featureEntry, this.transformFeatureTypeIfNecessary(tableName, targetCRS, layer.getFeatureType()));
            this.writer = this.geoPackage.writer(this.featureEntry, true, null, null);
            return true;
        }
        catch (IOException e) {
            log.error("Could not setup GPKG Exporter!", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private String getTableNameForLayer(Layer layer) {
        String tableName = "t_" + layer.getNameForExport();
        return tableName.replaceAll("[\\W_]", "_");
    }

    private void deleteTypeIfExists(String tableName) throws IOException {
        boolean containsName;
        FeatureEntry entry = this.geoPackage.feature(tableName);
        boolean bl = containsName = entry != null;
        if (containsName) {
            log.info("Deleting old type {} in GPKG file", (Object)entry.getTableName());
            this.geoPackage.deleteEntry((Entry)entry);
        }
    }

    private ReferencedEnvelope transformEnvelopeIfNecessary(Envelope sourceEnvelope, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws Exception {
        ReferencedEnvelope envelope = ReferencedEnvelope.create((Envelope)sourceEnvelope, (CoordinateReferenceSystem)targetCRS);
        if (!CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)targetCRS)) {
            Transformer transformer = new Transformer(sourceCRS, targetCRS);
            transformer.transform2d((Envelope)envelope);
        }
        return envelope;
    }

    private SimpleFeatureType transformFeatureTypeIfNecessary(String tableName, CoordinateReferenceSystem crs, SimpleFeatureType featureType) throws SchemaException {
        List<AttributeDescriptor> attributeDescriptors = featureType.getAttributeDescriptors().stream().map(attributeDescriptor -> this.transformAttributeDescriptor((AttributeDescriptor)attributeDescriptor, crs)).collect(Collectors.toUnmodifiableList());
        return FeatureTypes.newFeatureType((AttributeDescriptor[])attributeDescriptors.toArray(new AttributeDescriptor[attributeDescriptors.size()]), (String)tableName);
    }

    private AttributeDescriptor transformAttributeDescriptor(AttributeDescriptor attributeDescriptor, CoordinateReferenceSystem taskCRS) {
        if (!(attributeDescriptor instanceof GeometryDescriptor)) {
            return attributeDescriptor;
        }
        GeometryDescriptor geomDescriptor = (GeometryDescriptor)attributeDescriptor;
        CoordinateReferenceSystem oldCRS = geomDescriptor.getCoordinateReferenceSystem();
        return new AttributeTypeBuilder().name(geomDescriptor.getLocalName()).binding(geomDescriptor.getType().getBinding()).crs(taskCRS != null ? taskCRS : oldCRS).buildDescriptor(geomDescriptor.getLocalName());
    }

    @Override
    public boolean writeFeature(SimpleFeature featureToExport) throws IOException {
        if (featureToExport.getDefaultGeometry() == null) {
            log.warn("Tried to export feature with NULL Geometry. This is not allowed in geopackages.");
            return false;
        }
        SimpleFeature target = (SimpleFeature)this.writer.next();
        FeatureUtil.copyFeatureData((SimpleFeature)featureToExport, (SimpleFeature)target);
        this.writer.write();
        return true;
    }

    @Override
    public void cleanup() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.geoPackage != null && this.featureEntry != null && !this.geoPackage.hasSpatialIndex(this.featureEntry)) {
                this.geoPackage.createSpatialIndex(this.featureEntry);
            }
        }
        catch (IOException ioe) {
            log.error("Could not close writer and create spatial index", (Throwable)ioe);
        }
        if (this.geoPackage != null) {
            this.geoPackage.close();
        }
        this.writer = null;
        this.featureEntry = null;
        this.geoPackage = null;
    }

    @Override
    public String getEnding() {
        return ".gpkg";
    }

    @Override
    public FileFilter getFileFilter() {
        return FILE_FILTER;
    }
}

