/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter;

import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.DummyExportFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.ExportAccessory;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.ExportFormat;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.util.gui.GUISupport;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;

public class ExportFileChooser
extends JFileChooser {
    private final transient Map<FileFilter, ExportFormat> formats;
    private final transient ExportFormat defaultFormat;
    private final transient ExportFormat dummyFormat = new DummyExportFormat();
    private final transient PlugInContext plugInContext;

    public ExportFileChooser(Map<FileFilter, ExportFormat> formats, Class<? extends ExportFormat> defaultFormatClass, PlugInContext plugInContext) {
        Objects.requireNonNull(plugInContext);
        Objects.requireNonNull(formats);
        this.plugInContext = plugInContext;
        this.formats = formats;
        this.defaultFormat = formats.values().stream().filter(defaultFormatClass::isInstance).findFirst().orElseThrow();
        this.formats.keySet().forEach(this::addChoosableFileFilter);
        CRSDefinition taskCRS = plugInContext.getTask().getCRSDefinition();
        this.dummyFormat.getAccessory().setTargetCRS(taskCRS);
        this.dummyFormat.getAccessory().setSourceCRS(taskCRS);
        this.addPropertyChangeListener(evt -> {
            if ("fileFilterChanged".equals(evt.getPropertyName())) {
                FileFilter oldFilter = (FileFilter)evt.getOldValue();
                ExportFormat oldFormat = formats.getOrDefault(oldFilter, this.dummyFormat);
                FileFilter newFilter = (FileFilter)evt.getNewValue();
                ExportFormat newFormat = formats.getOrDefault(newFilter, this.dummyFormat);
                ExportAccessory accessory = newFormat.getAccessory();
                JComponent component = accessory.getComponent();
                accessory.setTargetCRS(oldFormat.getAccessory().getTargetCRS());
                accessory.setSourceCRS(oldFormat.getAccessory().getSourceCRS());
                this.setAccessory(component);
                this.revalidate();
                this.repaint();
            }
        });
        this.setFileFilter(this.defaultFormat.getFileFilter());
        this.setAcceptAllFileFilterUsed(false);
    }

    public PlugInContext getPlugInContext() {
        return this.plugInContext;
    }

    @Override
    public void approveSelection() {
        if (GUISupport.selectedFiles((JFileChooser)this).length != 1) {
            return;
        }
        ExportFormat format = this.getExportFormat();
        if (!format.areSettingsValid(this)) {
            return;
        }
        super.approveSelection();
    }

    public ExportFormat getExportFormat() {
        ExportFormat format = this.formats.get(this.getFileFilter());
        if (format != null) {
            return format;
        }
        File selectedFile = this.getSelectedFile();
        return this.formats.values().stream().filter(es -> es.getFileFilter().accept(selectedFile)).findFirst().orElse(this.defaultFormat);
    }

    private File addSuffixIfMissing(File fileName, String suffix) {
        if (StringUtils.endsWithIgnoreCase((CharSequence)fileName.getPath(), (CharSequence)suffix)) {
            return fileName;
        }
        return new File(fileName.getPath() + suffix);
    }

    public Optional<File> showExportDialogAndReturnTargetFile() {
        int state = this.showSaveDialog(this.plugInContext.getWorkbenchFrame());
        if (state == 1 || state == -1) {
            return Optional.empty();
        }
        return Optional.of(this.getSelectedFileWithEnding());
    }

    public File getSelectedFileWithEnding() {
        return this.addSuffixIfMissing(this.getSelectedFile(), this.getExportFormat().getEnding());
    }
}

