/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.ExportAccessory;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.icons.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BasicExportAccessory
implements ExportAccessory {
    private final JPanel accessoryComponent;
    private final JComboBox<CRSDefinition> cbCRS;
    private final JLabel lblWarning = new JLabel();
    private CRSDefinition sourceCRS;
    private int rowCount = 0;

    public BasicExportAccessory() {
        this.accessoryComponent = new JPanel();
        this.accessoryComponent.setLayout(new GridBagLayout());
        this.cbCRS = new JComboBox<CRSDefinition>(this.retrieveSortedCRSList());
        this.cbCRS.setPrototypeDisplayValue(CRSDefFactory.getDefaultCRSDefinition());
        this.cbCRS.addActionListener(e -> this.updateWarningVisibility());
        this.addFillerElementAtBottom();
    }

    private void addFillerElementAtBottom() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 3;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 99;
        this.accessoryComponent.add(Box.createVerticalGlue(), c);
    }

    public void addDefaults() {
        this.addOption(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.BasicExportAccessory.label-target-crs"), this.cbCRS);
        this.addConversionWarningOption();
    }

    private void addConversionWarningOption() {
        this.lblWarning.setText(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.BasicExportAccessory.warning-crs-conversion"));
        this.lblWarning.setIcon(IconLoader.svgIcon((String)"common_attention.svg"));
        this.lblWarning.setPreferredSize(new Dimension(200, 40));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 23;
        c.gridx = 0;
        c.gridy = this.rowCount++;
        c.insets = new Insets(0, 5, 5, 5);
        this.accessoryComponent.add((Component)this.lblWarning, c);
    }

    private CRSDefinition[] retrieveSortedCRSList() {
        ArrayList lstCRS = new ArrayList(CRSDefFactory.getCRSDefinitionList());
        Collections.sort(lstCRS);
        return (CRSDefinition[])lstCRS.toArray(CRSDefinition[]::new);
    }

    public void addOption(String label, JComponent optionComponent) {
        JLabel jlabel = new JLabel(label);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 23;
        c.gridx = 0;
        c.gridy = this.rowCount++;
        c.insets = new Insets(5, 5, 5, 5);
        this.accessoryComponent.add((Component)jlabel, c);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = this.rowCount++;
        c.insets = new Insets(0, 5, 5, 5);
        this.accessoryComponent.add((Component)optionComponent, c);
    }

    @Override
    public CRSDefinition getSourceCRS() {
        return this.sourceCRS;
    }

    @Override
    public CRSDefinition getTargetCRS() {
        return (CRSDefinition)this.cbCRS.getSelectedItem();
    }

    @Override
    public void setSourceCRS(CRSDefinition sourceCRS) {
        this.sourceCRS = sourceCRS;
        this.updateWarningVisibility();
    }

    @Override
    public void setTargetCRS(CRSDefinition targetCRS) {
        this.cbCRS.setSelectedItem(targetCRS);
        this.updateWarningVisibility();
    }

    @Override
    public JComponent getComponent() {
        return this.accessoryComponent;
    }

    private void updateWarningVisibility() {
        this.lblWarning.setVisible(this.sourceCRS != this.cbCRS.getSelectedItem());
    }
}

