/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.EditorFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.WizardExchangeData;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import de.riwagis.riwajump.data.gui.FeatureTypePanel;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeatureType;

public class WizFeatureTypePanel
extends JPanel
implements WizardPanel {
    private final EditorFormat editorFormat;
    private PlugInContext context = null;
    private Map<String, Object> dataMap = null;
    private final List<InputChangedListener> lstListeners = new ArrayList<InputChangedListener>();
    private int intMode = 0;
    private SimpleFeatureType fType = null;
    private String[] arrTypeNames = null;
    private JLabel lblError;
    private JPanel pnlSchema;

    public WizFeatureTypePanel(PlugInContext context, SimpleFeatureType fType, int intMode, EditorFormat editorFormat) {
        this.intMode = intMode;
        this.fType = fType;
        this.context = context;
        this.editorFormat = editorFormat;
        this.initComponents();
        this.init();
    }

    private void init() {
        FeatureTypePanel fTypePanel = (FeatureTypePanel)this.pnlSchema;
        fTypePanel.addActionListener(e -> this.fireInputChange());
        this.editorFormat.setupTypePanel(fTypePanel);
    }

    @Override
    public void enteredFromLeft(Map<String, Object> dataMap) {
        this.dataMap = dataMap;
        DatastoreMetadata dmd = (DatastoreMetadata)dataMap.get(WizardExchangeData.DATASTORE.name());
        if (dmd == null) {
            dmd = this.editorFormat.getOrCreateDataStore(this.context.getTask(), (File)dataMap.get(WizardExchangeData.FILENAME.name()));
            dataMap.put(WizardExchangeData.DATASTORE.name(), dmd);
        }
        try {
            this.arrTypeNames = dmd.getDataStore().getTypeNames();
            FeatureTypePanel typePanel = (FeatureTypePanel)this.pnlSchema;
            if (this.intMode == 1) {
                if (this.editorFormat.editAllDataTypesAtOnce()) {
                    typePanel.setDMD(dmd);
                    typePanel.setTypesAndSelect(this.arrTypeNames, null);
                } else {
                    String typeName = (String)dataMap.get(WizardExchangeData.TYPENAME.name());
                    SimpleFeatureType oldFType = this.editorFormat.getSchemaFromStore(dmd.getDataStore(), typeName);
                    typePanel.setFeatureType(oldFType);
                }
            }
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    @Override
    public void enteredFromRight(Map<String, Object> dataMap) {
    }

    @Override
    public void exitingToRight() throws Exception {
        FeatureTypePanel typePanel = (FeatureTypePanel)this.pnlSchema;
        typePanel.stopEditing();
        this.dataMap.put(WizardExchangeData.TARGET_FEATURETYPE.name(), typePanel.getFeatureType());
        this.dataMap.put(WizardExchangeData.UPDATED_ATTRIBUTES.name(), typePanel.getUpdatedAttributesMap());
        this.dataMap.put(WizardExchangeData.HAS_UNSAVED_CHANGES.name(), typePanel.hasUnsavedChanges());
    }

    @Override
    public void exitingToLeft() {
        FeatureTypePanel typePanel = (FeatureTypePanel)this.pnlSchema;
        typePanel.stopEditing();
    }

    @Override
    public void cleanupAtCancel(Map<String, Object> dataMap) {
    }

    @Override
    public void add(InputChangedListener listener) {
        this.lstListeners.add(listener);
    }

    @Override
    public void remove(InputChangedListener listener) {
        if (this.lstListeners.contains(listener)) {
            this.lstListeners.remove(listener);
        }
    }

    private void fireInputChange() {
        for (InputChangedListener listener : this.lstListeners) {
            listener.inputChanged();
        }
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.plugin.shapefile.WizFeatureTypePanel.title");
    }

    @Override
    public String getID() {
        if (this.intMode == 1) {
            return "3";
        }
        return "2";
    }

    @Override
    public String getInstructions() {
        return I18N.getMessage("ui.plugin.shapefile.WizFeatureTypePanel.instructions", this.editorFormat.getLocalizedFormatName());
    }

    private void setError(String strError) {
        this.lblError.setText(strError);
    }

    @Override
    public boolean isInputValid() {
        SimpleFeatureType newFType = ((FeatureTypePanel)this.pnlSchema).getFeatureType();
        if (newFType == null) {
            return false;
        }
        String formatErrors = this.editorFormat.isValid(newFType);
        if (formatErrors != null) {
            this.setError(formatErrors);
            return false;
        }
        if (this.intMode == 0) {
            boolean bolNameFound = false;
            for (String arrTypeName : this.arrTypeNames) {
                if (!arrTypeName.equalsIgnoreCase(newFType.getTypeName())) continue;
                bolNameFound = true;
                break;
            }
            if (bolNameFound) {
                this.setError(I18N.get("ui.plugin.shapefile.WizFeatureTypePanel.wrong-type-name"));
                return false;
            }
            if (newFType.getTypeName().isBlank()) {
                this.setError(I18N.get("typename-cannot-be-empty"));
                return false;
            }
            this.setError("");
            return true;
        }
        if (this.intMode == 1) {
            if (this.editorFormat.editAllDataTypesAtOnce()) {
                this.setError("");
                return true;
            }
            boolean bolNameFound = false;
            for (String arrTypeName : this.arrTypeNames) {
                if (!arrTypeName.equalsIgnoreCase(newFType.getTypeName())) continue;
                bolNameFound = true;
                break;
            }
            if (bolNameFound) {
                this.setError("");
                return true;
            }
            this.setError(I18N.get("ui.plugin.shapefile.WizFeatureTypePanel.type-name-not-found"));
            return false;
        }
        return false;
    }

    @Override
    public String getNextID() {
        return null;
    }

    public SimpleFeatureType getFeatureType() {
        return ((FeatureTypePanel)this.pnlSchema).getFeatureType();
    }

    private void initComponents() {
        this.pnlSchema = new FeatureTypePanel(this.context, this.fType, this.intMode, this.editorFormat);
        this.lblError = new JLabel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.pnlSchema, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblError, gridBagConstraints);
    }
}

