/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerToFilePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.EditorFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.WizardExchangeData;
import com.vividsolutions.jump.workbench.ui.plugin.shapefile.ShapefileUtils;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import de.riwagis.guitools.Tasks;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeatureType;

public class WizCopyFilePanel
extends JPanel
implements WizardPanel {
    private String title;
    private PlugInContext context = null;
    private Map<String, Object> dataMap;
    private final EditorFormat editorFormat;
    private JButton btnCopy;
    private JLabel lblMessage;

    public WizCopyFilePanel(PlugInContext context, EditorFormat editorFormat) {
        this.context = context;
        this.editorFormat = editorFormat;
        this.initComponents();
        this.i18n();
    }

    private void i18n() {
        this.title = I18N.get("ui.plugin.shapefile.UpdateShapefilePlugIn.title-make-backup");
        this.lblMessage.setText(I18N.getMessage("ui.plugin.shapefile.UpdateShapefilePlugIn.message-make-backup", this.editorFormat.getLocalizedFormatName()));
    }

    public JLabel getInternalMessageLabel() {
        return this.lblMessage;
    }

    private void initComponents() {
        this.lblMessage = new JLabel();
        this.btnCopy = new JButton();
        this.setLayout(new GridBagLayout());
        this.lblMessage.setHorizontalAlignment(0);
        this.lblMessage.setText("jLabel1");
        this.lblMessage.setHorizontalTextPosition(0);
        this.lblMessage.setMaximumSize(new Dimension(400, 300));
        this.lblMessage.setMinimumSize(new Dimension(300, 200));
        this.lblMessage.setPreferredSize(new Dimension(300, 300));
        this.add((Component)this.lblMessage, new GridBagConstraints());
        this.btnCopy.setText("Kopie erstellen");
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WizCopyFilePanel.this.btnCopyActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.btnCopy, gridBagConstraints);
    }

    private void btnCopyActionPerformed(ActionEvent evt) {
        SimpleFeatureType oldFeatureType;
        DatastoreMetadata oldDmd = (DatastoreMetadata)this.dataMap.get(WizardExchangeData.DATASTORE.name());
        if (oldDmd == null) {
            Assert.shouldNeverReachHere((String)"datastore is null");
        }
        if ((oldFeatureType = (SimpleFeatureType)this.dataMap.get(WizardExchangeData.SOURCE_FEATURETYPE.name())) == null) {
            Assert.shouldNeverReachHere((String)"oldFeatureType is null");
        }
        String sourceFile = this.editorFormat.getFileSystemSchemaSource(oldDmd, oldFeatureType.getTypeName());
        File defaultCopyFile = new File(I18N.getMessage("backup-file-template", FilenameUtils.removeExtension((String)sourceFile), this.editorFormat.getFileEnding()));
        JFileChooser fileChooser = GUIUtil.createJFileChooserWithOverwritePrompting();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogType(1);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(this.editorFormat.getFileFilter());
        fileChooser.setFileFilter(this.editorFormat.getFileFilter());
        fileChooser.setSelectedFile(defaultCopyFile);
        int state = fileChooser.showSaveDialog(JUMPWorkbench.getFrame());
        if (state == 1 || state == -1) {
            return;
        }
        File backupFile = new File(ShapefileUtils.addSuffix(fileChooser.getSelectedFile().toString(), this.editorFormat.getFileEnding()));
        PersistentBlackboardPlugIn.get().put(SaveLayerToFilePlugIn.KEY_EXPORT_PATH, backupFile.getAbsolutePath());
        Tasks.submit(() -> this.editorFormat.backupFeatureType(this.context.getTask(), oldDmd, oldFeatureType, backupFile), false, SwingUtilities.getWindowAncestor(this));
    }

    @Override
    public void enteredFromLeft(Map<String, Object> dataMap) {
        this.dataMap = dataMap;
    }

    @Override
    public void enteredFromRight(Map<String, Object> dataMap) {
        this.dataMap = dataMap;
    }

    @Override
    public void exitingToRight() throws Exception {
    }

    @Override
    public void exitingToLeft() {
    }

    @Override
    public void cleanupAtCancel(Map<String, Object> dataMap) {
    }

    @Override
    public void add(InputChangedListener listener) {
    }

    @Override
    public void remove(InputChangedListener listener) {
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getID() {
        return "2";
    }

    @Override
    public String getInstructions() {
        return "";
    }

    @Override
    public boolean isInputValid() {
        return true;
    }

    @Override
    public String getNextID() {
        return "3";
    }
}

