/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.EditorFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.WizardExchangeData;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lombok.Generated;
import org.geotools.data.DataStore;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizChooseFeatureTypePanel
extends JPanel
implements WizardPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WizChooseFeatureTypePanel.class);
    private PlugInContext context = null;
    private Map<String, Object> dataMap = null;
    private final List<InputChangedListener> lstListeners = new ArrayList<InputChangedListener>();
    private final EditorFormat editorFormat;
    private JComboBox<TypeEntry<?>> cbFeatureTypes;
    private JLabel lblFeatureTypes;
    private JLabel lblStoreErrors;
    private JList<String> listStoreErrors;
    private JScrollPane spStoreErrors;

    public WizChooseFeatureTypePanel(PlugInContext context, EditorFormat editorFormat) {
        this.context = context;
        this.editorFormat = editorFormat;
        this.initComponents();
        this.i18n();
    }

    private void i18n() {
        this.lblFeatureTypes.setText(I18N.get("ui.plugin.shapefile.WizChooseFeatureTypePanel.featuretypes"));
    }

    @Override
    public void enteredFromLeft(Map<String, Object> dataMap) {
        AbstractListModel model;
        this.dataMap = dataMap;
        DMDCollection dmdCol = this.context.getTask().getLocalDataStores();
        TreeSet setTypeNames = new TreeSet();
        TreeSet typesWithErrors = new TreeSet();
        if (this.editorFormat.editAllDataTypesAtOnce()) {
            this.collectEntriesFromStores(dmdCol, setTypeNames, typesWithErrors);
        } else {
            this.collectEntriesFromLayers(dmdCol, setTypeNames, typesWithErrors);
        }
        boolean testErrors = !typesWithErrors.isEmpty();
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        GridBagConstraints constraints = layout.getConstraints(this.cbFeatureTypes);
        if (testErrors) {
            model = new DefaultListModel<String>();
            ((DefaultListModel)model).addAll(typesWithErrors.stream().map(Objects::toString).toList());
            this.listStoreErrors.setModel(model);
            constraints.weighty = 0.0;
        } else {
            constraints.weighty = 1.0;
        }
        layout.setConstraints(this.cbFeatureTypes, constraints);
        this.lblStoreErrors.setVisible(testErrors);
        this.spStoreErrors.setVisible(testErrors);
        model = new DefaultComboBoxModel();
        for (TypeEntry typeEntry : setTypeNames) {
            ((DefaultComboBoxModel)model).addElement((TypeEntry)typeEntry);
        }
        this.cbFeatureTypes.setModel((ComboBoxModel<TypeEntry<?>>)((Object)model));
    }

    private void collectEntriesFromLayers(DMDCollection dmdCol, SortedSet<TypeEntry<?>> entries, SortedSet<TypeEntry<?>> entriesWithErrors) {
        for (Layerable layerable : this.context.getLayerManager().getRootCatLocal().getAllLayerables()) {
            SingleTypeEntry entry;
            Layer layer;
            FeaturestoreMetadata fmd;
            DatastoreMetadata dmd;
            if (!(layerable instanceof Layer) || (dmd = dmdCol.getByName((fmd = (layer = (Layer)layerable).getFMD()).getDatastoreName())) == null || !dmd.getDataName().equals(this.editorFormat.getStoreTypeName()) || entries.contains(entry = new SingleTypeEntry(this, dmd, fmd.getDatatypeName()))) continue;
            try {
                DataStore ds = dmd.getDataStore();
                if (ds == null || ds.getSchema(fmd.getDatatypeName()) == null) {
                    entriesWithErrors.add(entry);
                    continue;
                }
                entries.add(entry);
            }
            catch (Exception e) {
                log.error("Could not get data store", (Throwable)e);
                entriesWithErrors.add(entry);
            }
        }
    }

    private void collectEntriesFromStores(DMDCollection dmdCol, SortedSet<TypeEntry<?>> entries, SortedSet<TypeEntry<?>> entriesWithErrors) {
        for (DatastoreMetadata dmd : this.context.getTask().getDataStores()) {
            MultiTypeEntry entry;
            if (dmd == null || !dmd.getDataName().equals(this.editorFormat.getStoreTypeName()) || entries.contains(entry = new MultiTypeEntry(this, dmd))) continue;
            try {
                DataStore ds = dmd.getDataStore();
                if (ds == null || ds.getTypeNames() == null) {
                    entriesWithErrors.add(entry);
                    continue;
                }
                entries.add(entry);
            }
            catch (Exception e) {
                log.error("Could not get data store", (Throwable)e);
                entriesWithErrors.add(entry);
            }
        }
    }

    @Override
    public void enteredFromRight(Map<String, Object> dataMap) {
    }

    @Override
    public void exitingToRight() throws Exception {
        TypeEntry entry = (TypeEntry)this.cbFeatureTypes.getSelectedItem();
        SimpleFeatureType fType = entry.getFeatureType();
        String typeName = fType != null ? fType.getTypeName() : null;
        this.dataMap.put(WizardExchangeData.DATASTORE.name(), entry.getDMD());
        this.dataMap.put(WizardExchangeData.TYPENAME.name(), typeName);
        this.dataMap.put(WizardExchangeData.SOURCE_FEATURETYPE.name(), fType);
    }

    @Override
    public void exitingToLeft() {
    }

    @Override
    public void cleanupAtCancel(Map<String, Object> dataMap) {
    }

    @Override
    public void add(InputChangedListener listener) {
        this.lstListeners.add(listener);
    }

    @Override
    public void remove(InputChangedListener listener) {
        if (this.lstListeners.contains(listener)) {
            this.lstListeners.remove(listener);
        }
    }

    private void fireInputChange() {
        for (InputChangedListener listener : this.lstListeners) {
            listener.inputChanged();
        }
    }

    @Override
    public String getTitle() {
        return I18N.getMessage("ui.plugin.shapefile.WizChooseFeatureTypePanel.title", this.editorFormat.getLocalizedFormatName());
    }

    @Override
    public String getID() {
        return "1";
    }

    @Override
    public String getInstructions() {
        return I18N.getMessage("ui.plugin.shapefile.WizChooseFeatureTypePanel.instructions", this.editorFormat.getLocalizedFormatName());
    }

    @Override
    public boolean isInputValid() {
        return this.cbFeatureTypes.getSelectedItem() != null;
    }

    @Override
    public String getNextID() {
        return "2";
    }

    private void initComponents() {
        this.lblFeatureTypes = new JLabel();
        this.cbFeatureTypes = new JComboBox();
        this.lblStoreErrors = new JLabel();
        this.spStoreErrors = new JScrollPane();
        this.listStoreErrors = new JList();
        this.setLayout(new GridBagLayout());
        this.lblFeatureTypes.setText("Liste der Dateien:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 9, 9, 3);
        this.add((Component)this.lblFeatureTypes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 9, 9);
        this.add(this.cbFeatureTypes, gridBagConstraints);
        this.lblStoreErrors.setIcon(IconLoader.svgIcon((String)"common_attention.svg"));
        this.lblStoreErrors.setText(I18N.get("error-following-stores-finished-test-with-error"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 9, 9, 9);
        this.add((Component)this.lblStoreErrors, gridBagConstraints);
        this.listStoreErrors.setEnabled(false);
        this.spStoreErrors.setViewportView(this.listStoreErrors);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 9, 9, 9);
        this.add((Component)this.spStoreErrors, gridBagConstraints);
    }

    private static interface TypeEntry<T extends TypeEntry>
    extends Comparable<T> {
        public SimpleFeatureType getFeatureType() throws IOException;

        public DatastoreMetadata getDMD();
    }

    private class SingleTypeEntry
    implements TypeEntry<SingleTypeEntry> {
        final DatastoreMetadata dmd;
        final String typeName;
        final String source;

        SingleTypeEntry(WizChooseFeatureTypePanel wizChooseFeatureTypePanel, DatastoreMetadata dmd, String typeName) {
            this.dmd = dmd;
            this.typeName = typeName;
            this.source = wizChooseFeatureTypePanel.editorFormat.getFileSystemStoreSource(dmd);
            if (this.source == null) {
                Assert.shouldNeverReachHere((String)"Cannot retrieve file system source of feature store");
            }
        }

        @Override
        public DatastoreMetadata getDMD() {
            return this.dmd;
        }

        @Override
        public SimpleFeatureType getFeatureType() throws IOException {
            return this.dmd.getDataStore().getSchema(this.typeName);
        }

        public int hashCode() {
            int hash = 5;
            hash = 23 * hash + Objects.hashCode(this.typeName);
            hash = 23 * hash + Objects.hashCode(this.source);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SingleTypeEntry other = (SingleTypeEntry)obj;
            if (!Objects.equals(this.typeName, other.typeName)) {
                return false;
            }
            return Objects.equals(this.source, other.source);
        }

        public String toString() {
            return this.typeName + " (" + this.source + ")";
        }

        @Override
        public int compareTo(SingleTypeEntry o) {
            if (this.equals(o)) {
                return 0;
            }
            int ret = this.source.compareTo(o.source);
            if (ret == 0) {
                ret = this.typeName.compareTo(o.typeName);
            }
            return ret;
        }
    }

    private class MultiTypeEntry
    implements TypeEntry<MultiTypeEntry> {
        final DatastoreMetadata dmd;
        final String source;

        public MultiTypeEntry(WizChooseFeatureTypePanel wizChooseFeatureTypePanel, DatastoreMetadata dmd) {
            this.dmd = dmd;
            this.source = wizChooseFeatureTypePanel.editorFormat.getFileSystemStoreSource(dmd);
            if (this.source == null) {
                Assert.shouldNeverReachHere((String)"Cannot retrieve file system source of feature store");
            }
        }

        @Override
        public DatastoreMetadata getDMD() {
            return this.dmd;
        }

        @Override
        public SimpleFeatureType getFeatureType() throws IOException {
            String[] typeNames = this.dmd.getDataStore().getTypeNames();
            if (typeNames != null && typeNames.length > 0) {
                return this.dmd.getDataStore().getSchema(typeNames[0]);
            }
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 53 * hash + Objects.hashCode(this.source);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MultiTypeEntry other = (MultiTypeEntry)obj;
            return Objects.equals(this.source, other.source);
        }

        public String toString() {
            return this.source;
        }

        @Override
        public int compareTo(MultiTypeEntry t) {
            return this.source.compareToIgnoreCase(t.source);
        }
    }
}

