/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.EditorFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.importer.ImportFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.importer.ShapefileImportFormat;
import com.vividsolutions.jump.workbench.ui.plugin.shapefile.ShapefileUtils;
import de.riwagis.geotools.data.shapefile.ShpFileType;
import de.riwagis.riwajump.data.DataStores;
import de.riwagis.riwajump.data.gui.AttributeTypes;
import de.riwagis.riwajump.data.gui.FeatureTypePanel;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public class ShapefileEditorFormat
implements EditorFormat {
    private final ImportFormat importFormat = new ShapefileImportFormat();

    public ImportFormat getImport() {
        return this.importFormat;
    }

    @Override
    public String isValid(SimpleFeatureType typeToValidate) {
        boolean geomFound = false;
        for (int i = 0; i < typeToValidate.getAttributeCount(); ++i) {
            if (!(typeToValidate.getDescriptor(i) instanceof GeometryDescriptor)) continue;
            geomFound = true;
            Class binding = typeToValidate.getGeometryDescriptor().getType().getBinding();
            if (binding != Geometry.class && binding != GeometryCollection.class) continue;
            return I18N.get("ui.plugin.shapefile.WizFeatureTypePanel.wrong-geometry");
        }
        if (!geomFound) {
            return I18N.get("ui.plugin.shapefile.WizFeatureTypePanel.wrong-geometry");
        }
        return null;
    }

    @Override
    public void setupTypePanel(FeatureTypePanel fTypePanel) {
        fTypePanel.setSchemaNameEditable(false);
        fTypePanel.addTypeRestriction(AttributeTypes.GEOMETRY);
        fTypePanel.addTypeRestriction(AttributeTypes.GEOMETRY_COLLECTION);
        fTypePanel.addTypeRestriction(AttributeTypes.NO_GEOMETRY);
        fTypePanel.addTypeRestriction(AttributeTypes.TIMESTAMP);
        fTypePanel.addTypeRestriction(AttributeTypes.BYTE);
        fTypePanel.addTypeRestriction(AttributeTypes.SHORT);
        fTypePanel.addTypeRestriction(AttributeTypes.BLOB);
    }

    @Override
    public String getGeometryName() {
        return "the_geom";
    }

    @Override
    public String getFileEnding() {
        return ".shp";
    }

    @Override
    public String getStoreTypeName() {
        return "Shape Directory";
    }

    @Override
    public String getLocalizedFormatName() {
        return I18N.get("shape-file");
    }

    @Override
    public String getLocalizedFileExistsError() {
        return I18N.get("ui.plugin.shapefile.CreateShapefilePlugIn.error-file-exists");
    }

    @Override
    public String getFileSystemStoreSource(DatastoreMetadata dmd) {
        return ShapefileUtils.getPath4ShapeFileDataStore(dmd);
    }

    @Override
    public String getFileSystemSchemaSource(DatastoreMetadata dmd, String typeName) {
        return this.getFileSystemStoreSource(dmd) + File.separator + typeName + this.getFileEnding();
    }

    public SimpleFeatureType transformType(Task task, DatastoreMetadata dmd, SimpleFeatureType sourceSchema, SimpleFeatureType targetSchema, Map updatedAttributes, String sourceFile) throws IOException {
        String tempTypeName = targetSchema.getTypeName() + "__tmp";
        String directory = new File(sourceFile).getAbsolutePath() + File.separator;
        String sourceFileBase = directory + sourceSchema.getTypeName();
        String tempFileBase = directory + tempTypeName;
        this.deleteShapefile(tempFileBase);
        targetSchema = this.renameFeatureType(targetSchema, tempTypeName);
        targetSchema = DataStores.dumpFeatureType(dmd, sourceSchema, dmd, targetSchema, updatedAttributes);
        dmd.dispose();
        this.renameShapefile(tempFileBase, sourceFileBase);
        return this.renameFeatureType(targetSchema, sourceSchema.getTypeName());
    }

    @Override
    public void backupFeatureType(Task task, DatastoreMetadata dmd, SimpleFeatureType schema, File backupFile) throws IOException {
        boolean storeMissing;
        String encoding = ShapefileUtils.getEncoding4ShapeFileDataStore(dmd);
        DMDCollection dmdCol = task.getLocalDataStores();
        DatastoreMetadata backupDMD = ShapefileUtils.dmd4Path(dmdCol, backupFile.getParentFile(), encoding);
        boolean bl = storeMissing = backupDMD == null;
        if (storeMissing) {
            backupDMD = ShapefileUtils.createShapeFileDirectoryDataStore(task, dmdCol, backupFile.getParentFile(), encoding);
        }
        String backupTypeName = FilenameUtils.removeExtension((String)backupFile.getName());
        SimpleFeatureType backupSchema = this.renameFeatureType(schema, backupTypeName);
        DataStores.dumpFeatureType(dmd, schema, backupDMD, backupSchema, Collections.emptyMap());
        if (storeMissing) {
            backupDMD.dispose();
            dmdCol.removeDatastore(backupDMD);
        }
    }

    @Override
    public boolean editAllDataTypesAtOnce() {
        return false;
    }

    private SimpleFeatureType renameFeatureType(SimpleFeatureType targetSchema, String typeName) {
        SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
        sftb.init(targetSchema);
        sftb.setName(typeName);
        return sftb.buildFeatureType();
    }

    private void deleteShapefile(String strFileNameWithoutSuffix) {
        for (ShpFileType type : ShpFileType.values()) {
            File tmpFile = new File(strFileNameWithoutSuffix + type.extensionWithPeriod);
            if (!tmpFile.exists()) continue;
            tmpFile.delete();
        }
    }

    private void renameShapefile(String strFromFileNameWithoutSuffix, String strToFileNameWithoutSuffix) {
        this.deleteShapefile(strToFileNameWithoutSuffix);
        for (ShpFileType type : ShpFileType.values()) {
            File tmpFile = new File(strFromFileNameWithoutSuffix + type.extensionWithPeriod);
            if (!tmpFile.exists()) continue;
            tmpFile.renameTo(new File(strToFileNameWithoutSuffix + type.extensionWithPeriod));
        }
    }

    @Override
    public void deleteSchema(DatastoreMetadata dmd, String selectedType) throws IOException {
        this.deleteShapefile(this.getFileSystemStoreSource(dmd) + File.separator + selectedType);
    }

    @Override
    public void addLayerForType(PlugInContext context, DatastoreMetadata dmd, String typeName) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

