/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.EditorFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.importer.GeoPackageImportFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.importer.ImportFormat;
import de.riwagis.geotools.data.geopkg.GeoPackageDataStoreFactory;
import de.riwagis.riwajump.data.DataStores;
import de.riwagis.riwajump.data.gui.AttributeTypes;
import de.riwagis.riwajump.data.gui.FeatureTypePanel;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataStore;
import org.geotools.data.Transaction;
import org.geotools.geopkg.DeletableGeoPackage;
import org.geotools.geopkg.Entry;
import org.geotools.geopkg.FeatureEntry;
import org.geotools.geopkg.GeoPackage;
import org.geotools.jdbc.JDBCDataStore;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoPackageEditorFormat
implements EditorFormat {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeoPackageEditorFormat.class);
    private final GeoPackageImportFormat importFormat = new GeoPackageImportFormat();

    public ImportFormat getImport() {
        return this.importFormat;
    }

    @Override
    public String isValid(SimpleFeatureType typeToValidate) {
        return null;
    }

    @Override
    public void setupTypePanel(FeatureTypePanel fTypePanel) {
        fTypePanel.addTypeRestriction(AttributeTypes.BLOB);
    }

    @Override
    public String getGeometryName() {
        return "geom";
    }

    @Override
    public String getFileEnding() {
        return ".gpkg";
    }

    @Override
    public String getStoreTypeName() {
        return "GeoPackage";
    }

    @Override
    public String getLocalizedFormatName() {
        return I18N.get("geopackage-file");
    }

    @Override
    public String getLocalizedFileExistsError() {
        return I18N.get("geopackage-error-file-exists-use-edit-for-additional-type");
    }

    @Override
    public boolean isTypeAliasable() {
        return true;
    }

    @Override
    public void setAliasToType(SimpleFeatureType schema, String alias) {
        if (StringUtils.isBlank((CharSequence)alias)) {
            alias = schema.getTypeName();
        }
        FeatureEntry e = (FeatureEntry)schema.getUserData().computeIfAbsent(FeatureEntry.class, key -> new FeatureEntry());
        e.setIdentifier(alias);
        e.setDescription("");
        e.setTableName(schema.getTypeName());
        e.setLastChange(new Date());
        schema.getUserData().put(FeatureEntry.class, e);
    }

    @Override
    public String getAliasFromType(SimpleFeatureType schema) {
        FeatureEntry e = (FeatureEntry)schema.getUserData().get(FeatureEntry.class);
        if (e == null) {
            return null;
        }
        return e.getIdentifier();
    }

    @Override
    public String getFileSystemStoreSource(DatastoreMetadata dmd) {
        String rawFile = Objects.toString(dmd.getParameters().get(GeoPackageDataStoreFactory.FILE.key));
        return Path.of(rawFile, new String[0]).normalize().toAbsolutePath().toString();
    }

    @Override
    public String getFileSystemSchemaSource(DatastoreMetadata dmd, String typeName) {
        return this.getFileSystemStoreSource(dmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFeatureType transformType(Task task, DatastoreMetadata dmd, SimpleFeatureType sourceSchema, SimpleFeatureType targetSchema, Map updatedAttributes, String sourceFile) throws IOException {
        Path tmpStoreFile = Path.of(FilenameUtils.removeExtension((String)sourceFile) + "__tmp" + this.getFileEnding(), new String[0]);
        Files.deleteIfExists(tmpStoreFile);
        DatastoreMetadata tmpStore = this.getImport().getOrCreateDataStoreForFile(task, tmpStoreFile.toFile());
        try {
            Map userData = targetSchema.getUserData();
            targetSchema = DataStores.dumpFeatureType(dmd, sourceSchema, tmpStore, targetSchema, updatedAttributes);
            targetSchema.getUserData().putAll(userData);
            dmd.dispose();
            this.deleteSchema(dmd, sourceSchema.getTypeName());
            targetSchema = DataStores.dumpFeatureType(tmpStore, targetSchema, dmd, targetSchema, Collections.emptyMap());
            targetSchema.getUserData().putAll(userData);
            SimpleFeatureType simpleFeatureType = targetSchema;
            return simpleFeatureType;
        }
        finally {
            tmpStore.dispose();
            dmd.dispose();
            task.getLocalDataStores().removeDatastore(tmpStore);
            Files.deleteIfExists(tmpStoreFile);
        }
    }

    @Override
    public SimpleFeatureType getSchemaFromStore(DataStore dataStore, String typeName) throws IOException {
        SimpleFeatureType schema = dataStore.getSchema(typeName);
        GeoPackage geoPackage = new GeoPackage((JDBCDataStore)dataStore);
        FeatureEntry feature = geoPackage.feature(typeName);
        if (feature != null) {
            schema.getUserData().put(FeatureEntry.class, feature);
        }
        return schema;
    }

    @Override
    public void backupFeatureType(Task task, DatastoreMetadata dmd, SimpleFeatureType schema, File backupFile) throws IOException {
        dmd.reset();
        Files.copy(Path.of(this.getFileSystemStoreSource(dmd), new String[0]), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public boolean editAllDataTypesAtOnce() {
        return true;
    }

    @Override
    public void deleteSchema(DatastoreMetadata dmd, String selectedType) throws IOException {
        DeletableGeoPackage geoPackage = new DeletableGeoPackage((JDBCDataStore)dmd.getDataStore());
        FeatureEntry entry = geoPackage.feature(selectedType);
        geoPackage.deleteEntry((Entry)entry);
        this.vacuumStore(dmd);
    }

    @Override
    public void addLayerForType(PlugInContext context, DatastoreMetadata dmd, String typeName) throws Exception {
        this.importFormat.addLayerForType(context, dmd, typeName);
    }

    @Override
    public SimpleFeatureType createSchema(DatastoreMetadata dmd, SimpleFeatureType schema) throws IOException {
        dmd.getDataStore().createSchema((FeatureType)schema);
        dmd.dispose();
        return this.getSchemaFromStore(dmd.getDataStore(), schema.getTypeName());
    }

    private void vacuumStore(DatastoreMetadata dmd) throws IOException {
        JDBCDataStore dataStore = (JDBCDataStore)dmd.getDataStore();
        try (Connection cx = dataStore.getConnection(Transaction.AUTO_COMMIT);
             Statement st = cx.createStatement();){
            int n = st.executeUpdate("VACUUM;");
        }
        catch (SQLException ex) {
            log.error("Could not vacuum GPKG.", (Throwable)ex);
        }
    }
}

