/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.RemoveSelectedLayersPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.importer.ImportFormat;
import de.riwagis.riwajump.data.gui.FeatureTypePanel;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.workbench.ui.plugin.ImportStyleDefaults;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataStore;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

public interface EditorFormat<I extends ImportFormat> {
    public static final String TMP_FILE_EXTENSION = "__tmp";

    public I getImport();

    public String isValid(SimpleFeatureType var1);

    public void setupTypePanel(FeatureTypePanel var1);

    public String getGeometryName();

    public String getFileEnding();

    public String getStoreTypeName();

    public String getLocalizedFormatName();

    public String getLocalizedFileExistsError();

    default public DatastoreMetadata getOrCreateDataStore(Task task, File file) {
        return this.getImport().getOrCreateDataStoreForFile(task, file);
    }

    default public DatastoreMetadata createDataStore(Task task, File file) {
        return this.getImport().createDataStoreForFile(task, file);
    }

    default public FileFilter getFileFilter() {
        return this.getImport().getFileFilter();
    }

    default public JComponent getAccessory() {
        return this.getImport().getAccessory();
    }

    public String getFileSystemStoreSource(DatastoreMetadata var1);

    default public void doImport(PlugInContext context, List filesToImport) throws Exception {
        this.getImport().doImport(context, filesToImport);
    }

    default public boolean isTypeAliasable() {
        return false;
    }

    default public void setAliasToType(SimpleFeatureType schema, String alias) {
    }

    default public String getAliasFromType(SimpleFeatureType schema) {
        return "";
    }

    public SimpleFeatureType transformType(Task var1, DatastoreMetadata var2, SimpleFeatureType var3, SimpleFeatureType var4, Map<String, String> var5, String var6) throws IOException;

    default public void updateLayerSettingsFromSchema(Task task, SimpleFeatureType schema, String sourceFile) throws IOException {
        this.executeForEachLayerUsingSchema(task, schema.getTypeName(), sourceFile, layer -> {
            layer.getFMD().resetDataStore(layer.getDMDCol());
            String[] arrAtts = new String[schema.getAttributeCount()];
            for (int j = 0; j < arrAtts.length; ++j) {
                arrAtts[j] = schema.getDescriptor(j).getLocalName();
            }
            layer.getFMD().setAttributes(arrAtts);
            ImportStyleDefaults.setLayerStyleDefaults(layer, schema, null);
            layer.reload();
            layer.fireAppearanceChanged();
        });
    }

    default public void deleteLayersReferencingSchema(Task task, String typeName, String sourceFile) throws IOException {
        this.executeForEachLayerUsingSchema(task, typeName, sourceFile, layer -> RemoveSelectedLayersPlugIn.remove(Collections.singletonList(layer)));
    }

    private void executeForEachLayerUsingSchema(Task task, String typeName, String sourceFile, Consumer<Layer> action) throws IOException {
        DMDCollection dmdCol = task.getLocalDataStores();
        for (Layerable layerable : task.getLayerManager().getRootCatLocal().getAllLayerables()) {
            Layer layer;
            FeaturestoreMetadata fmd;
            DatastoreMetadata dmdLayer;
            if (!(layerable instanceof Layer) || (dmdLayer = dmdCol.getByName((fmd = (layer = (Layer)layerable).getFMD()).getDatastoreName())) == null || StringUtils.isEmpty((CharSequence)dmdLayer.getDataName()) || !dmdLayer.getDataName().equals(this.getStoreTypeName()) || !fmd.getDatatypeName().equals(typeName) || !this.getFileSystemStoreSource(dmdLayer).equals(sourceFile)) continue;
            action.accept(layer);
        }
    }

    default public SimpleFeatureType getSchemaFromStore(DataStore dataStore, String typeName) throws IOException {
        return dataStore.getSchema(typeName);
    }

    public String getFileSystemSchemaSource(DatastoreMetadata var1, String var2);

    public void backupFeatureType(Task var1, DatastoreMetadata var2, SimpleFeatureType var3, File var4) throws IOException;

    public boolean editAllDataTypesAtOnce();

    public void deleteSchema(DatastoreMetadata var1, String var2) throws IOException;

    public void addLayerForType(PlugInContext var1, DatastoreMetadata var2, String var3) throws Exception;

    default public SimpleFeatureType createSchema(DatastoreMetadata dmd, SimpleFeatureType schema) throws IOException {
        dmd.getDataStore().createSchema((FeatureType)schema);
        dmd.dispose();
        return schema;
    }

    default public SimpleFeatureType insertOrUpdateSchema(PlugInContext context, DatastoreMetadata dmd, SimpleFeatureType targetSchema, Map<String, String> updatedAttributes) throws Exception {
        SimpleFeatureType updatedSchema;
        String typeName = targetSchema.getTypeName();
        if (this.storeContainsType(dmd, typeName)) {
            SimpleFeatureType sourceSchema = this.getSchemaFromStore(dmd.getDataStore(), typeName);
            String sourceFile = this.getFileSystemStoreSource(dmd);
            updatedSchema = this.transformType(context.getTask(), dmd, sourceSchema, targetSchema, updatedAttributes, sourceFile);
            this.updateLayerSettingsFromSchema(context.getTask(), updatedSchema, sourceFile);
        } else {
            updatedSchema = this.createSchema(dmd, targetSchema);
            if (updatedSchema.getGeometryDescriptor() != null) {
                this.addLayerForType(context, dmd, typeName);
            }
        }
        return updatedSchema;
    }

    default public boolean storeContainsType(DatastoreMetadata dmd, String typeName) {
        try {
            if (dmd == null) {
                return false;
            }
            return Arrays.stream(dmd.getDataStore().getTypeNames()).anyMatch(x -> x.equals(typeName));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

