/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractExportPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.EditorFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.WizChooseFeatureTypePanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.WizCopyFilePanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.WizFeatureTypePanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.WizardExchangeData;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.util.gui.GUISupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.util.Iterator;
import java.util.Map;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class UpdateDataStorePlugIn
extends ThreadedBasePlugIn {
    private WizardDialog wiz = null;
    private final EditorFormat editorFormat;

    protected UpdateDataStorePlugIn(EditorFormat editorFormat) {
        this.editorFormat = editorFormat;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.wiz = new WizardDialog((Frame)context.getWorkbenchFrame(), this.getName(), context.getWorkbenchFrame());
        WizCopyFilePanel wizMessage = new WizCopyFilePanel(context, this.editorFormat);
        wizMessage.getInternalMessageLabel().setForeground(Color.red);
        WizChooseFeatureTypePanel wizChooseType = new WizChooseFeatureTypePanel(context, this.editorFormat);
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.setName("EMPTY");
        WizFeatureTypePanel wizFeatureType = new WizFeatureTypePanel(context, ftBuilder.buildFeatureType(), 1, this.editorFormat);
        this.wiz.init(new WizardPanel[]{wizChooseType, wizMessage, wizFeatureType});
        this.wiz.setSize(600, 500);
        this.wiz.setLocationRelativeTo(context.getWorkbenchFrame());
        this.wiz.setVisible(true);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) {
        monitor.report(I18N.get("ui.plugin.shapefile.UpdateShapefilePlugIn.in-progress"));
        if (this.wiz.wasFinishPressed()) {
            boolean saveChanges;
            boolean hasUnsavedChanges = (Boolean)this.wiz.getData(WizardExchangeData.HAS_UNSAVED_CHANGES.name());
            if (!hasUnsavedChanges) {
                return;
            }
            if (this.editorFormat.editAllDataTypesAtOnce() && !(saveChanges = GUISupport.yesnobox((Component)context.getWorkbenchFrame(), (String)I18N.get("question-datatype-contains-changes-save"), (String)I18N.get("change-datatype")))) {
                return;
            }
            try {
                DatastoreMetadata dmd = (DatastoreMetadata)this.wiz.getData(WizardExchangeData.DATASTORE.name());
                SimpleFeatureType targetSchema = (SimpleFeatureType)this.wiz.getData(WizardExchangeData.TARGET_FEATURETYPE.name());
                Map updatedAttributes = (Map)this.wiz.getData(WizardExchangeData.UPDATED_ATTRIBUTES.name());
                this.editorFormat.insertOrUpdateSchema(context, dmd, targetSchema, updatedAttributes);
                GUISupport.msgbox((Component)context.getWorkbenchFrame(), (String)I18N.getMessage("ui.plugin.shapefile.UpdateShapefilePlugIn.success-update-layers", this.editorFormat.getLocalizedFormatName()), (String)I18N.get("common.message"));
            }
            catch (Exception e) {
                monitor.report(e);
            }
        }
        this.wiz = null;
    }

    @Override
    public EnableCheck createEnableCheck() {
        return new MultiEnableCheck().add(AbstractExportPlugIn.createExportAllowedCheck()).add(component -> {
            WorkbenchContext workbenchContext = WorkbenchContext.getInstance();
            if (workbenchContext.createPlugInContext().getTask() != null) {
                Iterator<DatastoreMetadata> i = workbenchContext.createPlugInContext().getTask().getLocalDataStores().iterator();
                boolean found = false;
                while (i.hasNext()) {
                    DatastoreMetadata dmd = i.next();
                    if (!dmd.getDataName().equals(this.editorFormat.getStoreTypeName())) continue;
                    found = true;
                    break;
                }
                if (found) {
                    return null;
                }
            }
            return I18N.get("ui.plugin.shapefile.UpdateShapefilePlugIn.no-suitable-datastore");
        }).add(component -> {
            SaveLayerFeatureChangesPlugIn saveFeaturesPlugin = JUMPWorkbench.getBuiltInPlugIn(SaveLayerFeatureChangesPlugIn.class);
            boolean hasUncommitedFeatures = saveFeaturesPlugin.hasUncommitedFeatures(WorkbenchContext.getInstance().getLayerManager());
            if (hasUncommitedFeatures) {
                return I18N.get("function-only-available-without-feature-changes");
            }
            return null;
        });
    }
}

