/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractExportPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.ExportStyle;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.ExportStyleFactory;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerToFilePlugIn;
import de.micromata.opengis.kml.v_2_2_0.AltitudeMode;
import de.micromata.opengis.kml.v_2_2_0.Boundary;
import de.micromata.opengis.kml.v_2_2_0.ColorMode;
import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.Geometry;
import de.micromata.opengis.kml.v_2_2_0.Icon;
import de.micromata.opengis.kml.v_2_2_0.IconStyle;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import de.micromata.opengis.kml.v_2_2_0.KmlFactory;
import de.micromata.opengis.kml.v_2_2_0.LineString;
import de.micromata.opengis.kml.v_2_2_0.MultiGeometry;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.Style;
import de.micromata.opengis.kml.v_2_2_0.StyleSelector;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.crs.Transformer;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.OSFile;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SaveLayerToKmlPlugIn
extends AbstractExportPlugIn {
    private static final String KEY_KML_FILE = SaveLayerToKmlPlugIn.class.getName() + "_KMLFILE";
    private PlugInContext context = null;

    @Override
    public String getName() {
        return I18N.get("ui.plugin.io.layer.SaveLayerToKmlPlugIn.name");
    }

    @Override
    public boolean execute(PlugInContext _context) throws Exception {
        this.context = _context;
        final WaitDialog dlgWait = new WaitDialog((Window)this.getContext().getWorkbenchFrame(), I18N.get("ui.plugin.io.layer.SaveLayerToKmlPlugIn.please-wait"));
        Runnable work2do = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean bolShowFile;
                    int state;
                    CRSDefinition tcrs = SaveLayerToKmlPlugIn.this.getContext().getTask().getCRSDefinition();
                    if (tcrs.getCRS() == null) {
                        throw new Exception(I18N.get("ui.plugin.io.layer.SaveLayerToKmlPlugIn.illegalCoordinateReferenceSystem"));
                    }
                    CoordinateReferenceSystem wgs84CRS = CRSDefFactory.createCRS((String)"4326");
                    CoordinateReferenceSystem taskCRS = tcrs.getCRS();
                    Transformer trans = new Transformer(taskCRS, wgs84CRS);
                    JFileChooser fileChooser = GUIUtil.createJFileChooserWithOverwritePrompting();
                    FileFilter shpFilterKml = GUIUtil.createFileFilter(I18N.get("ui.plugin.io.layer.SaveLayerToKmlPlugIn.FileFilterName"), new String[]{"kml"});
                    FileFilter shpFilterKmz = GUIUtil.createFileFilter(I18N.get("ui.plugin.io.layer.SaveLayerToKmlPlugIn.FileFilterName"), new String[]{"kmz"});
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    fileChooser.addChoosableFileFilter(shpFilterKml);
                    fileChooser.addChoosableFileFilter(shpFilterKmz);
                    String strFile = PersistentBlackboardPlugIn.get().get(KEY_KML_FILE, "");
                    if (strFile.length() > 0) {
                        fileChooser.setSelectedFile(new File(strFile));
                    }
                    if ((state = fileChooser.showSaveDialog(SaveLayerToKmlPlugIn.this.getContext().getWorkbenchFrame())) == 1 || state == -1) {
                        return;
                    }
                    strFile = fileChooser.getSelectedFile().toString();
                    boolean bolExportKmz = false;
                    if (fileChooser.getFileFilter().equals(shpFilterKml)) {
                        if (!strFile.toLowerCase().endsWith(".kml")) {
                            strFile = SaveLayerToKmlPlugIn.this.addSuffix(strFile, ".kml");
                        }
                    } else {
                        bolExportKmz = true;
                        if (!strFile.toLowerCase().endsWith(".kmz")) {
                            strFile = SaveLayerToKmlPlugIn.this.addSuffix(strFile, ".kmz");
                        }
                    }
                    PersistentBlackboardPlugIn.get().put(KEY_KML_FILE, strFile);
                    boolean bolMessage = false;
                    Kml kml = KmlFactory.createKml();
                    Document doc = kml.createAndSetDocument().withName("GIS export");
                    for (Layer ly : SaveLayerToKmlPlugIn.this.getSelectedLayers()) {
                        FeatureIterator<SimpleFeature> fi = SaveLayerToKmlPlugIn.this.getFeatureIterator(ly);
                        Folder fold = doc.createAndAddFolder();
                        fold.setName(ly.getName());
                        fold.setDescription(ly.getDescription());
                        try {
                            while (fi.hasNext()) {
                                Style style;
                                List lstSSel;
                                SimpleFeature fFrom = (SimpleFeature)fi.next();
                                ExportStyle expStyle = ExportStyleFactory.createExportStyle(ly, fFrom, ly.getLayerManager().getScreenScale());
                                if (expStyle == null || !expStyle.isEnabled()) continue;
                                org.locationtech.jts.geom.Geometry geom = (org.locationtech.jts.geom.Geometry)fFrom.getDefaultGeometry();
                                if (geom == null || geom.isEmpty()) {
                                    bolMessage = true;
                                    continue;
                                }
                                boolean bolNameUsed = false;
                                Placemark pm = fold.createAndAddPlacemark();
                                if (expStyle.isRenderingLineBase() || expStyle.isRenderingArea()) {
                                    SaveLayerToKmlPlugIn.setPolyStyleAndLineStyle(pm, SaveLayerToKmlPlugIn.toKmlColor(expStyle.getAreaColor()), ColorMode.NORMAL, expStyle.isRenderingArea(), 2.0, SaveLayerToKmlPlugIn.toKmlColor(expStyle.getLineBaseColor()), ColorMode.NORMAL, expStyle.isRenderingLineBase());
                                }
                                if ((lstSSel = pm.getStyleSelector()).isEmpty()) {
                                    style = new Style();
                                    lstSSel.add(style);
                                } else {
                                    style = (Style)lstSSel.get(0);
                                }
                                if (geom instanceof Point || geom instanceof MultiPoint || geom instanceof GeometryCollection) {
                                    if (expStyle.isRenderingText()) {
                                        style.createAndSetLabelStyle().withColor(SaveLayerToKmlPlugIn.toKmlColor(expStyle.getTextColor())).withColorMode(ColorMode.NORMAL).withScale(1.1);
                                        pm.setName(expStyle.getText());
                                        bolNameUsed = true;
                                    }
                                    if (expStyle.isRenderingSymbol()) {
                                        IconStyle iStyle = style.createAndSetIconStyle().withScale(1.0).withIcon(new Icon().withHref("http://maps.google.com/mapfiles/kml/paddle/wht-circle.png"));
                                        if (expStyle.isSymOverwriteFillColor()) {
                                            iStyle.withColor(SaveLayerToKmlPlugIn.toKmlColor(expStyle.getSymFillColor())).withColorMode(ColorMode.NORMAL);
                                        } else {
                                            iStyle.setColorMode(ColorMode.RANDOM);
                                        }
                                        if (!expStyle.isRenderingText()) {
                                            style.createAndSetLabelStyle().withScale(0.0);
                                        }
                                    } else {
                                        style.createAndSetIconStyle().withScale(0.4).withColor(SaveLayerToKmlPlugIn.toKmlColor(expStyle.getTextColor())).withColorMode(ColorMode.NORMAL).withIcon(new Icon().withHref("http://maps.google.com/mapfiles/kml/paddle/wht-circle.png"));
                                    }
                                }
                                pm.setId(fFrom.getID());
                                if (!bolNameUsed) {
                                    pm.setName(fFrom.getID());
                                }
                                pm.setDescription(expStyle.getToolTip());
                                pm.setGeometry(SaveLayerToKmlPlugIn.this.getKmlGeometry(fFrom, geom, trans));
                            }
                        }
                        finally {
                            fi.close();
                        }
                    }
                    if (bolExportKmz) {
                        kml.marshalAsKmz(strFile, new Kml[]{new Kml()});
                    } else {
                        FileOutputStream fout = new FileOutputStream(new File(strFile));
                        kml.marshal((OutputStream)fout);
                        try {
                            fout.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (bolMessage) {
                        String strMessage = I18N.get("ui.plugin.io.layer.SaveLayerToKmlPlugIn.not-all-exported");
                        GUISupport.msgbox((Component)SaveLayerToKmlPlugIn.this.getContext().getWorkbenchFrame(), (String)strMessage, (String)I18N.get("common.alert"));
                    }
                    if (bolShowFile = GUISupport.yesnobox((Component)SaveLayerToKmlPlugIn.this.getContext().getWorkbenchFrame(), (String)I18N.get("ui.plugin.io.layer.SaveLayerToKmlPlugIn.open-file"), (String)I18N.get("common.message"))) {
                        OSFile.showFile((File)new File(strFile), (boolean)false);
                    }
                }
                catch (Exception e) {
                    dlgWait.setError(e);
                }
            }
        };
        dlgWait.addWorkToDo(work2do);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            throw dlgWait.getError();
        }
        return true;
    }

    public List<Layer> getSelectedLayers() {
        Layer ly = this.getContext().getSelectedLayer(0);
        ArrayList<Layer> lstLy = new ArrayList<Layer>();
        if (ly != null) {
            lstLy.add(ly);
        }
        return lstLy;
    }

    public FeatureIterator<SimpleFeature> getFeatureIterator(Layer ly) throws Exception {
        return ly.getFeatureIterator((Envelope)null);
    }

    private Geometry getKmlGeometry(SimpleFeature feature, org.locationtech.jts.geom.Geometry geom, Transformer trans) throws Exception {
        if (geom instanceof Point) {
            de.micromata.opengis.kml.v_2_2_0.Point kpoint = KmlFactory.createPoint();
            kpoint.setExtrude(Boolean.valueOf(false));
            kpoint.setAltitudeMode(AltitudeMode.CLAMP_TO_GROUND);
            kpoint.getCoordinates().add(this.transform(feature, geom.getCoordinate(), trans));
            return kpoint;
        }
        if (geom instanceof org.locationtech.jts.geom.LineString) {
            Coordinate[] arrCoord;
            LineString kline = KmlFactory.createLineString();
            kline.setExtrude(Boolean.valueOf(false));
            kline.setAltitudeMode(AltitudeMode.CLAMP_TO_GROUND);
            for (Coordinate coord : arrCoord = geom.getCoordinates()) {
                kline.getCoordinates().add(this.transform(feature, coord, trans));
            }
            return kline;
        }
        if (geom instanceof Polygon) {
            de.micromata.opengis.kml.v_2_2_0.Polygon kpoly = KmlFactory.createPolygon();
            kpoly.setExtrude(Boolean.valueOf(false));
            kpoly.setAltitudeMode(AltitudeMode.CLAMP_TO_GROUND);
            Polygon jtsPoly = (Polygon)geom;
            Coordinate[] arrCoord = jtsPoly.getExteriorRing().getCoordinates();
            Boundary obound = kpoly.createAndSetOuterBoundaryIs();
            obound.createAndSetLinearRing();
            for (Coordinate coord : arrCoord) {
                obound.getLinearRing().getCoordinates().add(this.transform(feature, coord, trans));
            }
            int numRings = jtsPoly.getNumInteriorRing();
            for (int i = 0; i < numRings; ++i) {
                arrCoord = jtsPoly.getInteriorRingN(i).getCoordinates();
                Boundary innerBound = kpoly.createAndAddInnerBoundaryIs();
                innerBound.createAndSetLinearRing();
                for (Coordinate coord : arrCoord) {
                    innerBound.getLinearRing().getCoordinates().add(this.transform(feature, coord, trans));
                }
            }
            return kpoly;
        }
        if (geom instanceof GeometryCollection) {
            MultiGeometry kMGeom = KmlFactory.createMultiGeometry();
            GeometryCollection gCol = (GeometryCollection)geom;
            int numGeom = gCol.getNumGeometries();
            for (int i = 0; i < numGeom; ++i) {
                Geometry kgeom = this.getKmlGeometry(feature, gCol.getGeometryN(i), trans);
                kMGeom.addToGeometry(kgeom);
            }
            return kMGeom;
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    private double getZ(Coordinate coord, SimpleFeature f) {
        if (FeatureUtil.hasAttribute((SimpleFeature)f, (String)"z")) {
            Object objZ = FeatureUtil.getAttribute((SimpleFeature)f, (String)"z");
            if (objZ != null && objZ instanceof Number) {
                return ((Number)objZ).doubleValue();
            }
            return 0.0;
        }
        if (Double.isNaN(coord.z) || coord.z == 0.0) {
            return 0.0;
        }
        return coord.z;
    }

    private de.micromata.opengis.kml.v_2_2_0.Coordinate transform(SimpleFeature feature, Coordinate coord, Transformer trans) throws Exception {
        Coordinate newCoord = new Coordinate(coord.x, coord.y, this.getZ(coord, feature));
        trans.transform2d(newCoord);
        return new de.micromata.opengis.kml.v_2_2_0.Coordinate(newCoord.x, newCoord.y, newCoord.z);
    }

    private String addSuffix(String str, String strSuffix) {
        if (str.toLowerCase().endsWith(strSuffix.toLowerCase())) {
            return str;
        }
        return str + strSuffix;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(SaveLayerToKmlPlugIn.createExportAllowedCheck()).add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, Layer.class)).add(SaveLayerToFilePlugIn.ENABLECHECK_EXPORTABLE);
    }

    public static void setPolyStyleAndLineStyle(Placemark placemark, String color, ColorMode polyMode, boolean bolRenderPoly, double width, String lineColor, ColorMode lineMode, boolean bolRenderLine) {
        List styleSelector;
        if (color == null || color.length() != 8) {
            color = "FFFFFFFF";
            polyMode = ColorMode.NORMAL;
        }
        if (width <= 0.0) {
            width = 0.0;
        }
        if (lineColor == null || lineColor.length() != 8) {
            lineColor = "FF000000";
            lineMode = ColorMode.NORMAL;
        }
        if ((styleSelector = placemark.getStyleSelector()).isEmpty()) {
            Style style = new Style();
            style.createAndSetPolyStyle();
            styleSelector.add(style);
        }
        for (StyleSelector tmp : styleSelector) {
            if (!(tmp instanceof Style)) continue;
            Style style = (Style)tmp;
            style.getPolyStyle().withColor(color).withColorMode(polyMode).setFill(Boolean.valueOf(bolRenderPoly));
            if (bolRenderLine) {
                style.createAndSetLineStyle().withWidth(width).withColor(lineColor).withColorMode(lineMode);
                continue;
            }
            style.createAndSetLineStyle().withWidth(0.0);
        }
    }

    public static String toKmlColor(Color color) {
        int alpha = color.getAlpha();
        int blue = color.getBlue();
        int green = color.getGreen();
        int red = color.getRed();
        if (alpha == 0) {
            alpha = 1;
        }
        return StringUtils.leftPad((String)Integer.toHexString(alpha), (int)2, (char)'0') + StringUtils.leftPad((String)Integer.toHexString(blue), (int)2, (char)'0') + StringUtils.leftPad((String)Integer.toHexString(green), (int)2, (char)'0') + StringUtils.leftPad((String)Integer.toHexString(red), (int)2, (char)'0');
    }

    protected PlugInContext getContext() {
        return this.context;
    }
}

