/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractExportPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.ExportFileChooser;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.ExportFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.GeoPackageExportFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.exporter.ShapefileExportFormat;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.crs.Transformer;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.guitools.Tasks;
import de.riwagis.util.ThrowingFunction;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.lang3.tuple.Pair;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveLayerToFilePlugIn
extends AbstractExportPlugIn {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaveLayerToFilePlugIn.class);
    public static final EnableCheck ENABLECHECK_EXPORTABLE = component -> {
        WorkbenchContext workbenchContext = WorkbenchContext.getInstance();
        if (workbenchContext != null && workbenchContext.getLayerNamePanel() != null && workbenchContext.getLayerNamePanel().getSelectedLayers().length > 0 && workbenchContext.getLayerNamePanel().getSelectedLayers()[0] != null) {
            return workbenchContext.getLayerNamePanel().getSelectedLayers()[0].isExportable() ? null : I18N.get("com.vividsolutions.jump.workbench.plugin.layer-not-exportable");
        }
        return null;
    };
    public static final String KEY_EXPORT_PATH = SaveLayerToFilePlugIn.class.getName() + "_SHAPEFILE";
    private final Map<FileFilter, ExportFormat> formats;
    private final Class<? extends ExportFormat> defaultFormat;
    private final Function<PlugInContext, Optional<Pair<ExportFormat, File>>> formatAndFileSupplier;

    public SaveLayerToFilePlugIn() {
        this.formats = Map.ofEntries(new GeoPackageExportFormat().createEntry(), new ShapefileExportFormat().createEntry());
        this.defaultFormat = ShapefileExportFormat.class;
        this.formatAndFileSupplier = this::getExportFormatAndFileFromFileChooser;
    }

    public SaveLayerToFilePlugIn(Map<FileFilter, ExportFormat> formats, Class<? extends ExportFormat> defaultFormat, Function<PlugInContext, Optional<Pair<ExportFormat, File>>> formatAndFileSupplier) {
        this.formats = formats;
        this.defaultFormat = defaultFormat;
        this.formatAndFileSupplier = formatAndFileSupplier;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(SaveLayerToFilePlugIn.createExportAllowedCheck()).add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, Layer.class)).add(ENABLECHECK_EXPORTABLE);
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.io.layer.SaveLayerToFilePlugIn.name");
    }

    @Override
    public boolean execute(PlugInContext context) {
        this.formatAndFileSupplier.apply(context).ifPresent(formatAndFile -> {
            PersistentBlackboardPlugIn.get().put(KEY_EXPORT_PATH, ((File)formatAndFile.getRight()).getParent());
            Tasks.submit(() -> this.doExport(context, (File)formatAndFile.getRight(), (ExportFormat)formatAndFile.getLeft()));
        });
        return true;
    }

    private Optional<Pair<ExportFormat, File>> getExportFormatAndFileFromFileChooser(PlugInContext context) {
        ExportFileChooser fileChooser = new ExportFileChooser(this.formats, this.defaultFormat, context);
        fileChooser.setSelectedFile(this.getDefaultExportFile(context));
        return fileChooser.showExportDialogAndReturnTargetFile().map(file -> Pair.of((Object)fileChooser.getExportFormat(), (Object)file));
    }

    private File getDefaultExportFile(PlugInContext context) {
        String parentFilePath = PersistentBlackboardPlugIn.get().get(KEY_EXPORT_PATH, "");
        String defaultFileName = this.getLayer(context).getName();
        if (StringUtils.isNotBlank((String)parentFilePath)) {
            return new File(parentFilePath, defaultFileName);
        }
        return new File(defaultFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport(PlugInContext plugInContext, File targetFile, ExportFormat targetFormat) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try (FeatureIterator<SimpleFeature> fi = this.getFeatureIterator(plugInContext);){
            boolean skippedFeatures = false;
            if (!targetFormat.setup(targetFile, plugInContext)) {
                return;
            }
            ThrowingFunction<SimpleFeature, SimpleFeature, Exception> geometryTransformer = this.findMatchingTransformer(plugInContext, targetFormat);
            if (geometryTransformer == null) {
                return;
            }
            while (fi.hasNext()) {
                SimpleFeature transformedFeature = geometryTransformer.apply((SimpleFeature)fi.next());
                if (targetFormat.writeFeature(transformedFeature)) continue;
                skippedFeatures = true;
            }
            if (skippedFeatures) {
                String strMessage = I18N.get("ui.plugin.io.layer.SaveLayerToFilePlugIn.not-all-exported");
                GUISupport.msgbox((Component)plugInContext.getWorkbenchFrame(), (String)strMessage, (String)I18N.get("common.alert"));
            }
        }
        finally {
            targetFormat.cleanup();
            stopWatch.stop();
            log.info("Exporting took {}", (Object)stopWatch.toString());
        }
    }

    private ThrowingFunction<SimpleFeature, SimpleFeature, Exception> findMatchingTransformer(PlugInContext plugInContext, ExportFormat targetFormat) throws Exception {
        CRSDefinition targetCRS;
        CRSDefinition sourceCRS;
        ArrayList transformations = new ArrayList();
        if (this.hasZAttribute(plugInContext)) {
            transformations.add(f -> this.transformTo3D((SimpleFeature)f));
        }
        if (!(sourceCRS = plugInContext.getTask().getCRSDefinition()).equals((Object)(targetCRS = targetFormat.getAccessory().getTargetCRS()))) {
            if (targetCRS.getCRS() == null || sourceCRS.getCRS() == null) {
                log.error("Cannot create transformation from {} to {}", (Object)sourceCRS.getName(), (Object)targetCRS.getName());
                String errorMessage = I18N.getMessage("ui.plugin.io.layer.SaveLayerToFilePlugIn.error-crs-transform-impossible", sourceCRS.getName(), targetCRS.getName());
                SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(plugInContext.getWorkbenchFrame(), errorMessage, I18N.get("common.alert"), 0));
                return null;
            }
            Transformer crsTransformer = new Transformer(sourceCRS.getCRS(), targetCRS.getCRS());
            transformations.add(f -> this.transformCRS((SimpleFeature)f, crsTransformer));
        }
        return transformations.stream().reduce((a, b) -> f -> (SimpleFeature)b.apply((SimpleFeature)a.apply(f))).orElse(ThrowingFunction.identity());
    }

    private boolean hasZAttribute(PlugInContext plugInContext) {
        return this.getLayer(plugInContext).getFeatureType().getAttributeDescriptors().stream().anyMatch(p -> p.getLocalName().equalsIgnoreCase("z"));
    }

    private SimpleFeature transformTo3D(SimpleFeature feature) {
        SimpleFeature featureWithZ = FeatureUtil.cloneFeature((SimpleFeature)feature);
        Geometry geometryWithZ = this.addZToGeometry(feature);
        featureWithZ.setDefaultGeometry((Object)geometryWithZ);
        return featureWithZ;
    }

    private Geometry addZToGeometry(SimpleFeature feature) {
        Object objZ = FeatureUtil.getAttribute((SimpleFeature)feature, (String)"z");
        final double finalZ = objZ instanceof Number ? ((Number)objZ).doubleValue() : 0.0;
        GeometryEditor editor = new GeometryEditor();
        return editor.edit((Geometry)feature.getDefaultGeometry(), new GeometryEditor.CoordinateOperation(this){

            @Override
            public Coordinate[] edit(Coordinate[] coordinates, boolean linearRing) {
                Coordinate[] coordsWithZ = new Coordinate[coordinates.length];
                for (int i = 0; i < coordsWithZ.length; ++i) {
                    coordsWithZ[i] = new Coordinate(coordinates[i].x, coordinates[i].y, finalZ);
                }
                return coordsWithZ;
            }
        });
    }

    private SimpleFeature transformCRS(SimpleFeature feature, Transformer transformer) throws Exception {
        SimpleFeature clonedFeature = FeatureUtil.cloneFeature((SimpleFeature)feature);
        if (feature.getDefaultGeometry() != null) {
            transformer.transform2d(clonedFeature);
        }
        return clonedFeature;
    }

    Layer getLayer(PlugInContext plugInContext) {
        return plugInContext.getSelectedLayer(0);
    }

    FeatureIterator<SimpleFeature> getFeatureIterator(PlugInContext plugInContext) throws Exception {
        return this.getLayer(plugInContext).getFeatureIterator((Envelope)null);
    }
}

