/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangedDialog;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.ImageIcon;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveLayerFeatureChangesPlugIn
extends AbstractPlugIn {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaveLayerFeatureChangesPlugIn.class);
    private SaveLayerFeatureChangedDialog dlg = null;

    @Override
    public String getName() {
        return I18N.get("ui.plugin.io.layer.SaveLayerFeatureChanges.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        this.registerSaveKey(context.getWorkbenchContext());
    }

    private void registerSaveKey(WorkbenchContext context) {
        JUMPWorkbench.getFrame().addKeyboardShortcut(83, 128, this, this.createEnableCheck());
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_save.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        context.getLayerViewPanel().getCurrentCursorTool().cancelGesture();
        if (!this.hasUncommitedFeatures(context.getLayerManager())) {
            return true;
        }
        if (this.dlg == null) {
            this.dlg = new SaveLayerFeatureChangedDialog(context.getWorkbenchFrame());
        }
        this.dlg.setLayers(this.getLayers(context.getLayerManager()));
        this.dlg.setLocationRelativeTo(context.getWorkbenchFrame());
        this.dlg.setVisible(true);
        return true;
    }

    public static void commitAllLayers() {
        LayerManager layerManager = WorkbenchContext.getInstance().getLayerManager();
        if (layerManager == null) {
            return;
        }
        WaitDialog dlgWait = new WaitDialog((Window)WorkbenchContext.getFrame(), I18N.get("ui.plugin.io.layer.SaveLayerFeatureChanges.message"));
        dlgWait.setCancelable(false);
        AtomicInteger count = new AtomicInteger(0);
        Runnable run = () -> {
            try {
                LayerViewPanel layerViewPanel = WorkbenchContext.getInstance().getLayerViewPanel();
                StringBuilder errors = new StringBuilder();
                Throwable lastError = null;
                for (Layer ly : layerManager.getLayers()) {
                    if (!ly.hasNonPersistedChanges()) continue;
                    dlgWait.setMessage(ly.getName() + " - " + I18N.get("ui.plugin.io.layer.SaveLayerFeatureChanges.message"));
                    try {
                        int numCommitedFeatures = ly.commitEditedFeatures();
                        if (numCommitedFeatures == 0) {
                            log.warn("No features committed for layer '{}'", (Object)ly.getName());
                        }
                        count.addAndGet(numCommitedFeatures);
                    }
                    catch (Throwable t) {
                        if (errors.length() > 0) {
                            errors.append("\n");
                        }
                        errors.append(I18N.getMessage("ui.plugin.io.layer.SaveLayerFeatureChanges.error-commiting-changes", ly.toString(), t.getMessage()));
                        lastError = t;
                    }
                    if (!ly.isSelectionClearingNeeded(true, true, true)) continue;
                    layerViewPanel.getSelectionManager().getFeatureSelection().unselectItems(ly);
                }
                if (layerViewPanel.getSelectionManager().getFeaturesWithSelectedItems().isEmpty()) {
                    WorkbenchContext.getFrame().activateDefaultCT();
                }
                if (errors.length() > 0) {
                    dlgWait.setError(new Exception(errors.toString(), lastError));
                }
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(run);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            if (count.get() > 0) {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.getMessage("ui.plugin.io.layer.SaveLayerFeatureChanges.changed-features-message", count), (String)I18N.get("ui.plugin.io.layer.SaveLayerFeatureChanges.message"));
            }
            ExceptionDialog.handleGuiException((Component)WorkbenchContext.getFrame(), (Exception)dlgWait.getError(), SaveLayerFeatureChangesPlugIn.class);
        }
    }

    public static void commitLayer(Layer ly, boolean bolAdded, boolean bolModified, boolean bolDeleted) {
        if (!ly.hasNonPersistedChanges()) {
            return;
        }
        WaitDialog dlgWait = new WaitDialog((Window)WorkbenchContext.getFrame(), ly.getName() + " - " + I18N.get("ui.plugin.io.layer.SaveLayerFeatureChanges.message"));
        dlgWait.setCancelable(false);
        Runnable run = () -> {
            try {
                try {
                    ly.commitEditedFeatures(bolAdded, bolModified, bolDeleted);
                }
                catch (Throwable t) {
                    throw new Exception(I18N.getMessage("ui.plugin.io.layer.SaveLayerFeatureChanges.error-commiting-changes", ly.toString(), t.getMessage()), t);
                }
                if (ly.isSelectionClearingNeeded(bolAdded, bolModified, bolDeleted)) {
                    WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getFeatureSelection().unselectItems(ly);
                }
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(run);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)WorkbenchContext.getFrame(), (Exception)dlgWait.getError(), SaveLayerFeatureChangesPlugIn.class);
        }
    }

    @Override
    public EnableCheck createEnableCheck() {
        return component -> {
            String strCheck = EditingPanel.instanceOf().getInternalFrameActiveCheck().check(component);
            if (strCheck != null) {
                return strCheck;
            }
            if (this.hasUncommitedFeatures(WorkbenchContext.getInstance().getLayerManager())) {
                return null;
            }
            return "No layers found.";
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUncommitedFeatures(LayerManager layerManager) {
        Collection<Layer> lstLy;
        Collection<Layer> collection = lstLy = this.getLayers(layerManager);
        synchronized (collection) {
            return lstLy.stream().anyMatch(Layer::hasNonPersistedChanges);
        }
    }

    protected Collection<Layer> getLayers(LayerManager layerManager) {
        return layerManager.getLayers();
    }
}

