/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.ui.layertree.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SaveLayerFeatureChangedDialog
extends JDialog {
    private final LayerNameRenderer lyRenderer = new LayerNameRenderer();
    private boolean bolWasSavePressed = false;
    private final KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            if (code == 27) {
                SaveLayerFeatureChangedDialog.this.butCancel_onActionPerformed(null);
            } else if (code == 10) {
                SaveLayerFeatureChangedDialog.this.butSave_onActionPerformed(null);
            }
        }
    };
    private JButton btnSelectAll;
    private JButton btnUnselectAll;
    private JButton butCancel;
    private JButton butSave;
    private JCheckBox cboSaveAll;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JLabel lblLayers;
    private JList lstLayers;

    public SaveLayerFeatureChangedDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.i18n();
        this.init();
    }

    public void setLayers(Collection<Layer> layers) {
        DefaultListModel<Object> lstModel = new DefaultListModel<Object>();
        this.lstLayers.setModel(lstModel);
        ArrayList<Layer> lstLayer = new ArrayList<Layer>(layers);
        Object[] arrLy = lstLayer.toArray(new Layer[0]);
        Arrays.sort(arrLy);
        for (Object ly : arrLy) {
            if ((!((Layer)ly).isEditable() || !((Layer)ly).hasEditedFeatures()) && (!(ly instanceof RedlineLayer) || !((RedlineLayer)ly).isMetaDataModified())) continue;
            lstModel.addElement(ly);
        }
        if (this.lstLayers.getModel().getSize() > 0) {
            this.lstLayers.setSelectedIndex(0);
        }
        this.updateComponents();
    }

    public boolean wasSavePressed() {
        return this.bolWasSavePressed;
    }

    private void i18n() {
        this.setTitle(I18N.get("ui.plugin.io.layer.SaveLayerFeatureChangedDialog.title"));
        this.cboSaveAll.setText(I18N.get("ui.plugin.io.layer.SaveLayerFeatureChangedDialog.save-all"));
        this.lblLayers.setText(I18N.get("ui.plugin.io.layer.SaveLayerFeatureChangedDialog.layers"));
        this.butSave.setText(I18N.get("ui.plugin.io.layer.SaveLayerFeatureChangedDialog.save"));
        this.butCancel.setText(I18N.get("common.cancel"));
        this.btnSelectAll.setToolTipText(I18N.get("ui.plugin.io.layer.SaveLayerFeatureChangedDialog.select-all"));
        this.btnUnselectAll.setToolTipText(I18N.get("ui.plugin.io.layer.SaveLayerFeatureChangedDialog.unselect-all"));
    }

    private void init() {
        this.setSize(200, 275);
        GUISupport.centreOnScreen((Component)this);
        this.lstLayers.setCellRenderer(this.lyRenderer);
        this.cboSaveAll.setSelected(true);
        GUISupport.addKeyListenersRecursively((Component)this, (KeyListener)this.keyListener);
        this.updateComponents();
    }

    private void updateComponents() {
        if (this.cboSaveAll.isSelected()) {
            this.lblLayers.setEnabled(false);
            this.lstLayers.setEnabled(false);
            this.btnSelectAll.setEnabled(false);
            this.btnUnselectAll.setEnabled(false);
        } else {
            this.lblLayers.setEnabled(true);
            this.lstLayers.setEnabled(true);
            this.btnSelectAll.setEnabled(true);
            this.btnUnselectAll.setEnabled(true);
        }
        if (this.lstLayers.getModel().getSize() > 0) {
            this.butSave.setEnabled(true);
        } else {
            this.butSave.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.lstLayers = new JList();
        this.lblLayers = new JLabel();
        this.cboSaveAll = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.butSave = new JButton();
        this.butCancel = new JButton();
        this.btnSelectAll = new JButton();
        this.btnUnselectAll = new JButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.lstLayers);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.lblLayers.setText("Ebenen mit \u00c4nderungen:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.getContentPane().add((Component)this.lblLayers, gridBagConstraints);
        this.cboSaveAll.setText("alles speichern");
        this.cboSaveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveLayerFeatureChangedDialog.this.cboSaveAll_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 3);
        this.getContentPane().add((Component)this.cboSaveAll, gridBagConstraints);
        this.butSave.setText("speichern");
        this.butSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveLayerFeatureChangedDialog.this.butSave_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butSave);
        this.butCancel.setText("abbrechen");
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveLayerFeatureChangedDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.btnSelectAll.setIcon(IconLoader.svgIconSmall((String)"common_select_small.svg"));
        this.btnSelectAll.setMaximumSize(new Dimension(22, 22));
        this.btnSelectAll.setMinimumSize(new Dimension(22, 22));
        this.btnSelectAll.setPreferredSize(new Dimension(22, 22));
        this.btnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveLayerFeatureChangedDialog.this.btnSelectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.btnSelectAll, gridBagConstraints);
        this.btnUnselectAll.setIcon(IconLoader.svgIconSmall((String)"common_unselect_small.svg"));
        this.btnUnselectAll.setMaximumSize(new Dimension(22, 22));
        this.btnUnselectAll.setMinimumSize(new Dimension(22, 22));
        this.btnUnselectAll.setPreferredSize(new Dimension(22, 22));
        this.btnUnselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveLayerFeatureChangedDialog.this.btnUnselectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.btnUnselectAll, gridBagConstraints);
        this.pack();
    }

    private void cboSaveAll_onActionPerformed(ActionEvent evt) {
        this.updateComponents();
    }

    private void butSave_onActionPerformed(ActionEvent evt) {
        WorkbenchContext.getInstance().getLayerManager().getUndoableEditReceiver().reportIrreversibleChange();
        if (this.cboSaveAll.isSelected()) {
            SaveLayerFeatureChangesPlugIn.commitAllLayers();
        } else {
            Object[] arrLy;
            for (Object arrLy1 : arrLy = this.lstLayers.getSelectedValues()) {
                SaveLayerFeatureChangesPlugIn.commitLayer((Layer)arrLy1, true, true, true);
            }
        }
        this.bolWasSavePressed = false;
        this.setVisible(false);
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.bolWasSavePressed = false;
        this.setVisible(false);
    }

    private void btnSelectAllActionPerformed(ActionEvent evt) {
        int size = this.lstLayers.getModel().getSize();
        if (size > 0) {
            this.lstLayers.getSelectionModel().setSelectionInterval(0, size - 1);
        }
    }

    private void btnUnselectAllActionPerformed(ActionEvent evt) {
        this.lstLayers.getSelectionModel().clearSelection();
    }
}

