/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerToKmlPlugIn;
import de.riwagis.geotools.feature.CollectionFeatureIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;

public class SaveAllLayerSelectionToKmlPlugIn
extends SaveLayerToKmlPlugIn {
    @Override
    public String getName() {
        return I18N.get("ui.plugin.io.layer.SaveAllLayerSelectionToKmlPlugIn.name");
    }

    @Override
    public List<Layer> getSelectedLayers() {
        Collection<Layer> colLy = this.getContext().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        ArrayList<Layer> lstLy = new ArrayList<Layer>();
        lstLy.addAll(colLy);
        Collections.sort(lstLy);
        ArrayList<Layerable> tmpLayerable = new ArrayList<Layerable>();
        tmpLayerable.addAll(lstLy);
        LayerManager.moveLayersDrawnLastToEnd(tmpLayerable);
        return lstLy;
    }

    @Override
    public FeatureIterator<SimpleFeature> getFeatureIterator(Layer ly) throws Exception {
        Collection<SimpleFeature> col = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(ly);
        return new CollectionFeatureIterator(col);
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(SaveAllLayerSelectionToKmlPlugIn.createExportAllowedCheck()).add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNFeaturesMustBeSelectedCheck(1));
    }
}

