/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class RollbackLayerFeatureChangesPlugIn
extends AbstractPlugIn {
    @Override
    public String getName() {
        return I18N.get("ui.plugin.io.layer.RollbackLayerFeatureChanges.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"common_edit_rollback.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        if (context.getLayerManager() == null) {
            return true;
        }
        int option = JOptionPane.showConfirmDialog(context.getWorkbenchFrame(), I18N.get("ui.plugin.io.layer.RollbackLayerFeatureChanges.are-you-sure"), I18N.get("common.message"), 0);
        if (option != 0) {
            return true;
        }
        WaitDialog dlgWait = new WaitDialog((Window)WorkbenchContext.getFrame(), I18N.get("common.wait"));
        Runnable run = () -> {
            try {
                context.getLayerManager().getUndoableEditReceiver().reportIrreversibleChange();
                Collection<Layer> lstLy = this.getLayers(context.getLayerManager());
                for (Layer ly : lstLy) {
                    if (!ly.isEditable() || !ly.hasEditedFeatures()) continue;
                    ly.rollbackEditedFeatures();
                    ly.clearFeatureCache();
                    ly.fireAppearanceChanged();
                    ly.fireLayerChanged(LayerEventType.TABLE_DATA_CHANGED);
                }
                context.getLayerViewPanel().getSelectionManager().clear();
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        };
        dlgWait.addWorkToDo(run);
        dlgWait.setVisible(500L);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)WorkbenchContext.getFrame(), (Exception)dlgWait.getError(), SaveLayerFeatureChangesPlugIn.class);
        }
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        return component -> {
            Collection<Layer> lstLy;
            String strCheck = EditingPanel.instanceOf().getInternalFrameActiveCheck().check(component);
            if (strCheck != null) {
                return strCheck;
            }
            boolean bolFeaturesFound = false;
            Collection<Layer> collection = lstLy = this.getLayers(WorkbenchContext.getInstance().getLayerManager());
            synchronized (collection) {
                for (Layer ly2test : lstLy) {
                    if ((!ly2test.isEditable() || !ly2test.hasEditedFeatures()) && (!(ly2test instanceof RedlineLayer) || !((RedlineLayer)ly2test).isMetaDataModified())) continue;
                    bolFeaturesFound = true;
                    break;
                }
            }
            if (bolFeaturesFound) {
                return null;
            }
            return "No layers found.";
        };
    }

    protected Collection<Layer> getLayers(LayerManager layerManager) {
        return layerManager.getLayers();
    }
}

