/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.importer.GeoPackageImportFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.importer.ImportFileChooser;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.importer.ImportFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.importer.ShapefileImportFormat;
import de.riwagis.guitools.Tasks;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;

public class LoadLayerFromFilePlugIn
extends AbstractPlugIn {
    private static final Class<? extends ImportFormat> DEFAULT_IMPORT_FORMAT = GeoPackageImportFormat.class;
    private static final String KEY_IMPORT_PATH = LoadLayerFromFilePlugIn.class.getName() + "_LAST_USED_FILE";
    private static final Map<FileFilter, ImportFormat> formats = Map.ofEntries(new GeoPackageImportFormat().createEntry(), new ShapefileImportFormat().createEntry());
    private final Blackboard blackBoard = PersistentBlackboardPlugIn.get();
    private final String defaultFileKey;
    private final Class<? extends ImportFormat> defaultImportFormat;

    public LoadLayerFromFilePlugIn() {
        this(KEY_IMPORT_PATH, DEFAULT_IMPORT_FORMAT);
    }

    public LoadLayerFromFilePlugIn(String defaultFileKey, Class<? extends ImportFormat> defaultImportFormat) {
        this.defaultFileKey = defaultFileKey;
        this.defaultImportFormat = defaultImportFormat;
    }

    @Override
    public EnableCheck createEnableCheck() {
        return EnableCheckFactory.getInstance().createTaskWindowMustBeActiveCheck();
    }

    @Override
    public String getName() {
        return I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.LoadLayerFromFilePlugIn.name");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        ImportFileChooser fileChooser = new ImportFileChooser(formats, this.defaultImportFormat, context);
        File lastUsedFile = new File(this.blackBoard.get(this.defaultFileKey, ""));
        fileChooser.setSelectedFile(lastUsedFile);
        this.setLastUsedFileFilter(fileChooser, lastUsedFile);
        List<File> files = fileChooser.showImportDialogAndReturnSelection();
        if (files.isEmpty()) {
            return true;
        }
        files.stream().findFirst().ifPresent(file -> this.blackBoard.put(this.defaultFileKey, file.getAbsolutePath()));
        ImportFormat format = fileChooser.getImportFormat();
        return Tasks.submit(() -> format.doImport(context, files));
    }

    private void setLastUsedFileFilter(ImportFileChooser fileChooser, File lastUsedFile) {
        formats.keySet().stream().filter(fileFilter -> fileFilter.accept(lastUsedFile)).findFirst().ifPresent(fileChooser::setFileFilter);
    }

    public static void loadFromFile(PlugInContext context, File file, ImportFormat format) throws Exception {
        format.doImport(context, Collections.singletonList(file));
    }
}

