/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.AddRedlineLayerPlugIn;
import de.micromata.opengis.kml.v_2_2_0.Boundary;
import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.Geometry;
import de.micromata.opengis.kml.v_2_2_0.IconStyle;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import de.micromata.opengis.kml.v_2_2_0.LabelStyle;
import de.micromata.opengis.kml.v_2_2_0.LineString;
import de.micromata.opengis.kml.v_2_2_0.LineStyle;
import de.micromata.opengis.kml.v_2_2_0.LinearRing;
import de.micromata.opengis.kml.v_2_2_0.MultiGeometry;
import de.micromata.opengis.kml.v_2_2_0.Pair;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.PolyStyle;
import de.micromata.opengis.kml.v_2_2_0.Style;
import de.micromata.opengis.kml.v_2_2_0.StyleMap;
import de.micromata.opengis.kml.v_2_2_0.StyleSelector;
import de.micromata.opengis.kml.v_2_2_0.StyleState;
import de.riwagis.crs.CRSDefFactory;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.jts.JTSSupport;
import jakarta.xml.bind.UnmarshalException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.geometry.jts.GeometryCollector;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportKmlToLayerPlugin
extends AbstractPlugIn {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportKmlToLayerPlugin.class);
    private static final Blackboard BB = PersistentBlackboardPlugIn.get();
    public static final String KEY_DIR = ImportKmlToLayerPlugin.class.getName() + "_Dir";
    private static final FileFilter KML_FILEFILTER = GUISupport.createFileFilter((String)"KML", (String[])new String[]{"kml"});
    private static final FileFilter KMZ_FILEFILTER = GUISupport.createFileFilter((String)"KMZ", (String[])new String[]{"kmz"});
    private static final FileFilter KMZ_KMZ_FILEFILTER = GUISupport.createFileFilter((String)"KML/KMZ", (String[])new String[]{"kml", "kmz"});
    public static final GeometryFactory GEOM_FACTORY = new GeometryFactory();
    private static final String DEFAULT_SYMBOL = "cross.svg";
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private int renderPrioCounter;
    private boolean useDefaultStyle = false;

    @Override
    public String getName() {
        return I18N.get("ui.plugin.io.layer.ImportKmlToLayerPlugin.name");
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory ecf = EnableCheckFactory.getInstance();
        return ecf.createTaskWindowMustBeActiveCheck();
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        int result;
        CoordinateReferenceSystem projCRS = context.getTask().getCRSDefinition().getCRS();
        boolean canceled = false;
        this.renderPrioCounter = 0;
        if (projCRS == null && (result = JOptionPane.showConfirmDialog(context.getWorkbenchFrame(), I18N.get("ui.plugin.io.layer.ImportKmlToLayerPlugin.transformation-not-possible"), I18N.get("common.message"), 2, 1)) == 2) {
            canceled = true;
        }
        if (!canceled) {
            List<File> kmlFiles = this.selectFiles(context.getWorkbenchFrame());
            WaitDialog dlgWait = new WaitDialog((Window)WorkbenchContext.getFrame(), I18N.get("common.wait"));
            Runnable run = () -> {
                try {
                    if (!kmlFiles.isEmpty()) {
                        BB.put(KEY_DIR, ((File)kmlFiles.get(0)).toString());
                        this.impKMLFiles(context, projCRS, kmlFiles);
                    }
                }
                catch (Exception e) {
                    dlgWait.setError(e);
                }
            };
            dlgWait.addWorkToDo(run);
            dlgWait.setVisible(true);
            if (dlgWait.getError() != null) {
                ExceptionDialog.handleGuiException((Component)WorkbenchContext.getFrame(), (Throwable)dlgWait.getError(), (String)"riwagis");
            }
        }
        return true;
    }

    private List<File> selectFiles(Frame parent) {
        JFileChooser fChoose = GUISupport.createJFileChooser((boolean)true);
        fChoose.addChoosableFileFilter(KML_FILEFILTER);
        fChoose.addChoosableFileFilter(KMZ_FILEFILTER);
        fChoose.setFileFilter(KMZ_KMZ_FILEFILTER);
        fChoose.setAcceptAllFileFilterUsed(false);
        fChoose.setMultiSelectionEnabled(true);
        fChoose.setSelectedFile(new File(BB.get(KEY_DIR, "")));
        int intRetVal = fChoose.showOpenDialog(parent);
        if (intRetVal == 0) {
            return this.removeUnsupportedFiles(fChoose.getSelectedFiles());
        }
        return new ArrayList<File>();
    }

    private List<File> removeUnsupportedFiles(File[] selectedFiles) {
        ArrayList<File> lstFiles = new ArrayList<File>();
        for (File file : selectedFiles) {
            if (!KML_FILEFILTER.accept(file) && !KMZ_FILEFILTER.accept(file)) continue;
            lstFiles.add(file);
        }
        return lstFiles;
    }

    private void impKMLFiles(PlugInContext context, CoordinateReferenceSystem projCRS, List<File> kmlFiles) throws Exception {
        MathTransform trans = null;
        if (projCRS != null) {
            CoordinateReferenceSystem wgs84CRS = CRSDefFactory.createCRS((String)"EPSG:4326");
            trans = CRS.findMathTransform((CoordinateReferenceSystem)wgs84CRS, (CoordinateReferenceSystem)projCRS);
        }
        for (File currKMLFile : kmlFiles) {
            if (KML_FILEFILTER.accept(currKMLFile)) {
                this.handleKMLFiles(context, trans, currKMLFile);
                continue;
            }
            this.handleKMZFiles(context, trans, currKMLFile);
        }
    }

    private void handleKMLFiles(PlugInContext context, MathTransform trans, File kmlFile) throws Exception {
        try (FileInputStream fis = new FileInputStream(kmlFile);
             InputStreamReader isr = new InputStreamReader((InputStream)fis, Charset.defaultCharset());){
            String str = IOUtils.toString((Reader)isr);
            str = StringUtils.replace((String)str, (String)"xmlns=\"http://earth.google.com/kml/2.2\"", (String)"xmlns=\"http://www.opengis.net/kml/2.2\" xmlns:gx=\"http://www.google.com/kml/ext/2.2\"");
            try (ByteArrayInputStream bais = new ByteArrayInputStream(str.getBytes(Charset.defaultCharset()));){
                Kml kml = Kml.unmarshal((InputStream)bais);
                if (kml == null) {
                    throw new UnmarshalException(I18N.get("ui.plugin.io.layer.ImportKmlToLayerPlugin.unmarshal-exception"));
                }
                this.handleKmlKmzFiles(context, trans, kml.getFeature());
            }
        }
    }

    private void handleKMZFiles(PlugInContext context, MathTransform trans, File kmlFile) throws Exception {
        Kml[] kml = Kml.unmarshalFromKmz((File)kmlFile);
        if (kml == null) {
            throw new UnmarshalException(I18N.get("ui.plugin.io.layer.ImportKmlToLayerPlugin.unmarshal-exception"));
        }
        for (Kml kmz : kml) {
            this.handleKmlKmzFiles(context, trans, kmz.getFeature());
        }
    }

    private void handleKmlKmzFiles(PlugInContext context, MathTransform trans, Feature feature) throws Exception {
        if (feature != null) {
            List lstDocStyleSelector = feature.getStyleSelector();
            ArrayList<Feature> lstFeatures = null;
            if (feature instanceof Folder) {
                lstFeatures = ((Folder)feature).getFeature();
            } else if (feature instanceof Document) {
                lstFeatures = ((Document)feature).getFeature();
            } else if (feature instanceof Placemark) {
                lstFeatures = new ArrayList<Feature>();
                lstFeatures.add(feature);
            }
            LayerManager lm = context.getLayerManager();
            Category documentCat = lm.addCategory(lm.uniqueCategoryName(this.getLayerName(feature.getName())));
            this.createTree(context, trans, lstDocStyleSelector, documentCat, lstFeatures);
        }
    }

    private void createTree(PlugInContext context, MathTransform trans, List<StyleSelector> lstDocStyleSelector, Category category, List<Feature> lstFeatures) throws Exception {
        LayerManager lm = context.getLayerManager();
        LinkedList<SimpleFeature> lstSimpleFeatures = new LinkedList<SimpleFeature>();
        String catName = null;
        RedlineLayer layer = null;
        for (Feature feature : lstFeatures) {
            Placemark placemark;
            if (feature instanceof Folder) {
                Folder folder = (Folder)feature;
                catName = lm.uniqueCategoryName(this.getLayerName(folder.getName()));
                Category catFolder = lm.addCategory(this.getLayerName(catName));
                category.addSubcategory(catFolder);
                ++this.renderPrioCounter;
                this.createTree(context, trans, lstDocStyleSelector, catFolder, folder.getFeature());
                continue;
            }
            if (!(feature instanceof Placemark) || (placemark = (Placemark)feature).getGeometry() == null) continue;
            if (catName == null || layer == null) {
                String layerName = this.getLayerName(placemark.getName());
                String uniqueLayerName = lm.uniqueCategoryName(layerName);
                layer = AddRedlineLayerPlugIn.addLayer(context, category, uniqueLayerName);
                layer.setRenderPrio(layer.getRenderPrio() + this.renderPrioCounter);
                catName = category.getName();
            }
            lstSimpleFeatures.addAll(this.createSimpleFeature(placemark, lstDocStyleSelector, layer, trans));
            if (lstSimpleFeatures.isEmpty() || lstSimpleFeatures.size() != 2) continue;
            layer.setName(catName);
        }
        if (layer != null && !lstSimpleFeatures.isEmpty()) {
            this.addFeatures(layer, lstSimpleFeatures);
        }
    }

    private String getLayerName(String name) {
        return name == null ? I18N.get("ui.plugin.io.layer.ImportKmlToLayerPlugin.no-name") : name.trim();
    }

    private List<SimpleFeature> createSimpleFeature(Placemark placemark, List<StyleSelector> lstDocStyleSelector, RedlineLayer rly, MathTransform trans) throws Exception {
        org.locationtech.jts.geom.Geometry jtsGeom = this.getJtsGeometry(placemark.getGeometry());
        if (jtsGeom != null) {
            ArrayList<SimpleFeature> lstSimpleFeatures = new ArrayList<SimpleFeature>();
            List lstGeoms = JTSSupport.splitGeometryCollections((org.locationtech.jts.geom.Geometry)jtsGeom);
            Iterator iterator = lstGeoms.iterator();
            while (iterator.hasNext()) {
                org.locationtech.jts.geom.Geometry geom;
                org.locationtech.jts.geom.Geometry targetGeometry = geom = (org.locationtech.jts.geom.Geometry)iterator.next();
                if (trans != null) {
                    targetGeometry = JTS.transform((org.locationtech.jts.geom.Geometry)geom, (MathTransform)trans);
                }
                SimpleFeature sf = FeatureUtil.createFeature((SimpleFeatureType)rly.getFeatureType(), (org.locationtech.jts.geom.Geometry)targetGeometry);
                String name = placemark.getName() == null ? "" : placemark.getName().trim();
                String description = placemark.getDescription() == null ? "" : placemark.getDescription().trim();
                String layerName = name == null ? description : name.concat("\n").concat(description);
                sf.setAttribute(CadFeatureAtts.NAME.getName(), (Object)layerName);
                sf.setAttribute(CadFeatureAtts.TEXT.getName(), (Object)name);
                this.setStyles(placemark, lstDocStyleSelector, sf);
                lstSimpleFeatures.add(sf);
            }
            return lstSimpleFeatures;
        }
        return Collections.emptyList();
    }

    private org.locationtech.jts.geom.Geometry getJtsGeometry(Geometry geom) {
        this.useDefaultStyle = false;
        if (geom instanceof de.micromata.opengis.kml.v_2_2_0.Point) {
            this.useDefaultStyle = true;
            return this.createJTSPoint((de.micromata.opengis.kml.v_2_2_0.Point)geom);
        }
        if (geom instanceof LineString) {
            org.locationtech.jts.geom.LineString ls = this.createJTSLineString(((LineString)geom).getCoordinates());
            if (ls.getLength() == 0.0) {
                this.useDefaultStyle = true;
                return GEOM_FACTORY.createPoint(ls.getCoordinateN(0));
            }
            return ls;
        }
        if (geom instanceof LinearRing) {
            List coordinates = ((LinearRing)geom).getCoordinates();
            if (!((de.micromata.opengis.kml.v_2_2_0.Coordinate)coordinates.get(0)).equals(coordinates.get(coordinates.size() - 1))) {
                coordinates.add((de.micromata.opengis.kml.v_2_2_0.Coordinate)coordinates.get(0));
            }
            return this.createJTSLineString(((LinearRing)geom).getCoordinates());
        }
        if (geom instanceof de.micromata.opengis.kml.v_2_2_0.Polygon) {
            return this.createJTSPolygon((de.micromata.opengis.kml.v_2_2_0.Polygon)geom);
        }
        if (geom instanceof MultiGeometry) {
            GeometryCollector gc = new GeometryCollector();
            MultiGeometry mg = (MultiGeometry)geom;
            this.createJTSMultiGeometry(mg, gc);
            return gc.collect();
        }
        return null;
    }

    private Point createJTSPoint(de.micromata.opengis.kml.v_2_2_0.Point point) {
        Coordinate jtsCoord = null;
        List lstCoords = point.getCoordinates();
        for (de.micromata.opengis.kml.v_2_2_0.Coordinate coord : lstCoords) {
            jtsCoord = this.getJTSCoordinate(coord);
        }
        return GEOM_FACTORY.createPoint(jtsCoord);
    }

    private org.locationtech.jts.geom.LineString createJTSLineString(List<de.micromata.opengis.kml.v_2_2_0.Coordinate> coordinates) {
        List<Coordinate> lstJTSCoords = this.getListOfJTSCoordinates(coordinates);
        Coordinate[] arrCoords = new Coordinate[lstJTSCoords.size()];
        arrCoords = lstJTSCoords.toArray(arrCoords);
        return GEOM_FACTORY.createLineString(arrCoords);
    }

    private org.locationtech.jts.geom.Geometry createJTSPolygon(de.micromata.opengis.kml.v_2_2_0.Polygon polygon) {
        List lstKMLOuterCoords = polygon.getOuterBoundaryIs().getLinearRing().getCoordinates();
        List<Coordinate> lstJTSOuterCoords = this.getListOfJTSCoordinates(lstKMLOuterCoords);
        Coordinate[] arrOuterCoords = new Coordinate[lstJTSOuterCoords.size()];
        arrOuterCoords = lstJTSOuterCoords.toArray(arrOuterCoords);
        Polygon outerPolygon = GEOM_FACTORY.createPolygon(arrOuterCoords);
        ArrayList<Polygon> lstJTSInnerPolygons = new ArrayList<Polygon>();
        if (!polygon.getInnerBoundaryIs().isEmpty()) {
            List lstInnerBoundary = polygon.getInnerBoundaryIs();
            for (Boundary boundary : lstInnerBoundary) {
                List<Coordinate> lstJTSInnerCoordsBoundary = this.getListOfJTSCoordinates(boundary.getLinearRing().getCoordinates());
                Coordinate[] arrInnerCoords = new Coordinate[lstJTSInnerCoordsBoundary.size()];
                arrInnerCoords = lstJTSInnerCoordsBoundary.toArray(arrInnerCoords);
                lstJTSInnerPolygons.add(GEOM_FACTORY.createPolygon(arrInnerCoords));
            }
        }
        ArrayList<Polygon> lstPolygons = new ArrayList<Polygon>();
        lstPolygons.add(outerPolygon);
        lstPolygons.addAll(lstJTSInnerPolygons);
        return this.computeGeometry(lstPolygons);
    }

    private void createJTSMultiGeometry(MultiGeometry geom, GeometryCollector gc) {
        MultiGeometry mg = geom;
        for (Geometry g : mg.getGeometry()) {
            if (g instanceof de.micromata.opengis.kml.v_2_2_0.Point) {
                this.useDefaultStyle = true;
                gc.add((org.locationtech.jts.geom.Geometry)this.createJTSPoint((de.micromata.opengis.kml.v_2_2_0.Point)g));
                continue;
            }
            if (g instanceof LineString) {
                gc.add((org.locationtech.jts.geom.Geometry)this.createJTSLineString(((LineString)g).getCoordinates()));
                continue;
            }
            if (g instanceof de.micromata.opengis.kml.v_2_2_0.Polygon) {
                gc.add(this.createJTSPolygon((de.micromata.opengis.kml.v_2_2_0.Polygon)g));
                continue;
            }
            if (!(g instanceof MultiGeometry)) continue;
            this.createJTSMultiGeometry((MultiGeometry)g, gc);
        }
    }

    private List<Coordinate> getListOfJTSCoordinates(List<de.micromata.opengis.kml.v_2_2_0.Coordinate> lstKMLCoords) {
        ArrayList<Coordinate> lstJTSCoords = new ArrayList<Coordinate>();
        for (de.micromata.opengis.kml.v_2_2_0.Coordinate coord : lstKMLCoords) {
            lstJTSCoords.add(this.getJTSCoordinate(coord));
        }
        return lstJTSCoords;
    }

    private Coordinate getJTSCoordinate(de.micromata.opengis.kml.v_2_2_0.Coordinate kmlCoord) {
        return new Coordinate(kmlCoord.getLongitude(), kmlCoord.getLatitude(), kmlCoord.getAltitude());
    }

    private org.locationtech.jts.geom.Geometry computeGeometry(List<Polygon> lstPolygons) {
        Polygon geometry = null;
        for (Polygon poly : lstPolygons) {
            if (geometry == null) {
                geometry = poly;
                continue;
            }
            geometry = geometry.symDifference((org.locationtech.jts.geom.Geometry)poly);
        }
        return geometry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFeatures(RedlineLayer rdl, List<SimpleFeature> features) throws InterruptedException {
        TimeUnit.MILLISECONDS.sleep(200L);
        boolean useDefaultFeature = rdl.getUseDefaultFeature();
        rdl.setUseDefaultFeature(false);
        try {
            rdl.editFeature(features, 1);
        }
        finally {
            rdl.setUseDefaultFeature(useDefaultFeature);
        }
    }

    private void setStyles(Placemark placemark, List<StyleSelector> lstDocStyleSelector, SimpleFeature sf) {
        List featStyleSelector = placemark.getStyleSelector();
        if (featStyleSelector.isEmpty()) {
            String taggedStyleUrl = placemark.getStyleUrl();
            if (taggedStyleUrl != null) {
                String styleUrl = this.removeStyleUrlIdTag(placemark.getStyleUrl());
                block0: for (StyleSelector ss : lstDocStyleSelector) {
                    if (!(ss instanceof StyleMap) || !ss.getId().equals(styleUrl)) continue;
                    StyleMap styleMap = (StyleMap)ss;
                    for (Pair pair : styleMap.getPair()) {
                        if (!pair.getKey().equals((Object)StyleState.NORMAL)) continue;
                        styleUrl = this.removeStyleUrlIdTag(pair.getStyleUrl());
                        continue block0;
                    }
                }
                for (StyleSelector ss : lstDocStyleSelector) {
                    if (!(ss instanceof Style) || !ss.getId().equals(styleUrl)) continue;
                    Style style = (Style)ss;
                    this.setStyleAttributes(sf, style);
                    break;
                }
            }
        } else {
            for (StyleSelector ss : featStyleSelector) {
                if (!(ss instanceof Style)) continue;
                Style style = (Style)ss;
                this.setStyleAttributes(sf, style);
            }
        }
        if (this.useDefaultStyle) {
            sf.setAttribute(CadFeatureAtts.SYMBOL.getName(), (Object)DEFAULT_SYMBOL);
            sf.setAttribute(CadFeatureAtts.LINECOLOR.getName(), (Object)DEFAULT_COLOR.getRGB());
        }
    }

    private String removeStyleUrlIdTag(String styleUrl) {
        return StringUtils.replaceOnce((String)styleUrl, (String)"#", (String)"").trim();
    }

    private void setStyleAttributes(SimpleFeature sf, Style style) {
        LineStyle lineStyle = style.getLineStyle();
        PolyStyle polyStyle = style.getPolyStyle();
        IconStyle iconStyle = style.getIconStyle();
        LabelStyle labelStyle = style.getLabelStyle();
        if (lineStyle != null) {
            sf.setAttribute(CadFeatureAtts.LINEWIDTH.getName(), (Object)lineStyle.getWidth());
            sf.setAttribute(CadFeatureAtts.LINECOLOR.getName(), (Object)this.hexToColor(lineStyle.getColor()).getRGB());
        }
        if (polyStyle != null) {
            boolean fill = polyStyle.isFill() != null && polyStyle.isFill() != false;
            sf.setAttribute(CadFeatureAtts.RENDERFILL.getName(), fill ? Integer.valueOf(1) : "");
            sf.setAttribute(CadFeatureAtts.FILLCOLOR.getName(), (Object)this.hexToColor(polyStyle.getColor()).getRGB());
            sf.setAttribute(CadFeatureAtts.ALPHA.getName(), (Object)this.hexToColor(polyStyle.getColor()).getAlpha());
        }
        if (iconStyle != null) {
            boolean iconExists;
            boolean bl = iconExists = iconStyle.getIcon() != null;
            if (iconExists) {
                sf.setAttribute(CadFeatureAtts.SYMBOL.getName(), (Object)DEFAULT_SYMBOL);
                sf.setAttribute(CadFeatureAtts.LINECOLOR.getName(), (Object)this.hexToColor(iconStyle.getColor()).getRGB());
            }
        }
        if (labelStyle != null && labelStyle.getColor() != null) {
            sf.setAttribute(CadFeatureAtts.TEXTCOLOR.getName(), (Object)this.hexToColor(labelStyle.getColor()).getRGB());
        }
    }

    private Color hexToColor(String abgr) {
        if (abgr == null) {
            return DEFAULT_COLOR;
        }
        String color = abgr.trim();
        int interval = 2;
        int arrayLength = (int)Math.ceil((double)color.length() / (double)interval);
        Integer[] arrColor = new Integer[arrayLength];
        int j = 0;
        int lastIndex = arrColor.length - 1;
        for (int i = 0; i < lastIndex; ++i) {
            int value = Integer.parseInt(color.substring(j, j + interval), 16);
            arrColor[i] = value;
            j += interval;
        }
        arrColor[lastIndex] = Integer.parseInt(color.substring(j), 16);
        Color c = new Color(arrColor[3], arrColor[2], arrColor[1], arrColor[0]);
        if (c.getRGB() == -1) {
            return DEFAULT_COLOR;
        }
        return c;
    }
}

