/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer;

import com.vividsolutions.jump.I18N;
import de.riwagis.geotools.feature.FidFeature;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.data.model.TransformationService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.identity.FeatureId;

public class FeatureMapWriter {
    private static final FilterFactory2 ffac = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    private static final int BATCH_SIZE = 200;
    private final DMDCollection dmdCol;
    private final FeaturestoreMetadata fmd;
    private Map<String, SimpleFeature> mapFeatureModified = new HashMap<String, SimpleFeature>();
    private Map<String, SimpleFeature> mapFeatureAdded = new HashMap<String, SimpleFeature>();
    private Map<String, SimpleFeature> mapFeatureDeleted = new HashMap<String, SimpleFeature>();
    private final TransformationService transformer;

    public FeatureMapWriter(DMDCollection dmdCol, FeaturestoreMetadata fmd) {
        this.dmdCol = dmdCol;
        this.fmd = fmd;
        this.transformer = new TransformationService();
    }

    public void setFeatureAddedMap(Map<String, SimpleFeature> mapFeatureAdded) {
        this.mapFeatureAdded = mapFeatureAdded;
    }

    public void setFeatureModifiedMap(Map<String, SimpleFeature> mapFeatureModified) {
        this.mapFeatureModified = mapFeatureModified;
    }

    public void setFeatureDeletedMap(Map<String, SimpleFeature> mapFeatureDeleted) {
        this.mapFeatureDeleted = mapFeatureDeleted;
    }

    private void addToFidFilter(Collection<FeatureId> setFID, SimpleFeature f) {
        if (this.fmd.getEditInOtherDatatype()) {
            String strID = FeatureUtil.getFeatureIDWithoutTable((SimpleFeature)f);
            setFID.add(ffac.featureId(this.fmd.getDatatypeNameEdit() + "." + strID));
        } else if (f instanceof FidFeature) {
            setFID.add(((FidFeature)f).getDelegate().getIdentifier());
        } else {
            setFID.add(f.getIdentifier());
        }
    }

    private void addToCQLFilter(StringBuilder sbCQL, SimpleFeature f) {
        String strFID = f.getID();
        if (sbCQL.length() == 0) {
            sbCQL.append(this.fmd.getKeyAttEdit()).append("='").append(strFID).append("'");
        } else {
            sbCQL.append(" OR ").append(this.fmd.getKeyAttEdit()).append("='").append(strFID).append("'");
        }
    }

    public int commitFeatures() throws Exception {
        CommitLog commitLog = new CommitLog();
        if (!this.fmd.isInsertAllowed() && !this.mapFeatureAdded.isEmpty()) {
            throw new IllegalStateException(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.FeatureMapWriter.no-insert"));
        }
        if (!this.fmd.isDeleteAllowed() && !this.mapFeatureDeleted.isEmpty()) {
            throw new IllegalStateException(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.FeatureMapWriter.no-delete"));
        }
        this.commitAddedFeatures(commitLog);
        this.commitChangedFeatures(commitLog);
        this.commitDeletedFeatures(commitLog);
        return commitLog.getChangedFeaturesCount();
    }

    private void commitAddedFeatures(CommitLog commitLog) throws Exception {
        if (this.mapFeatureAdded.isEmpty()) {
            return;
        }
        this.writeAddedFeatures(commitLog);
    }

    private void commitDeletedFeatures(CommitLog commitLog) throws Exception {
        this.commitBatched(commitLog, this.mapFeatureDeleted, this::writeDeletedFeatures);
    }

    private void commitChangedFeatures(CommitLog commitLog) throws Exception {
        this.commitBatched(commitLog, this.mapFeatureModified, this::writeChangedFeatures);
    }

    private void writeFeatures(CommitLog commitLog, Map<String, SimpleFeature> features, Collection<String> fidsToRemove, Filter filt, FeatureOperation op, String operation) throws Exception {
        try (Transaction t = this.createTransaction();
             FeatureWriter<SimpleFeatureType, SimpleFeature> fw = this.fmd.getFeatureWriter(this.dmdCol, filt, t);){
            String fid = "";
            while (fw.hasNext() && !commitLog.errorLimitReached()) {
                try {
                    SimpleFeature writerFeature = (SimpleFeature)fw.next();
                    fid = this.getFIDforCorrectDataType(writerFeature);
                    op.writeFeature(commitLog, fw, writerFeature, fid, features);
                    fidsToRemove.add(fid);
                }
                catch (Throwable e) {
                    commitLog.error(operation, fid, e);
                }
            }
            if (t != Transaction.AUTO_COMMIT) {
                t.commit();
            }
        }
    }

    private Transaction createTransaction() throws IOException {
        if (this.fmd.getDataStore(this.dmdCol) instanceof JDBCDataStore) {
            return new DefaultTransaction("batchUpdate");
        }
        return Transaction.AUTO_COMMIT;
    }

    private void writeDeletedFeatures(CommitLog commitLog, Map<String, SimpleFeature> features, Collection<String> fidsToRemove, Filter filt) throws Exception {
        this.writeFeatures(commitLog, features, fidsToRemove, filt, this::doDeleteLogic, "Deleting");
    }

    private void doDeleteLogic(CommitLog commitLog, FeatureWriter<SimpleFeatureType, SimpleFeature> fw, SimpleFeature simpleFeature, String s, Map<String, SimpleFeature> stringSimpleFeatureMap) throws IOException {
        fw.remove();
        commitLog.featureChanged();
    }

    private void writeChangedFeatures(CommitLog commitLog, Map<String, SimpleFeature> features, Collection<String> fidsToRemove, Filter filt) throws Exception {
        this.writeFeatures(commitLog, features, fidsToRemove, filt, this::changeFeature, "Editing");
    }

    private void changeFeature(CommitLog commitLog, FeatureWriter<SimpleFeatureType, SimpleFeature> fw, SimpleFeature writerFeature, String fid, Map<String, SimpleFeature> features) throws Exception {
        SimpleFeature tmpFeature = features.get(fid);
        if (tmpFeature != null) {
            this.transformIfNecessary(tmpFeature);
            if (Boolean.TRUE.equals(tmpFeature.getUserData().get("FEATUREWRITER_KEEP_ALL_ATTRIBUTES"))) {
                FeatureUtil.copyFeatureData((SimpleFeature)tmpFeature, (SimpleFeature)writerFeature);
            } else {
                FeatureUtil.copyFeatureData((SimpleFeature)tmpFeature, (SimpleFeature)writerFeature, (String[])this.fmd.getAttributesEdit());
            }
            fw.write();
            commitLog.featureChanged();
        }
    }

    private void writeAddedFeatures(CommitLog commitLog) throws Exception {
        try (Transaction t = this.createTransaction();
             FeatureWriter<SimpleFeatureType, SimpleFeature> fw = this.fmd.getFeatureWriterAppend(this.dmdCol, t);){
            ArrayList<String> lstFIDtoRemove = new ArrayList<String>();
            for (Map.Entry<String, SimpleFeature> entry : this.mapFeatureAdded.entrySet()) {
                if (commitLog.errorLimitReached()) break;
                try {
                    SimpleFeature tmpFeature = entry.getValue();
                    this.transformIfNecessary(tmpFeature);
                    SimpleFeature writerFeature = (SimpleFeature)fw.next();
                    if (Boolean.TRUE.equals(tmpFeature.getUserData().get("FEATUREWRITER_KEEP_ALL_ATTRIBUTES"))) {
                        FeatureUtil.copyFeatureData((SimpleFeature)tmpFeature, (SimpleFeature)writerFeature);
                    } else {
                        FeatureUtil.copyFeatureData((SimpleFeature)tmpFeature, (SimpleFeature)writerFeature, (String[])this.fmd.getAttributesEdit());
                    }
                    fw.write();
                    lstFIDtoRemove.add(entry.getKey());
                    commitLog.featureChanged();
                }
                catch (Throwable e) {
                    commitLog.error("Adding new feature", e);
                }
            }
            if (t != Transaction.AUTO_COMMIT) {
                t.commit();
            }
            for (String currKey : lstFIDtoRemove) {
                this.mapFeatureAdded.remove(currKey);
            }
        }
    }

    private void commitBatched(CommitLog commitLog, Map<String, SimpleFeature> features, FeaturesOperation op) throws Exception {
        if (features.isEmpty()) {
            return;
        }
        ArrayList<String> fidsToRemove = new ArrayList<String>();
        HashSet<FeatureId> setFID = new HashSet<FeatureId>();
        StringBuilder sbCQL = new StringBuilder();
        int count = 0;
        Iterator<String> i = features.keySet().iterator();
        while (i.hasNext()) {
            String strFID = i.next();
            if (commitLog.errorLimitReached()) break;
            if (this.fmd.getKeyAttEdit() == null) {
                this.addToFidFilter(setFID, features.get(strFID));
            } else {
                this.addToCQLFilter(sbCQL, features.get(strFID));
            }
            if (++count <= 200 && i.hasNext()) continue;
            Object filt = this.fmd.getKeyAttEdit() == null ? ffac.id(new HashSet<FeatureId>(setFID)) : CQL.toFilter((String)sbCQL.toString(), (FilterFactory)ffac);
            setFID.clear();
            sbCQL = new StringBuilder();
            count = 0;
            op.writeFeatures(commitLog, features, (Collection<String>)fidsToRemove, (Filter)filt);
        }
        for (String currKey : fidsToRemove) {
            features.remove(currKey);
        }
    }

    private String getFIDforCorrectDataType(SimpleFeature writerFeature) {
        if (!this.fmd.getEditInOtherDatatype()) {
            return writerFeature.getID();
        }
        String fidWithoutTable = FeatureUtil.getFeatureIDWithoutTable((SimpleFeature)writerFeature);
        if (this.fmd.getKeyAtt() == null) {
            return this.fmd.getDatatypeName() + "." + fidWithoutTable;
        }
        return fidWithoutTable;
    }

    private void transformIfNecessary(SimpleFeature f) throws Exception {
        if (this.transformer.hasTransformation(this.fmd, this.dmdCol)) {
            this.transformer.getTransformer(this.fmd, this.dmdCol).invtransform2d(f);
        }
    }

    private static class CommitLog {
        private static final int MAX_ALLOWED_ERRORS = 10;
        private final StringBuilder errorMessages = new StringBuilder();
        private int countFeaturesChanged = 0;
        private int errorCount = 0;
        private Throwable lastException = null;

        private CommitLog() {
        }

        int getChangedFeaturesCount() throws Exception {
            if (this.errorMessages.length() > 0) {
                if (this.countFeaturesChanged > 0) {
                    this.errorMessages.append("\n").append(this.countFeaturesChanged).append(" Features commited successfully.").append((CharSequence)this.errorMessages);
                }
                throw new Exception(this.errorMessages.toString(), this.lastException);
            }
            return this.countFeaturesChanged;
        }

        void featureChanged() {
            ++this.countFeaturesChanged;
        }

        boolean errorLimitReached() {
            return this.errorCount > 10;
        }

        void error(String operation, String fid, Throwable e) {
            ++this.errorCount;
            this.lastException = e;
            this.errorMessages.append("\n").append(operation).append(" Feature-ID ").append(fid).append(": ").append(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }

        void error(String message, Throwable e) {
            ++this.errorCount;
            this.lastException = e;
            this.errorMessages.append("\n").append(message).append(": ").append(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private static interface FeaturesOperation {
        public void writeFeatures(CommitLog var1, Map<String, SimpleFeature> var2, Collection<String> var3, Filter var4) throws Exception;
    }

    private static interface FeatureOperation {
        public void writeFeature(CommitLog var1, FeatureWriter<SimpleFeatureType, SimpleFeature> var2, SimpleFeature var3, String var4, Map<String, SimpleFeature> var5) throws Exception;
    }
}

