/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.EFTypes;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.ExportStyle;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExportStyleFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ExportStyleFactory.class);
    public static final Map<Class<?>, ExportStyleFactory> mapExpStyleFactories = new LinkedHashMap();

    public abstract ExportStyle getExportStyle(Layer var1, SimpleFeature var2, LayerStyleCollection var3, double var4) throws Exception;

    public static ExportStyle createExportStyle(Layer ly, SimpleFeature feat, double dblExportScale) throws Exception {
        LayerStyleCollection lScol = (LayerStyleCollection)ExportStyleFactory.getStyleCollection4Scale(ly, dblExportScale);
        ExportStyleFactory expFac = ExportStyleFactory.getFactory(ly.getClass());
        if (expFac == null) {
            return null;
        }
        return expFac.getExportStyle(ly, feat, lScol, dblExportScale);
    }

    private static ExportStyleFactory getFactory(Class<?> lyClass) {
        return mapExpStyleFactories.get(lyClass);
    }

    public static void registerFactory(Class<?> lyClass, ExportStyleFactory expFac) {
        mapExpStyleFactories.put(lyClass, expFac);
    }

    public static void unregisterFactory(Class<?> lyClass) {
        mapExpStyleFactories.remove(lyClass);
    }

    public static StyleCollection getStyleCollection4Scale(Layerable ly, double dblScale) {
        Collection<StyleCollection> lstStyleCollections = ly.getStyleCollections();
        if (!ly.isScaleDependentRenderingEnabled()) {
            for (StyleCollection validStyleCollection : lstStyleCollections) {
                if (!validStyleCollection.getDefault()) continue;
                return validStyleCollection;
            }
        } else {
            double dblMinDist = Double.MAX_VALUE;
            long lngScale = (long)dblScale;
            StyleCollection nearValidStyleCollection = null;
            for (StyleCollection validStyleCollection : lstStyleCollections) {
                if (validStyleCollection.getDefault()) continue;
                double dblScaleDiffMin = Math.abs(dblScale - validStyleCollection.getMinScale());
                double dblScaleDiffMax = Math.abs(dblScale - validStyleCollection.getMaxScale());
                if (dblScaleDiffMin < dblMinDist) {
                    nearValidStyleCollection = validStyleCollection;
                }
                if (dblScaleDiffMax < dblMinDist) {
                    nearValidStyleCollection = validStyleCollection;
                }
                if (lngScale <= validStyleCollection.getMinScale().longValue() || lngScale > validStyleCollection.getMaxScale().longValue()) continue;
                return validStyleCollection;
            }
            if (nearValidStyleCollection == null) {
                Assert.shouldNeverReachHere();
            }
            return nearValidStyleCollection;
        }
        Assert.shouldNeverReachHere();
        Assert.shouldNeverReachHere();
        return null;
    }

    static {
        for (String strClassName : EFTypes.getClassnames()) {
            try {
                Class.forName(String.format("com.vividsolutions.jump.workbench.ui.plugin.io.layer.exportstylefactories.%s", strClassName));
            }
            catch (ClassNotFoundException e) {
                LOG.warn(String.format("Error in ExportStyleFactory - class '%s' not found: %s", strClassName, e.getMessage()), (Throwable)e);
            }
        }
    }
}

