/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.EditorFormat;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.WizFeatureTypePanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.editor.WizardExchangeData;
import com.vividsolutions.jump.workbench.ui.plugin.shapefile.ShapefileUtils;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import de.riwagis.guitools.Tasks;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.riwajump.workbench.ui.plugin.ImportStyleDefaults;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Collections;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.io.FilenameUtils;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class CreateDataStoreFilePlugIn
extends AbstractPlugIn {
    private static final Blackboard BB = PersistentBlackboardPlugIn.get();
    private static final String KEY_DIR = CreateDataStoreFilePlugIn.class.getName() + "_Dir";
    private final EditorFormat editorFormat;

    protected CreateDataStoreFilePlugIn(EditorFormat editorFormat) {
        this.editorFormat = editorFormat;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        JFileChooser fChoose = new JFileChooser(){

            @Override
            public void approveSelection() {
                File file = this.getSelectedFile();
                if (file == null) {
                    return;
                }
                String strFile = file.getAbsolutePath();
                if (!strFile.toLowerCase().endsWith(CreateDataStoreFilePlugIn.this.editorFormat.getFileEnding())) {
                    strFile = ShapefileUtils.addSuffix(strFile, CreateDataStoreFilePlugIn.this.editorFormat.getFileEnding());
                    file = new File(strFile);
                    this.setSelectedFile(file);
                }
                if (file.exists()) {
                    JOptionPane.showMessageDialog(this, CreateDataStoreFilePlugIn.this.editorFormat.getLocalizedFileExistsError(), I18N.get("common.error"), 0);
                } else {
                    super.approveSelection();
                }
            }
        };
        fChoose.setDialogTitle(I18N.getMessage("ui.plugin.shapefile.WizChooseFilePanel.title-edit", this.editorFormat.getLocalizedFormatName()));
        fChoose.setAcceptAllFileFilterUsed(false);
        fChoose.setFileFilter(this.editorFormat.getFileFilter());
        fChoose.setMultiSelectionEnabled(false);
        String strPath = BB.get(KEY_DIR, "");
        fChoose.setAccessory(this.editorFormat.getAccessory());
        fChoose.setCurrentDirectory(new File(strPath));
        fChoose.setApproveButtonText(I18N.get("ui.wizard.WizardDialog.next"));
        int intRetVal = fChoose.showSaveDialog(context.getWorkbenchFrame());
        if (intRetVal == 1) {
            return true;
        }
        File targetFile = fChoose.getSelectedFile();
        if (!this.isFileNameValid(targetFile)) {
            return true;
        }
        strPath = targetFile.getParent();
        BB.put(KEY_DIR, strPath);
        WizardDialog wiz = new WizardDialog((Frame)context.getWorkbenchFrame(), this.getName(), context.getWorkbenchFrame());
        wiz.setData(WizardExchangeData.FILENAME.name(), targetFile);
        String name = FilenameUtils.getBaseName((String)targetFile.toString());
        CoordinateReferenceSystem crs = context.getTask().getCRSDefinition().getCRS();
        SimpleFeatureType templateType = ImportStyleDefaults.createTemplateType(name, this.editorFormat.getGeometryName(), crs);
        WizFeatureTypePanel wizFeatureType = new WizFeatureTypePanel(context, templateType, 0, this.editorFormat);
        wiz.init(new WizardPanel[]{wizFeatureType});
        wiz.setSize(600, 500);
        wiz.setLocationRelativeTo(context.getWorkbenchFrame());
        wiz.setVisible(true);
        if (wiz.wasFinishPressed()) {
            Tasks.submit(() -> {
                DatastoreMetadata dmd = (DatastoreMetadata)wiz.getData(WizardExchangeData.DATASTORE.name());
                SimpleFeatureType fType = (SimpleFeatureType)wiz.getData(WizardExchangeData.TARGET_FEATURETYPE.name());
                this.editorFormat.createSchema(dmd, fType);
                if (fType.getGeometryDescriptor() != null) {
                    File fileToImport = (File)wiz.getData(WizardExchangeData.FILENAME.name());
                    this.editorFormat.doImport(context, Collections.singletonList(fileToImport));
                }
            });
        } else {
            DatastoreMetadata dmd = (DatastoreMetadata)wiz.getData(WizardExchangeData.DATASTORE.name());
            boolean dmdIsReferenced = context.getLayerManager().getLayerablesUnordered(Layer.class).stream().anyMatch(l -> l.getDMDCol().getByName(l.getFMD().getDatastoreName()) == dmd);
            if (!dmdIsReferenced) {
                context.getTask().getLocalDataStores().removeDatastore(dmd);
                context.getTask().reinitCachedObjects();
            }
            targetFile.delete();
        }
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return checkFactory.createTaskWindowMustBeActiveCheck();
    }

    private boolean isFileNameValid(File targetFile) {
        try {
            Path.of(targetFile.getAbsolutePath(), new String[0]);
        }
        catch (InvalidPathException e) {
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.filename-invalid-message"), (String)I18N.get("com.vividsolutions.jump.workbench.ui.plugin.io.layer.filename-invalid-title"));
            return false;
        }
        return true;
    }
}

