/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.coordinates;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.coordinates.ChooseCoordinateTool;
import com.vividsolutions.jump.workbench.ui.plugin.io.coordinates.CoordinateListTableModel;
import com.vividsolutions.jump.workbench.ui.plugin.io.coordinates.SelectedCoordinate;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayFeature;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayPlugin;
import de.riwagis.util.StringSupport;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.jts.JTSSupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportCoordinatesDialog
extends JDialog {
    private static final DecimalFormat df = new DecimalFormat();
    private static final String COORD_FILE_KEY = "ExportCoordinatesDialog_COORD_FILE";
    private static final String COORD_PREVIEW = "ExportCoordinatesDialog_PREVIEW";
    private static final Logger LOG;
    private static final GeometryFactory gfac;
    private final TableModelListener showRowCountListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            if (ExportCoordinatesDialog.this.tblCoord.getModel() != null) {
                ExportCoordinatesDialog.this.lblRowCount.setText(I18N.getMessage("ui.plugin.io.coordinates.ExportCoordinatesDialog.entrycount", ExportCoordinatesDialog.this.tblCoord.getModel().getRowCount()));
                ExportCoordinatesDialog.this.drawPreview();
            }
        }
    };
    private CoordinateListTableModel tableModel;
    private PlugInContext context;
    private int intPointNumber = 1;
    private CursorTool oldCursorTool = null;
    private final ChooseCoordinateTool coordTool = new ChooseCoordinateTool(this);
    private final String strHeaderPtNum = I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.header.pt-number");
    private final String strHeaderX = I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.header.x");
    private final String strHeaderY = I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.header.y");
    private final String strHeaderZ = I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.header.z");
    private JButton btnAddCoordinate;
    private JButton btnAddSelectedFeatures;
    private JButton btnClose;
    private JButton btnDeleteAll;
    private JButton btnDeleteSingle;
    private JButton btnDrawInMap;
    private JButton btnShowInMap;
    private JButton btnStartExport;
    private JCheckBox chkAskPointNumber;
    private JCheckBox chkDeleteAfterExport;
    private JCheckBox chkExportHeader;
    private JCheckBox chkExportHeight;
    private JCheckBox chkSelectedElementsOnly;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JLabel lblDelimiter;
    private JLabel lblRowCount;
    private JTable tblCoord;
    private JTextField txtDelimiter;

    public ExportCoordinatesDialog(Frame parent, PlugInContext context) {
        super(parent, false);
        this.initComponents();
        this.i18n();
        this.context = context;
        this.setTableModel(new CoordinateListTableModel());
        this.txtDelimiter.setText(";");
        this.tblCoord.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "selectNextColumnCell");
        this.pack();
    }

    public void setPlugInContext(PlugInContext context) {
        this.context = context;
    }

    private void setTableModel(CoordinateListTableModel model) {
        if (this.tableModel != null) {
            model.removeTableModelListener(this.showRowCountListener);
        }
        this.tableModel = model;
        if (this.tableModel != null) {
            model.addTableModelListener(this.showRowCountListener);
        }
        this.tblCoord.setModel(model);
        this.tableModel.fireTableDataChanged();
    }

    private String getUserPointNumber() {
        return Stream.generate(() -> GUISupport.inputbox((Component)this.context.getWorkbenchFrame(), (String)I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.insert-point-number"), (String)Integer.toString(this.intPointNumber))).filter(StringUtils::isNotBlank).findFirst().orElseThrow();
    }

    void addCoordinate(Coordinate coord) {
        if (this.chkAskPointNumber.isSelected()) {
            String ptNum = this.getUserPointNumber();
            this.tableModel.add(coord, ptNum);
            ++this.intPointNumber;
        } else {
            this.tableModel.add(coord, "" + this.intPointNumber);
            ++this.intPointNumber;
        }
    }

    private void clearPreview() {
        GenericOverlayPlugin.removeFeature(COORD_PREVIEW);
        this.context.getLayerViewPanel().copyTo();
    }

    private void drawPreview() {
        ArrayList<Geometry> lstGeom = new ArrayList<Geometry>();
        List<SelectedCoordinate> lstCoord = this.tableModel.getSelectedCoordinates();
        double dblWidth = this.context.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates().getWidth() / 100.0;
        for (SelectedCoordinate scoord : lstCoord) {
            Geometry geom = gfac.createPoint(scoord.getCoordinate()).buffer(dblWidth);
            lstGeom.add(geom);
        }
        GenericOverlayFeature fPreview = new GenericOverlayFeature(lstGeom, (Stroke)new BasicStroke(2.0f), Color.RED, (Stroke)new BasicStroke(), new Color(0, 0, 0, 0));
        GenericOverlayPlugin.addFeature(COORD_PREVIEW, fPreview);
        this.context.getLayerViewPanel().copyTo();
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblCoord = new JTable();
        this.lblRowCount = new JLabel();
        this.btnDeleteAll = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.btnDeleteSingle = new JButton();
        this.btnShowInMap = new JButton();
        this.btnDrawInMap = new JButton();
        this.jPanel6 = new JPanel();
        this.chkSelectedElementsOnly = new JCheckBox();
        this.chkDeleteAfterExport = new JCheckBox();
        this.btnStartExport = new JButton();
        this.chkExportHeight = new JCheckBox();
        this.chkExportHeader = new JCheckBox();
        this.lblDelimiter = new JLabel();
        this.txtDelimiter = new JTextField();
        this.jPanel2 = new JPanel();
        this.btnClose = new JButton();
        this.jPanel1 = new JPanel();
        this.btnAddSelectedFeatures = new JButton();
        this.btnAddCoordinate = new JButton();
        this.chkAskPointNumber = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("GPX-Export");
        this.setMinimumSize(new Dimension(300, 400));
        this.setName("GPXExport");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                ExportCoordinatesDialog.this.this_windowActivated(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                ExportCoordinatesDialog.this.formWindowClosing(evt);
            }

            @Override
            public void windowDeactivated(WindowEvent evt) {
                ExportCoordinatesDialog.this.this_windowDeactivated(evt);
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                ExportCoordinatesDialog.this.this_windowOpenend(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel3.setMinimumSize(new Dimension(0, 224));
        this.jPanel3.setPreferredSize(new Dimension(0, 224));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jScrollPane1.setMaximumSize(null);
        this.jScrollPane1.setMinimumSize(null);
        this.tblCoord.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.tblCoord.setMaximumSize(null);
        this.tblCoord.setMinimumSize(null);
        this.tblCoord.setPreferredSize(null);
        this.jScrollPane1.setViewportView(this.tblCoord);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jScrollPane1, gridBagConstraints);
        this.lblRowCount.setHorizontalAlignment(11);
        this.lblRowCount.setText("jLabel2");
        this.lblRowCount.setMaximumSize(null);
        this.lblRowCount.setMinimumSize(null);
        this.lblRowCount.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel3.add((Component)this.lblRowCount, gridBagConstraints);
        this.btnDeleteAll.setText("Liste leeren");
        this.btnDeleteAll.setMargin(new Insets(1, 7, 1, 7));
        this.btnDeleteAll.setMaximumSize(null);
        this.btnDeleteAll.setMinimumSize(null);
        this.btnDeleteAll.setPreferredSize(null);
        this.btnDeleteAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportCoordinatesDialog.this.btnDeleteAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.btnDeleteAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel1.setText("Auswahl:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel4.add((Component)this.jLabel1, gridBagConstraints);
        this.btnDeleteSingle.setText("l\u00f6schen");
        this.btnDeleteSingle.setMargin(new Insets(1, 7, 1, 7));
        this.btnDeleteSingle.setMaximumSize(null);
        this.btnDeleteSingle.setMinimumSize(null);
        this.btnDeleteSingle.setPreferredSize(null);
        this.btnDeleteSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportCoordinatesDialog.this.btnDeleteSingleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel4.add((Component)this.btnDeleteSingle, gridBagConstraints);
        this.btnShowInMap.setText("in Karte anzeigen");
        this.btnShowInMap.setMargin(new Insets(1, 7, 1, 7));
        this.btnShowInMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportCoordinatesDialog.this.btnShowInMapActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel4.add((Component)this.btnShowInMap, gridBagConstraints);
        this.btnDrawInMap.setText("in Karte zeichnen");
        this.btnDrawInMap.setMargin(new Insets(1, 7, 1, 7));
        this.btnDrawInMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportCoordinatesDialog.this.btnDrawInMapActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel4.add((Component)this.btnDrawInMap, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel6.setBorder(BorderFactory.createTitledBorder("Export"));
        this.jPanel6.setLayout(new GridBagLayout());
        this.chkSelectedElementsOnly.setText("Nur ausgew\u00e4hlte Elemente exportieren");
        this.chkSelectedElementsOnly.setMaximumSize(null);
        this.chkSelectedElementsOnly.setMinimumSize(null);
        this.chkSelectedElementsOnly.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel6.add((Component)this.chkSelectedElementsOnly, gridBagConstraints);
        this.chkDeleteAfterExport.setText("Nach Export aus Liste entfernen");
        this.chkDeleteAfterExport.setMaximumSize(null);
        this.chkDeleteAfterExport.setMinimumSize(null);
        this.chkDeleteAfterExport.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel6.add((Component)this.chkDeleteAfterExport, gridBagConstraints);
        this.btnStartExport.setText("Export starten");
        this.btnStartExport.setMargin(new Insets(1, 7, 1, 7));
        this.btnStartExport.setMaximumSize(null);
        this.btnStartExport.setMinimumSize(null);
        this.btnStartExport.setPreferredSize(null);
        this.btnStartExport.setSelected(true);
        this.btnStartExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportCoordinatesDialog.this.btnStartExportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel6.add((Component)this.btnStartExport, gridBagConstraints);
        this.chkExportHeight.setText("H\u00f6hen ausgeben");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel6.add((Component)this.chkExportHeight, gridBagConstraints);
        this.chkExportHeader.setText("Spalten\u00fcberschriften ausgeben");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel6.add((Component)this.chkExportHeader, gridBagConstraints);
        this.lblDelimiter.setText("Trennzeichen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.jPanel6.add((Component)this.lblDelimiter, gridBagConstraints);
        this.txtDelimiter.setMaximumSize(new Dimension(50, 20));
        this.txtDelimiter.setMinimumSize(new Dimension(50, 20));
        this.txtDelimiter.setPreferredSize(new Dimension(50, 20));
        this.txtDelimiter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ExportCoordinatesDialog.this.txtDelimiter_onFocusLost(evt);
            }
        });
        this.txtDelimiter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ExportCoordinatesDialog.this.txtDelimiter_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel6.add((Component)this.txtDelimiter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel2.setRequestFocusEnabled(false);
        this.jPanel2.setLayout(new GridBagLayout());
        this.btnClose.setText("Schliessen");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportCoordinatesDialog.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel2.add((Component)this.btnClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.btnAddSelectedFeatures.setText("aus Auswahl hinzuf\u00fcgen");
        this.btnAddSelectedFeatures.setToolTipText("Selektierte Objekte aus Karte hinzuf\u00fcgen");
        this.btnAddSelectedFeatures.setMargin(new Insets(1, 7, 1, 7));
        this.btnAddSelectedFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportCoordinatesDialog.this.btnAddSelectedFeaturesActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnAddSelectedFeatures);
        this.btnAddCoordinate.setText("Koordinate hinzuf\u00fcgen");
        this.btnAddCoordinate.setToolTipText("Selektierte Objekte aus Karte hinzuf\u00fcgen");
        this.btnAddCoordinate.setMargin(new Insets(1, 7, 1, 7));
        this.btnAddCoordinate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportCoordinatesDialog.this.btnAddCoordinateActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnAddCoordinate);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.chkAskPointNumber.setText("Nach Punktnummer fragen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.chkAskPointNumber, gridBagConstraints);
        this.pack();
    }

    private void i18n() {
        this.setTitle(I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.title"));
        this.btnClose.setText(I18N.get("common.close"));
        this.btnDeleteAll.setText(I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.delete-all"));
        this.btnDeleteSingle.setText(I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.delete-single"));
        this.btnShowInMap.setText(I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.show-in-map"));
        this.btnStartExport.setText(I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.start-export"));
        this.chkDeleteAfterExport.setText(I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.delete-after-export"));
        this.chkSelectedElementsOnly.setText(I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.only-selected"));
        this.btnAddSelectedFeatures.setText(I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.add-selected"));
        this.btnAddSelectedFeatures.setToolTipText(I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.add-selected"));
        this.btnAddCoordinate.setText(I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.add-coord"));
        this.btnAddCoordinate.setToolTipText(I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.add-coord"));
        this.chkAskPointNumber.setText(I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.ask-point-number"));
        this.chkExportHeight.setText(I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.export-height"));
        this.chkExportHeader.setText(I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.export-header"));
        this.lblDelimiter.setText(I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.delimiter"));
    }

    private void btnDeleteAllActionPerformed(ActionEvent evt) {
        if (this.tableModel != null) {
            this.tableModel.deleteAllEntries();
            this.intPointNumber = 1;
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.doOnCloseWindow();
        this.setVisible(false);
    }

    private void btnStartExportActionPerformed(ActionEvent evt) {
        int state;
        JFileChooser fileChooser = GUIUtil.createJFileChooserWithOverwritePrompting();
        FileFilter fFilterTxt = GUIUtil.createFileFilter(I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.FileFilterNameTxt"), new String[]{"txt"});
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(fFilterTxt);
        Object strFile = PersistentBlackboardPlugIn.get().get(COORD_FILE_KEY, "");
        if (((String)strFile).length() > 0) {
            fileChooser.setSelectedFile(new File((String)strFile));
        }
        if ((state = fileChooser.showSaveDialog(this.context.getWorkbenchFrame())) == 1 || state == -1) {
            return;
        }
        strFile = fileChooser.getSelectedFile().toString();
        if (!((String)strFile).toLowerCase().endsWith(".txt")) {
            strFile = (String)strFile + ".txt";
        }
        PersistentBlackboardPlugIn.get().put(COORD_FILE_KEY, strFile);
        Object strFileFin = strFile;
        Runnable runExp = () -> this.lambda$btnStartExportActionPerformed$1((String)strFileFin);
        WaitDialog dlgWait = new WaitDialog((Window)this, I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.export-running"), runExp);
        dlgWait.setVisible(true);
    }

    private void btnDeleteSingleActionPerformed(ActionEvent evt) {
        this.tableModel.deleteEntries(this.tblCoord.getSelectedRows());
    }

    private void btnShowInMapActionPerformed(ActionEvent evt) {
        this.drawPreview();
        int[] intRows = this.tblCoord.getSelectedRows();
        List<SelectedCoordinate> lstCoord = this.tableModel.getSelectedCoordinates();
        Envelope env = new Envelope();
        ArrayList<Coordinate> lstCoordFlash = new ArrayList<Coordinate>();
        for (int row : intRows) {
            Coordinate coord = lstCoord.get(row).getCoordinate();
            env.expandToInclude(coord);
            lstCoordFlash.add(coord);
        }
        Envelope envVisi = this.context.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
        if (!envVisi.contains(env)) {
            env.expandBy(env.getWidth() * 0.2);
            this.context.getLayerViewPanel().getViewport().zoom(env);
        }
        Coordinate[] arrCoord = lstCoordFlash.toArray(new Coordinate[0]);
        Runnable flashRunner = () -> {
            try {
                Thread.sleep(500L);
                while (this.context.getLayerViewPanel().getRenderingManager().isRendering()) {
                    Thread.sleep(500L);
                }
                this.context.getLayerViewPanel().flash((GeometryCollection)gfac.createMultiPointFromCoords(arrCoord), Color.BLUE, 200);
                Thread.sleep(400L);
                this.context.getLayerViewPanel().flash((GeometryCollection)gfac.createMultiPointFromCoords(arrCoord), Color.BLUE, 200);
                Thread.sleep(400L);
                this.context.getLayerViewPanel().flash((GeometryCollection)gfac.createMultiPointFromCoords(arrCoord), Color.BLUE, 200);
            }
            catch (InterruptedException e) {
                LOG.error("Flash failed", (Throwable)e);
            }
        };
        Thread thFlash = new Thread(flashRunner, "flash_coordinates");
        thFlash.start();
    }

    private void doOnCloseWindow() {
        if (this.oldCursorTool != null) {
            this.context.getLayerViewPanel().setCurrentCursorTool(this.oldCursorTool);
            this.oldCursorTool = null;
        }
        this.clearPreview();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.doOnCloseWindow();
    }

    private void btnAddSelectedFeaturesActionPerformed(ActionEvent evt) {
        WaitDialog dlgWait = new WaitDialog((Window)this, I18N.get("common.wait"), new Runnable(){

            @Override
            public void run() {
                int oldCount = ExportCoordinatesDialog.this.tableModel.getRowCount();
                boolean isFireingInsertEvents = ExportCoordinatesDialog.this.tableModel.isFiringInsertEvents();
                ExportCoordinatesDialog.this.tableModel.setFiringInsertEvents(false);
                for (Geometry geom : ExportCoordinatesDialog.this.context.getLayerViewPanel().getSelectionManager().getSelectedItems()) {
                    if (geom == null || geom.isEmpty()) continue;
                    Coordinate[] arrCoord = JTSSupport.removeDuplicates((Coordinate[])geom.getCoordinates());
                    if (arrCoord.length == 1) {
                        ExportCoordinatesDialog.this.addCoordinate(arrCoord[0]);
                        continue;
                    }
                    for (Coordinate coord : arrCoord) {
                        ExportCoordinatesDialog.this.tableModel.add(coord, "" + ExportCoordinatesDialog.this.intPointNumber);
                        ++ExportCoordinatesDialog.this.intPointNumber;
                    }
                }
                ExportCoordinatesDialog.this.tableModel.setFiringInsertEvents(isFireingInsertEvents);
                ExportCoordinatesDialog.this.tableModel.fireTableRowsInserted(oldCount, ExportCoordinatesDialog.this.tableModel.getRowCount() - 1);
            }
        });
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)this.context.getWorkbenchFrame(), (Throwable)dlgWait.getError(), (String)"riwagis");
        }
        dlgWait.dispose();
    }

    private void btnAddCoordinateActionPerformed(ActionEvent evt) {
        CursorTool tempCursor = this.context.getLayerViewPanel().getCurrentCursorTool();
        if (this.oldCursorTool == null) {
            this.oldCursorTool = tempCursor;
        }
        QuasimodeTool quasimodeTool = QuasimodeTool.addStandardQuasimodes(this.coordTool);
        this.context.getLayerViewPanel().setCurrentCursorTool(quasimodeTool);
    }

    private void btnDrawInMapActionPerformed(ActionEvent evt) {
        Collection<RedlineLayer> lstRly = this.context.getLayerManager().getLayerables(RedlineLayer.class);
        if (lstRly.isEmpty()) {
            GUISupport.msgbox((Component)this, (String)I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.no-redline-layers"), (String)I18N.get("common.error"));
            return;
        }
        final RedlineLayer rly = (RedlineLayer)GUISupport.inputbox((Component)this, (String)I18N.get("ui.plugin.io.coordinates.ExportCoordinatesDialog.select-redline-layer"), (Object[])lstRly.toArray());
        final int[] rows = this.tblCoord.getSelectedRows();
        final List<SelectedCoordinate> lstSelCoord = this.tableModel.getSelectedCoordinates();
        UndoableCommand cmd = new UndoableCommand(this, "draw coordinates"){
            private final List<SimpleFeature> lstFeat;
            {
                super(name);
                this.lstFeat = new ArrayList<SimpleFeature>();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                try {
                    rly.setUseDefaultFeature(false);
                    for (int row : rows) {
                        SimpleFeature dfeat = rly.getDefaultFeature();
                        SelectedCoordinate scoord = (SelectedCoordinate)lstSelCoord.get(row);
                        Point geom = gfac.createPoint(scoord.getCoordinate());
                        SimpleFeature feat = FeatureUtil.createFeature((SimpleFeatureType)rly.getFeatureType(), (Geometry)geom);
                        FeatureUtil.copyFeatureData((SimpleFeature)dfeat, (SimpleFeature)feat);
                        FeatureUtil.setAttribute((SimpleFeature)feat, (String)"symsize", (Object)12);
                        FeatureUtil.setAttribute((SimpleFeature)feat, (String)"symbol", (Object)"cross.svg");
                        feat.setDefaultGeometry((Object)geom);
                        this.lstFeat.add(feat);
                        feat = FeatureUtil.createFeature((SimpleFeatureType)rly.getFeatureType(), (Geometry)geom);
                        FeatureUtil.copyFeatureData((SimpleFeature)dfeat, (SimpleFeature)feat);
                        FeatureUtil.setAttribute((SimpleFeature)feat, (String)"text", (Object)(" " + scoord.getPtNumber()));
                        FeatureUtil.setAttribute((SimpleFeature)feat, (String)"textsize", (Object)12);
                        feat.setDefaultGeometry((Object)geom);
                        this.lstFeat.add(feat);
                    }
                    rly.editFeature(this.lstFeat, 1);
                }
                finally {
                    rly.setUseDefaultFeature(true);
                }
            }

            @Override
            public void unexecute() {
                rly.editFeature(this.lstFeat, 3);
            }
        };
        AbstractPlugIn.execute(cmd, (LayerManagerProxy)this.context);
    }

    private void txtDelimiter_onFocusLost(FocusEvent evt) {
        if (this.txtDelimiter.getText().length() == 0) {
            this.txtDelimiter.setText(";");
        }
    }

    private void txtDelimiter_onKeyReleased(KeyEvent evt) {
        if (this.txtDelimiter.getText().length() > 1) {
            this.txtDelimiter.setText(this.txtDelimiter.getText().substring(0, 1));
        }
        if (this.txtDelimiter.getText().equals(".")) {
            this.txtDelimiter.setText(";");
        }
        if (StringSupport.isNumeric((String)this.txtDelimiter.getText())) {
            this.txtDelimiter.setText(";");
        }
    }

    private void this_windowOpenend(WindowEvent evt) {
        this.drawPreview();
    }

    private void this_windowActivated(WindowEvent evt) {
        this.drawPreview();
    }

    private void this_windowDeactivated(WindowEvent evt) {
    }

    private /* synthetic */ void lambda$btnStartExportActionPerformed$1(String strFileFin) {
        boolean bolOnlySelected = this.chkSelectedElementsOnly.isSelected();
        boolean bolDelete = this.chkDeleteAfterExport.isSelected();
        boolean bolHeader = this.chkExportHeader.isSelected();
        boolean bolHeight = this.chkExportHeight.isSelected();
        String strDelim = this.txtDelimiter.getText();
        if (strDelim.length() == 0) {
            strDelim = ";";
        }
        try (PrintWriter pw = new PrintWriter(new FileWriter(strFileFin));){
            if (bolHeader) {
                String strHeader = this.strHeaderPtNum + strDelim + this.strHeaderX + strDelim + this.strHeaderY;
                if (bolHeight) {
                    strHeader = strHeader + strDelim + this.strHeaderZ;
                }
                pw.println(strHeader);
            }
            List<SelectedCoordinate> lstCoord = this.tableModel.getSelectedCoordinates();
            int[] rows = this.tblCoord.getSelectedRows();
            if (bolOnlySelected) {
                ArrayList<SelectedCoordinate> lstCoordNew = new ArrayList<SelectedCoordinate>();
                for (int row : rows) {
                    lstCoordNew.add(lstCoord.get(row));
                }
                lstCoord = lstCoordNew;
            }
            for (SelectedCoordinate scoord : lstCoord) {
                String strPtNum = scoord.getPtNumber();
                if (strPtNum.indexOf(strDelim) > 0) {
                    strPtNum = strPtNum.replaceAll("\\" + strDelim, "");
                }
                String strLine = strPtNum + strDelim + df.format(scoord.getCoordinate().x) + strDelim + df.format(scoord.getCoordinate().y);
                if (bolHeight) {
                    strLine = Double.isNaN(scoord.getCoordinate().getZ()) ? strLine + strDelim : strLine + strDelim + df.format(scoord.getCoordinate().getZ());
                }
                pw.println(strLine);
            }
            if (bolDelete) {
                if (bolOnlySelected) {
                    this.tableModel.deleteEntries(rows);
                } else {
                    this.tableModel.deleteAllEntries();
                }
            }
        }
        catch (IOException ex) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)ex, (String)"Error writing coordinate file");
        }
    }

    static {
        df.setGroupingUsed(false);
        df.setMaximumFractionDigits(10);
        df.setMinimumFractionDigits(0);
        DecimalFormatSymbols decSyms = new DecimalFormatSymbols();
        decSyms.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(decSyms);
        LOG = LoggerFactory.getLogger(ExportCoordinatesDialog.class);
        gfac = new GeometryFactory();
    }
}

