/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.io.coordinates;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.plugin.io.coordinates.SelectedCoordinate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.locationtech.jts.geom.Coordinate;

public class CoordinateListTableModel
extends DefaultTableModel
implements Iterable<SelectedCoordinate> {
    private final List<SelectedCoordinate> selectedCoordinatesList = new LinkedList<SelectedCoordinate>();
    private boolean firingInsertEvents = true;

    public List<SelectedCoordinate> getSelectedCoordinates() {
        LinkedList<SelectedCoordinate> selectedCoordinatesListExp = new LinkedList<SelectedCoordinate>();
        selectedCoordinatesListExp.addAll(this.selectedCoordinatesList);
        return selectedCoordinatesListExp;
    }

    public boolean isFiringInsertEvents() {
        return this.firingInsertEvents;
    }

    public void setFiringInsertEvents(boolean firingInsertEvents) {
        this.firingInsertEvents = firingInsertEvents;
    }

    void add(Coordinate coord, String pt_number) {
        this.selectedCoordinatesList.add(new SelectedCoordinate(coord, pt_number));
        if (this.firingInsertEvents) {
            this.fireTableRowsInserted(this.selectedCoordinatesList.size() - 1, this.selectedCoordinatesList.size() - 1);
        }
    }

    @Override
    public int getRowCount() {
        return this.selectedCoordinatesList == null ? 0 : this.selectedCoordinatesList.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return I18N.get("ui.plugin.io.coordinates.CoordinateListTableModel.pt-number");
            }
            case 1: {
                return I18N.get("ui.plugin.io.coordinates.CoordinateListTableModel.coord");
            }
        }
        return super.getColumnName(column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        SelectedCoordinate currSelectedCoordinate = this.selectedCoordinatesList.get(row);
        switch (column) {
            case 0: {
                return currSelectedCoordinate.getPtNumber();
            }
            case 1: {
                return currSelectedCoordinate.getCoordinate().toString();
            }
        }
        return super.getValueAt(row, column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (this.isCellEditable(row, column)) {
            SelectedCoordinate currSelectedCoord = this.selectedCoordinatesList.get(row);
            switch (column) {
                case 0: {
                    currSelectedCoord.setPtNumber(aValue != null ? aValue.toString().trim() : null);
                }
            }
        }
    }

    public void deleteEntry(int index) {
        SelectedCoordinate sl = this.selectedCoordinatesList.remove(index);
        this.fireTableRowsDeleted(Math.min(index - 1, 0), index);
    }

    void deleteAllEntries() {
        this.selectedCoordinatesList.clear();
        this.fireTableDataChanged();
    }

    void deleteEntries(Collection<SelectedCoordinate> delObj) {
        for (SelectedCoordinate curDelObj : delObj) {
            this.selectedCoordinatesList.remove(curDelObj);
        }
        this.fireTableDataChanged();
    }

    void deleteEntries(int[] selectedRows) {
        ArrayList<SelectedCoordinate> delObj = new ArrayList<SelectedCoordinate>();
        for (int idx : selectedRows) {
            delObj.add(this.selectedCoordinatesList.get(idx));
        }
        this.deleteEntries(delObj);
    }

    public SelectedCoordinate getEntry(int row) {
        return this.selectedCoordinatesList.get(row);
    }

    @Override
    public Iterator<SelectedCoordinate> iterator() {
        return this.selectedCoordinatesList.iterator();
    }
}

