/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.interfaces;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import de.riwagis.gis.context.module.interfaces.SelectionExternalCall;
import java.util.Collection;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalCallPlugin
extends AbstractPlugIn {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExternalCallPlugin.class);
    private final SelectionExternalCall selectionExternalCall;

    public ExternalCallPlugin(SelectionExternalCall selectionExternalCall) {
        this.selectionExternalCall = selectionExternalCall;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        JUMPWorkbench.GIS_CONTEXT.getModuleApp().invokeExternalCallForSelection(this.selectionExternalCall.getName());
        return true;
    }

    @Override
    public String getName() {
        return this.selectionExternalCall.getDisplayName();
    }

    @Override
    public EnableCheck createEnableCheck() {
        return c -> {
            boolean selectionContainsItemsForCall = JUMPWorkbench.GIS_CONTEXT.getModuleApp().isSelectionValidForExternalCall(this.selectionExternalCall.getName());
            if (!selectionContainsItemsForCall) {
                return I18N.get("com.vividsolutions.jump.workbench.ui.plugin.interfaces.ExternalCallPlugin.no-matching-layers");
            }
            return null;
        };
    }

    public static void registerExternalCalls(JPopupMenu popupMenu, FeatureInstaller featureInstaller) {
        if (!JUMPWorkbench.gisContextAvailable()) {
            return;
        }
        Collection selectionExternalCalls = JUMPWorkbench.GIS_CONTEXT.getModuleApp().getUserTriggerableExternalCalls();
        if (selectionExternalCalls.isEmpty()) {
            return;
        }
        JMenu subMenu = new JMenu(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.interfaces.ExternalCallPlugin.interface-functions"));
        popupMenu.add(subMenu);
        for (SelectionExternalCall call : selectionExternalCalls) {
            ExternalCallPlugin callPlugin = new ExternalCallPlugin(call);
            featureInstaller.addJMenuItem(subMenu, callPlugin, callPlugin.getName(), false, null, callPlugin.createEnableCheck());
        }
    }
}

